/************************************************************************/
/* Copyright 1997 MBARI							*/
/************************************************************************/
/* Summary  : Program to merge processed ARGOS data files		*/
/* Filename : argmerge.c						*/
/* Author   : Bob Herlien (rah)						*/
/* Project  : OASIS							*/
/* Version  : 1.0							*/
/* Created  : 01/13/97							*/
/************************************************************************/
/* Modification History:						*/
/* 13jan97 rah - created						*/
/************************************************************************/

#include <stdio.h>			/* Unix standard I/O		*/
#include <mbariTypes.h>		/* MBARI standard types		*/
#include <mbariConst.h>		/* MBARI standard constants	*/

#define BUFSIZE		1024


/************************************************************************/
/* Function    : main							*/
/* Purpose     : Main routine						*/
/* Inputs      : argc, argv						*/
/* Outputs     : Integer, 0 for success, 1 for failure			*/
/************************************************************************/
	Int32
main( Int32 argc, char **argv )
{
    Int32		day1, hits1, pos1, day2, hits2, pos2;
    char		buff1[BUFSIZE], buff2[BUFSIZE];

    gets( buff1 );

    while ( gets(buff2) != NULL )
    {
	if ( (sscanf(buff1, " %d %d%n", &day1, &hits1, &pos1) >= 2) &&
	     (sscanf(buff2, " %d %d%n", &day2, &hits2, &pos2) >= 2) &&
	     (day1 == day2) &&
	     (strcmp(&buff1[pos1], &buff2[pos2]) == 0) )
	    sprintf( buff1, "%5d %3d%s", day1, hits1 + hits2, &buff2[pos2] );
	else
	{
	    puts( buff1 );
	    strcpy( buff1, buff2 );
	}
    }

    puts( buff1 );

} /* main() */
