/******************************************************************************\
**	exchange.c
**	
**	First release:			10/08/2001
**	Update release:			10/10/2002
*****************************************************************************
**	
**	Developed by:	Thomas P. Sullivan
**	tpsully@persistor.com - http://www.persistor.com
**	Copyright (C) 2000 Persistor Instruments Inc.	All rights reserved.
**	
*****************************************************************************
** 
** Copyright and License Information
** 
** Persistor Instruments Inc. (hereafter, PII) grants you (hereafter,
** Licensee) a non-exclusive, non-transferable license to use the software
** source code contained in this single source file with hardware products
** sold by PII. Licensee may distribute binary derivative works using this
** software and running on PII hardware products to third parties without
** fee or other restrictions.
** 
** PII MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
** SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
** IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
** OR NON-INFRINGEMENT. PII SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
** LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THE SOFTWARE OR
** ITS DERIVATIVES.
** 
** By using or copying this Software, Licensee agrees to abide by the
** copyright law and all other applicable laws of the U.S. including, but
** not limited to, export control laws, and the terms of this license. PII
** shall have the right to terminate this license immediately by written
** notice upon Licensee's breach of, or non-compliance with, any of its
** terms. Licensee may be held legally responsible for any copyright
** infringement or damages resulting from Licensee's failure to abide by
** the terms of this license. 
**	
**	
*****************************************************************************
**	
**	Generic QSPI data exchange function.
**	
\******************************************************************************/

#include	<cf1bios.h>		// Persistor CF1 System and I/O Definitions
#include	<cf1pico.h>		// Persistor CF1 PicoDOS Definitions  

#include	<stat.h>		// CF1 POSIX-like File Status Definitions
#include	<fcntl.h>		// CF1 POSIX-like File Access Definitions
#include	<unistd.h>		// CF1 POSIX-like UNIX Function Definitions
#include	<dirent.h>		// CF1 POSIX-like Directory Access Definitions
#include	<termios.h>		// CF1 POSIX-like Terminal I/O Definitions
#include	<dosdrive.h>	// CF1 DOS Drive and Directory Definitions

#include	<assert.h>
#include	<ctype.h>
#include	<errno.h>
#include	<float.h>
#include	<limits.h>
#include	<locale.h>
#include	<math.h>
#include	<setjmp.h>
#include	<signal.h>
#include	<stdarg.h>
#include	<stddef.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<time.h>

#include "exchange.h"

//#define DEBUG		//Comment this line out to prevent all the extra messages
#ifdef DEBUG
  #define	DBG(X)	X	// template:	DBG( cprintf("\n"); )
  #pragma message	("!!! "__FILE__ ": Don't ship with DEBUG compile flag set!")
#else
  #define	DBG(X)		// nothing
#endif

////////////////////////////////////////////////////////////////////////
// Name:		ExchangeGeneric
// Description: Transmits usCount words using the QSPI
// Parameters: 	QPB ptrQPBDev - Pointer to device QSPI device structure
//				ushort *usCmd - Pointer to an array of data to be sent
//				ushort usCount - Number of words in usCmd to send
//				ushort *usData - Pointer to an array of received words
// Returns: 	bool true if succesful or false otherwise
////////////////////////////////////////////////////////////////////////
bool ExchangeGeneric(QPB *ptrQPBDev, ushort *usCmd, ushort usCount, ushort *usData)
{
	short nLoop;
	if(ptrQPBDev != NULL)
	{
		ptrQPBDev->dev->xfrCount = usCount;	//Tell it how many we're doing
		DBG(cprintf("\nBefore QPBTransact\n\n");)
		QPBTransact(ptrQPBDev, 0, ptrQPBDev->dev->xfrCount, usCmd);	//The work is done here
		DBG(cprintf("\nAfter QPBTransact\n\n");)

//			Move the received words to the location you passed
//			NOTE: 	You could use memcpy or something else here but I used a simple
//					loop so it was clear. 
//			NOTE:	This is a little redundant becuase you could always access the data directly.
//					ExchangeGeneric was written to make using the QSPI easier.  Once you have mastered
//					using it, you may want to use the individual calls used here directly
//					in your own code.  This will help to make your application faster.  If you are
//					new to the QSPI then just use this function until you are comfortable with what
//					it is doing.
		DBG(cprintf("\nBefore Loop\n\n");)
		for(nLoop=0;nLoop<usCount;nLoop++)	//Transfer our received data to usData
		{
			usData[nLoop] = ptrQPBDev->dev->rcvData[nLoop];	//One word at a time
		}

		DBG(cprintf("\nAfter Loop\n\n");)
		return true;	//Success!
	}
	else
	{
		return false;	//Fail (device structure was NULL)
	}
}	//____ ExchangeGeneric() ____//
