function theResult = NCBMenu(self)

% NCBMenu -- Menus for NCBrowser.
%  NCBMenu(self) creates the menus for self,
%   an NCBrowser.
 
% Copyright (C) 1997 Dr. Charles R. Denham, ZYDECO.
%  All Rights Reserved.
%   Disclosure without explicit written consent from the
%    copyright owner does not constitute publication.
 
% Version of 21-Apr-1997 11:09:13.

if nargin < 1, help(mfilename), return, end

theFigure = self.itSelf;

% The following uses string-matrices, because
%  the Matlab makemenu() function has not been
%  upgraded for Matlab-5 cell-arrays.

theLabels = str2mat( ...
   '<NetCDF>', ...
   '>About NCBrowser', ...
   '>-', ...
   '>New', ...
   '>>NetCDF...', ...
   '>>-', ...
   '>>Dimension...', ...
   '>>Variable...', ...
   '>>Attribute...', ...
   '>Open...', ...
   '>-', ...
   '>Save', ...
   '>Save As...', ...
   '>-', ...
   '>Done', ...
   '<Edit>', ...
   '>Undo', ...
   '>-', ...
   '>Cut', ...
   '>Copy', ...
   '>Paste', ...
   '>Delete', ...
   '>-', ...
   '>Select All', ...
   '>-', ...
   '>Show Clipboard', ...
   '<Rename>', ...
   '>Conventions', ...
   '>>_FillValue', ...
   '>>missing_value', ...
   '>>-', ...
   '>>scale_factor', ...
   '>>add_offset', ...
   '>>-', ...
   '>>units', ...
   '>>-', ...
   '>>minimum_value', ...
   '>>maximum_value', ...
   '>>valid_range', ...
   '>>-', ...
   '>>C_format', ...
   '>>FORTRAN_format', ...
   '>>-', ...
   '>>title', ...
   '>>history', ...
   '>>comment', ...
   '>>-', ...
   '>>description', ...
   '>>generic_name', ...
   '>>long_name', ...
   '>>short_name', ...
   '>>-', ...
   '>>epic_code', ...
   '>-', ...
   '>Rename...', ...
   '>-', ...
   '>Lowercase', ...
   '>Uppercase', ...
   '>-', ...
   '>Resize...', ...
   '<Graph>', ...
   '>Line', ...
   '>Circles', ...
   '>Dots', ...
   '>-', ...
   '>Degrees', ...
   '>-', ...
   '>Contour', ...
   '>Image', ...
   '>Mesh', ...
   '>Surf', ...
   '>-', ...
   '>PXLine', ...
   '>-', ...
   '>Show Graph' ...
   );

theCallback = 'ncbevent(''MenuCallback'')';
theCalls = str2mat( ...
   '', ...            % NetCDF.
   theCallback, ...      % About NCBrowser.
   '', ...
   theCallback, ...      % New
   theCallback, ...         % NetCDF...
   '', ...
   theCallback, ...         % Dimension.
   theCallback, ...         % Variable.
   theCallback, ...         % Attribute.
   theCallback, ...      % Open...
   '', ...
   theCallback, ...      % Save.
   theCallback, ...      % Save As...
   '', ...
   theCallback, ...      % Done.
   '', ...            % Edit
   '', ...               % Undo.
   '', ...
   '', ...               % Cut.
   theCallback, ...      % Copy.
   theCallback, ...      % Paste.
   '', ...               % Clear.
   '', ...
   theCallback, ...      % Select All.
   '', ...
   theCallback, ...      % Show Clipboard.
   '', ...            % Rename.
   '', ...               % Conventions.
   theCallback, ...         % _FillValue.
   theCallback, ...         % missing_value.
   '', ...
   theCallback, ...         % scale_factor.
   theCallback, ...         % add_offset.
   '', ...
   theCallback, ...         % units.
   '', ...
   theCallback, ...         % minimum_value.
   theCallback, ...         % minimum_value.
   theCallback, ...         % valid_range.
   '', ...
   theCallback, ...         % C_format.
   theCallback, ...         % FORTRAN_format.
   '', ...
   theCallback, ...         % title.
   theCallback, ...         % history.
   theCallback, ...         % comment.
   '', ...
   theCallback, ...         % description.
   theCallback, ...         % generic_name.
   theCallback, ...         % short_name.
   theCallback, ...         % long_name.
   '', ...
   theCallback, ...         % epic_code.
   '', ...
   theCallback, ...      % Rename...
   '', ...
   theCallback, ...      % Lowercase...
   theCallback, ...      % Uppercase...
   '', ...
   theCallback, ...      % Resize...
   '', ...            % Graph.
   theCallback, ...      % Line.
   theCallback, ...      % Circles.
   theCallback, ...      % Dots.
   '', ...
   theCallback, ...      % Mod.
   '', ...
   theCallback, ...      % Contour.
   theCallback, ...      % Image.
   theCallback, ...      % Mesh.
   theCallback, ...      % Surf.
   '', ...
   theCallback, ...      % PXLine.
   '', ...
   theCallback ...       % Show Graph.
   );

theTags = theLabels;

theMenus = makemenu(theFigure, theLabels, theCalls, theTags);

% Disabled menus.

f = findobj(theFigure, 'Type', 'uimenu');
for i = length(f):-1:1
   theSubMenus = get(f(i), 'Children');
   if isempty(theSubMenus)
      theCall = get(f(i), 'Callback');
      if isempty(theCall) | all(theCall == ' ')
         set(f(i), 'Enable', 'off')
      end
   end
end

if nargout > 0, theResult = theMenus; end
