/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import org.mbari.io.OasisPco2Reader;
import org.mbari.util.MathUtil;
import ucar.ma2.ArrayAbstract;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;

public class Pco2Coards {
    private OasisPco2Reader infile;
    private File outfile;
    private File calfile;
    private String mooring;
    private static final String[] TYPES = new String[]{"d"};
    private static final String[] POSTFIX = new String[]{""};
    private static final String[] PREFIX = new String[]{""};

    public Pco2Coards(String mooring, String infile, String calfile, String outfile) throws IOException {
        this(mooring, new File(infile), new File(calfile), new File(outfile));
    }

    public Pco2Coards(String mooring, File infile, File calfile, File outfile) throws IOException {
        this.mooring = mooring;
        this.infile = new OasisPco2Reader(infile);
        this.calfile = calfile;
        this.outfile = outfile;
        this.makeNetcdf();
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            System.out.println("\nUsage: org.mbari.oasis.Pco2Coatds <mooring> <input file> <properties file>  <output file>\n");
            System.out.println("\nInputs: <mooring>         = mooring id (ex. M1 or M2)");
            System.out.println("        <input file>      = pCO2 data file (ex. /oasis/m1/data/pco2)");
            System.out.println("        <properties file> = mooring properties file (ex. /oasis/cfg/mooring.properties)");
            System.out.println("        <output file>     = name of the Coards netcdf file to create");
            System.exit(0);
        }
        try {
            Pco2Coards pco2Coards = new Pco2Coards(args[0], args[1], args[2], args[3]);
        }
        catch (IOException e) {
            System.out.println(" Error: ".concat(String.valueOf(String.valueOf(e.getMessage()))));
            e.printStackTrace();
        }
    }

    private void makeNetcdf() throws IOException {
        String varName;
        int j;
        int[] order;
        int i;
        Properties mooringProperties = new Properties();
        BufferedInputStream mooringPropertiesStream = new BufferedInputStream(new FileInputStream(this.calfile));
        mooringProperties.load(mooringPropertiesStream);
        mooringPropertiesStream.close();
        float[] lat = new float[]{Float.parseFloat(mooringProperties.getProperty(String.valueOf(String.valueOf(this.mooring)).concat(".latitude"), "-999"))};
        float[] lon = new float[]{Float.parseFloat(mooringProperties.getProperty(String.valueOf(String.valueOf(this.mooring)).concat(".longitude"), "-999"))};
        float[] depth = new float[]{Float.parseFloat(mooringProperties.getProperty(String.valueOf(String.valueOf(this.mooring)).concat(".waterdepth"), "-999"))};
        NetcdfFileWriteable ncfile = new NetcdfFileWriteable();
        ncfile.setName(this.outfile.getCanonicalPath());
        ncfile.addGlobalAttribute("conventions", "MBARI/timeSeries/mooring/pco2");
        ncfile.addGlobalAttribute("creationDate", new Date().toString());
        ncfile.addGlobalAttribute("lastModified", new Date().toString());
        ncfile.addGlobalAttribute("mooring", this.mooring.toUpperCase());
        ncfile.addGlobalAttribute("description", "pCO2 data");
        ncfile.addGlobalAttribute("waterdepth", (Object)depth);
        ncfile.addGlobalAttribute("keywords", "pCO2, mooring");
        ncfile.addGlobalAttribute("instrumentType", "pCO2 Can");
        Dimension latDim = ncfile.addDimension("latitude", 1);
        Dimension lonDim = ncfile.addDimension("longitude", 1);
        ncfile.addVariable("latitude", Float.TYPE, new Dimension[]{latDim});
        ncfile.addVariableAttribute("latitude", "long_name", "Latitude");
        ncfile.addVariableAttribute("latitude", "units", "degrees_north (+N/-S)");
        ncfile.addVariable("longitude", Float.TYPE, new Dimension[]{lonDim});
        ncfile.addVariableAttribute("longitude", "long_name", "Longitude");
        ncfile.addVariableAttribute("longitude", "units", "degrees_east (+E/-W)");
        for (i = 0; i < TYPES.length; ++i) {
            double[] time;
            try {
                time = this.infile.getTime(TYPES[i]);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            order = MathUtil.uniqueSort((double[])time);
            String timeName = "time";
            Dimension timeDim = ncfile.addDimension(timeName, -1);
            Dimension[] dim3 = new Dimension[]{timeDim, latDim, lonDim};
            System.out.println("Adding: ".concat(String.valueOf(String.valueOf(timeName))));
            ncfile.addVariable(timeName, Double.TYPE, new Dimension[]{timeDim});
            ncfile.addVariableAttribute(timeName, "long_name", "time GMT".concat(String.valueOf(String.valueOf(POSTFIX[i]))));
            ncfile.addVariableAttribute(timeName, "units", "seconds since 01 Jan 1970 00:00:00 GMT");
            if (TYPES[i].equalsIgnoreCase("d")) {
                String varName2 = "pco2";
                System.out.println("Adding: ".concat(String.valueOf(String.valueOf(varName2))));
                ncfile.addVariable(varName2, Float.TYPE, dim3);
                ncfile.addVariableAttribute(varName2, "long_name", "calibrated pCO2");
                ncfile.addVariableAttribute(varName2, "units", "parts per million");
                ncfile.addVariableAttribute(varName2, "_FillValue", (Number)new Float(Float.NaN));
                ncfile.addVariableAttribute(varName2, "missing_value", (Number)new Float(Float.NaN));
                varName2 = "int_pco2_c";
                System.out.println("Adding: ".concat(String.valueOf(String.valueOf(varName2))));
                ncfile.addVariable(varName2, Float.TYPE, dim3);
                ncfile.addVariableAttribute(varName2, "long_name", "pCO2 of calibration samples interpolated to raw sample times");
                ncfile.addVariableAttribute(varName2, "units", "parts per million");
                ncfile.addVariableAttribute(varName2, "_FillValue", (Number)new Float(Float.NaN));
                ncfile.addVariableAttribute(varName2, "missing_value", (Number)new Float(Float.NaN));
            }
            for (j = 0; j < OasisPco2Reader.COLUMNS.length; ++j) {
                varName = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(OasisPco2Reader.COLUMNS[j]))).append("_").append(TYPES[i].toLowerCase())));
                System.out.println("Adding: ".concat(String.valueOf(String.valueOf(varName))));
                ncfile.addVariable(varName, Float.TYPE, dim3);
                ncfile.addVariableAttribute(varName, "long_name", String.valueOf(String.valueOf(OasisPco2Reader.LONG_NAME[j])).concat(String.valueOf(String.valueOf(POSTFIX[i]))));
                ncfile.addVariableAttribute(varName, "units", OasisPco2Reader.UNITS[j]);
                ncfile.addVariableAttribute(varName, "_FillValue", (Number)new Float(Float.NaN));
                ncfile.addVariableAttribute(varName, "missing_value", (Number)new Float(Float.NaN));
            }
        }
        ncfile.create();
        ncfile.write("latitude", ArrayAbstract.factory((Object)lat));
        ncfile.write("longitude", ArrayAbstract.factory((Object)lon));
        for (i = 0; i < TYPES.length; ++i) {
            double[] timeRaw;
            try {
                timeRaw = this.infile.getTime(TYPES[i]);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            order = MathUtil.uniqueSort((double[])timeRaw);
            double[] timeSorted = MathUtil.orderVector((double[])timeRaw, (int[])order);
            double[] timeSec = new double[timeSorted.length];
            for (int j2 = 0; j2 < timeSorted.length; ++j2) {
                timeSec[j2] = timeSorted[j2] / 1000.0;
            }
            String timeName = "time";
            System.out.println("Writing: ".concat(String.valueOf(String.valueOf(timeName))));
            ncfile.write(timeName, ArrayAbstract.factory((Object)timeSec));
            if (TYPES[i].equalsIgnoreCase("d")) {
                double[] timeCal = this.infile.get("time_c");
                int[] orderCal = MathUtil.uniqueSort((double[])timeCal);
                double[] timeCalSorted = MathUtil.orderVector((double[])timeCal, (int[])orderCal);
                double[] pco2DataSorted = MathUtil.orderVector((double[])this.infile.get("pco2_d"), (int[])order);
                double[] calDataSorted = MathUtil.orderVector((double[])this.infile.get("pco2_c"), (int[])orderCal);
                double[] calDataInterp = MathUtil.interpLinear((double[])timeCalSorted, (double[])calDataSorted, (double[])timeSorted);
                float[][][] pco2 = new float[timeSec.length][1][1];
                float[][][] calI = new float[timeSec.length][1][1];
                for (int k = 0; k < timeSec.length; ++k) {
                    calI[k][0][0] = (float)calDataInterp[k];
                    pco2[k][0][0] = (float)(pco2DataSorted[k] - calDataInterp[k]);
                }
                System.out.println("Writing: pco2");
                ncfile.write("pco2", ArrayAbstract.factory((Object)pco2));
                System.out.println("Writing: int_pco2_c");
                ncfile.write("int_pco2_c", ArrayAbstract.factory((Object)calI));
            }
            for (j = 0; j < OasisPco2Reader.COLUMNS.length; ++j) {
                varName = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(OasisPco2Reader.COLUMNS[j]))).append("_").append(TYPES[i])));
                System.out.println("Writing: ".concat(String.valueOf(String.valueOf(varName))));
                double[] dataSorted = MathUtil.orderVector((double[])this.infile.get(varName), (int[])order);
                float[][][] data = new float[order.length][1][1];
                for (int k = 0; k < order.length; ++k) {
                    data[k][0][0] = (float)dataSorted[k];
                }
                ncfile.write(varName.toLowerCase(), ArrayAbstract.factory((Object)data));
            }
        }
        ncfile.close();
    }
}

