/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.mbari.oasis.OMSVariable;

public class OMSVariableReader
implements Enumeration {
    private String cfgfile;
    private OMSVariable[] v;
    private int vIndex = 0;
    private int index = 0;

    public OMSVariableReader(String filename) {
        this.cfgfile = filename;
        File file = new File(filename);
        this.init(file);
    }

    public OMSVariableReader(File file) {
        this.cfgfile = file.toString();
        this.init(file);
    }

    public int countVariables() {
        return Array.getLength(this.v);
    }

    public String getFilename() {
        return this.cfgfile;
    }

    public OMSVariable getVariable(int i) {
        return this.v[i];
    }

    public OMSVariable[] getVariables() {
        return this.v;
    }

    public boolean hasMoreElements() {
        boolean ok = false;
        if (this.index < this.countVariables()) {
            ok = true;
        }
        return ok;
    }

    public Object nextElement() {
        if (this.hasMoreElements()) {
            ++this.index;
            return this.v[this.index - 1];
        }
        return null;
    }

    private void init(File file) {
        try {
            this.count(file);
            this.parse(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void count(File file) throws IOException {
        String str;
        int nVar = 0;
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((str = in.readLine()) != null) {
            if (str.length() <= 3 || !str.startsWith("#") || str.substring(1, 2).equals("!") || !str.substring(1, 2).equals(":")) continue;
            ++nVar;
        }
        in.close();
        this.v = new OMSVariable[nVar];
    }

    private void parse(File file) throws IOException {
        String str;
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((str = in.readLine()) != null) {
            if (str.length() <= 3 || !str.startsWith("#") || !str.substring(1, 2).equals(":")) continue;
            this.readVariable(str);
        }
        in.close();
    }

    private void readVariable(String str) {
        StringTokenizer st = new StringTokenizer(str);
        int n = st.countTokens() - 2;
        float[] values = new float[n];
        String buf = st.nextToken();
        String name = st.nextToken();
        int i = 0;
        while (st.hasMoreTokens()) {
            values[i] = new Float(st.nextToken()).floatValue();
            ++i;
        }
        this.v[this.vIndex] = new OMSVariable(name, values);
        ++this.vIndex;
    }

    public static void main(String[] args) {
        OMSVariableReader ovr = new OMSVariableReader("g:/eqpac/cfg/ep1.cfg");
        System.out.println();
    }
}

