/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

import java.io.Serializable;
import java.util.StringTokenizer;

public class OMSSensor
implements Serializable {
    private int bank;
    private int channel;
    private int type;
    private String name;
    private String units;
    private double[] coef = new double[3];
    private double[] minMax = new double[2];

    public OMSSensor(String s) {
        this.parse(s);
    }

    public int getBank() {
        return this.bank;
    }

    public int getChannel() {
        return this.channel;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public double[] getCoef() {
        return this.coef;
    }

    public double[] getMinMax() {
        return this.minMax;
    }

    public String getUnits() {
        return this.units;
    }

    private void parse(String s) {
        StringTokenizer st = new StringTokenizer(s);
        String[] data = new String[10];
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                data[i] = st.nextToken();
                ++i;
            }
            this.bank = new Integer(data[0]);
            this.channel = new Integer(data[1]);
            this.type = new Integer(data[2]);
            this.name = new String(data[3]);
            this.coef[0] = new Double(data[4]);
            this.coef[1] = new Double(data[5]);
            this.coef[2] = new Double(data[6]);
            this.minMax[0] = new Integer(data[7]).intValue();
            this.minMax[1] = new Integer(data[8]).intValue();
            this.units = new String(data[9]);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

