/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

import java.io.File;
import java.io.IOException;
import org.mbari.oasis.OMSNetcdfAppender;
import org.mbari.oasis.OMSSchemaConstructor;
import org.mbari.oasis.OMSUtil;
import org.mbari.oasis.OMSVariable;
import org.mbari.oasis.OMSVariableReader;
import ucar.netcdf.NetcdfFile;
import ucar.netcdf.Schema;
import ucar.netcdf.Variable;

public class OMSMain {
    private File cfg;
    private File dat;
    private File nc;
    private NetcdfFile netcdf;

    private OMSMain(File cfg, File dat, File nc) throws IOException {
        this.cfg = cfg;
        this.dat = dat;
        this.nc = nc;
        if (nc.exists()) {
            this.netcdf = new NetcdfFile(nc, false);
        } else {
            this.netcdf = new NetcdfFile(nc, true, true, this.getSchema());
            this.addAxes();
        }
        this.addData();
        this.netcdf.close();
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println();
            System.out.println("Usage: org.mbari.netcdf.OMSNetcdf configfile datafile ncfile");
            System.out.println();
            System.out.println("Inputs: configfile = name of the mooring configuration file");
            System.out.println("        datafile   = name of specprr data directory");
            System.out.println("        ncfile     = name of netcdf file to be created");
            System.out.println();
            System.exit(0);
        }
        try {
            boolean OK = true;
            File cfg = new File(args[0]);
            if (!cfg.exists()) {
                System.err.println(String.valueOf(String.valueOf(new StringBuffer("\n").append(args[0]).append(" does not exist"))));
                OK = false;
            } else if (!cfg.canRead()) {
                System.err.println("\nUnable to read ".concat(String.valueOf(String.valueOf(args[0]))));
                OK = false;
            }
            File dat = new File(args[1]);
            if (!dat.exists()) {
                System.err.println(String.valueOf(String.valueOf(new StringBuffer("\n").append(args[1]).append(" does not exist"))));
                OK = false;
            } else if (!dat.canRead()) {
                System.err.println("\nUnable to read ".concat(String.valueOf(String.valueOf(args[1]))));
                OK = false;
            }
            File nc = new File(args[2]);
            if (OK) {
                OMSMain oMSMain = new OMSMain(cfg, dat, nc);
            } else {
                System.err.println("Processing aborted");
            }
        }
        catch (IOException e) {
            System.err.println("Unable to read or create one of the input files");
            e.printStackTrace();
        }
    }

    private void addAxes() throws IOException {
        OMSVariableReader vr = new OMSVariableReader(this.cfg);
        while (vr.hasMoreElements()) {
            OMSVariable v = (OMSVariable)vr.nextElement();
            float[] values = v.getValues();
            Variable vnc = this.netcdf.get(v.getName());
            for (int i = 0; i < values.length; ++i) {
                int[] index = new int[]{i};
                vnc.setDouble(index, (double)values[i]);
            }
        }
    }

    private void addData() throws IOException {
        String[] fileList = this.dat.list();
        fileList = OMSUtil.sortFiles(fileList);
        for (int i = 0; i < fileList.length; ++i) {
            OMSNetcdfAppender oMSNetcdfAppender = new OMSNetcdfAppender(this.cfg.getCanonicalPath(), new File(this.dat.getCanonicalPath(), fileList[i]).getCanonicalPath(), this.nc.getCanonicalPath());
        }
    }

    private Schema getSchema() throws IOException {
        System.out.println("Creating Schema from ".concat(String.valueOf(String.valueOf(this.cfg))));
        OMSSchemaConstructor sc = new OMSSchemaConstructor(this.cfg);
        return sc.getSchema();
    }
}

