/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.StringTokenizer;
import java.util.Vector;
import org.mbari.oasis.OMSSensor;

public class OMSConfigReader {
    boolean DEBUG = false;
    protected OMSSensor[] validSensor;
    protected OMSSensor[] sensor;
    private String cfgfile;
    private Vector sensorVector = new Vector();
    private int[] channels;
    private double currentDate;

    public OMSConfigReader(String filename) {
        this(new File(filename), 0.0);
    }

    public OMSConfigReader(File file) {
        this(file, 0.0);
    }

    public OMSConfigReader(String filename, double d) {
        this(new File(filename), d);
    }

    public OMSConfigReader(File file, double d) {
        this.cfgfile = file.toString();
        this.currentDate = d;
        this.getSensors(file);
    }

    public static void main(String[] args) {
        File f = new File("//tsunami.shore.mbari.org/oasis/cfg/m1.cfg");
        OMSConfigReader cr = new OMSConfigReader(f);
        cr.getConfiguration();
    }

    public OMSSensor[] getConfiguration() {
        return this.validSensor;
    }

    public OMSSensor getConfiguration(int i) {
        return this.validSensor[i];
    }

    public int getNumberOfBanks() {
        return this.channels.length;
    }

    public int countBanks() {
        return Array.getLength(this.channels);
    }

    public int getChannelsInBank(int i) {
        return this.channels[i];
    }

    public int getNumberOfChannels() {
        return this.validSensor.length;
    }

    public int countChannels() {
        return this.validSensor.length;
    }

    public OMSSensor[] getCompleteConfiguration() {
        return this.sensor;
    }

    public OMSSensor getCompleteConfiguration(int i) {
        return this.sensor[i];
    }

    public String getFilename() {
        return this.cfgfile;
    }

    private void setValidConfiguration() {
        Vector<OMSSensor> buf = new Vector<OMSSensor>();
        int i = 0;
        this.msg("Setting Valid Configuration");
        for (int bank = 0; bank < this.getNumberOfBanks(); ++bank) {
            for (int channel = 1; channel <= this.getChannelsInBank(bank); ++channel) {
                if (this.getCompleteConfiguration(i).getBank() == bank && this.getCompleteConfiguration(i).getType() != 0) {
                    buf.addElement(this.getCompleteConfiguration(i));
                }
                ++i;
            }
            if (bank >= this.getNumberOfBanks()) continue;
            i = this.nextBank(bank + 1);
        }
        this.validSensor = new OMSSensor[buf.size()];
        buf.copyInto(this.validSensor);
    }

    private int nextBank(int bank) {
        int channel;
        for (channel = 0; channel < Array.getLength(this.sensor) && this.getCompleteConfiguration(channel).getBank() != bank; ++channel) {
        }
        return channel;
    }

    private int cumSum(int bank) {
        int buf = 0;
        for (int i = 0; i <= bank; ++i) {
            buf += this.getChannelsInBank(i);
        }
        return buf;
    }

    private void getSensors(File file) {
        File cfg = this.getSpecprrFile(file);
        this.msg("Reading the configuration files");
        this.readCfg(cfg);
        this.setSensor();
        this.setValidConfiguration();
    }

    private void setSensor() {
        this.sensor = new OMSSensor[this.sensorVector.size()];
        this.sensorVector.copyInto(this.sensor);
    }

    private File getSpecprrFile(File file) {
        String type;
        double d2;
        String buf;
        double d1;
        StringTokenizer st;
        String str;
        BufferedReader in;
        String cfgFile = new String();
        boolean useDefault = true;
        if (this.currentDate != 0.0) {
            useDefault = false;
        }
        boolean exists = false;
        try {
            in = new BufferedReader(new FileReader(file));
            if (!useDefault) {
                while ((str = in.readLine()) != null) {
                    if (!str.startsWith("9") && !str.startsWith("1") && !str.startsWith("2") || (st = new StringTokenizer(str)).countTokens() <= 4) continue;
                    d1 = Double.parseDouble(st.nextToken());
                    buf = st.nextToken();
                    d2 = Double.parseDouble(st.nextToken());
                    type = st.nextToken();
                    if (!type.startsWith("specprr") || !(this.currentDate >= d1 & this.currentDate <= d2)) continue;
                    exists = true;
                }
            }
            in.close();
        }
        catch (IOException e) {
            System.err.println("Unable to access ".concat(String.valueOf(String.valueOf(file.getAbsolutePath()))));
            System.exit(-1);
        }
        if (!exists) {
            useDefault = true;
        }
        try {
            in = new BufferedReader(new FileReader(file));
            if (useDefault) {
                while ((str = in.readLine()) != null) {
                    if (!str.startsWith("specprr")) continue;
                    String path = this.parsePath(str);
                    cfgFile = this.getRealPath(path);
                    break;
                }
            } else {
                while ((str = in.readLine()) != null) {
                    if (!str.startsWith("9") && !str.startsWith("1") && !str.startsWith("2") || (st = new StringTokenizer(str)).countTokens() <= 4) continue;
                    d1 = Double.parseDouble(st.nextToken());
                    buf = st.nextToken();
                    d2 = Double.parseDouble(st.nextToken());
                    type = st.nextToken();
                    if (!type.startsWith("specprr") || !(this.currentDate >= d1 & this.currentDate <= d2)) continue;
                    String path = this.parsePath(str);
                    cfgFile = this.getRealPath(path);
                    break;
                }
            }
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new File(cfgFile);
    }

    private void readCfg(File file) {
        try {
            String str;
            this.msg("Reading ".concat(String.valueOf(String.valueOf(file))));
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((str = in.readLine()) != null) {
                if (str.length() <= 1) continue;
                if (str.startsWith("/")) {
                    this.readCfg(new File(this.getRealPath(this.parsePath(str))));
                    continue;
                }
                if (str.startsWith("#")) continue;
                StringTokenizer st = new StringTokenizer(str);
                int n = st.countTokens();
                if (n == 10) {
                    this.sensorVector.addElement(new OMSSensor(str));
                    continue;
                }
                this.channels = new int[st.countTokens()];
                int i = 0;
                while (st.hasMoreTokens()) {
                    this.channels[i] = new Integer(st.nextToken());
                    ++i;
                }
            }
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String parsePath(String s) {
        StringTokenizer st = new StringTokenizer(s);
        String buf = new String();
        try {
            while (st.hasMoreTokens() && !(buf = st.nextToken()).startsWith("/")) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buf;
    }

    private String getRealPath(String path) {
        String file = new String();
        String OS = System.getProperty("os.name").toLowerCase();
        file = OS.startsWith("win") ? "//tsunami.shore.mbari.org".concat(String.valueOf(String.valueOf(path))) : (OS.startsWith("sun") ? "/hosts/tornado/vol/vol0/".concat(String.valueOf(String.valueOf(path))) : "/hosts/tsunami".concat(String.valueOf(String.valueOf(path))));
        return file;
    }

    private void ID() {
        System.out.print("OMSConfigReader: ");
    }

    private void msg(String s) {
        if (this.DEBUG) {
            System.out.println("OMSConfigReader: ".concat(String.valueOf(String.valueOf(s))));
        }
    }
}

