/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.StringTokenizer;
import ucar.netcdf.Attribute;

public class OMSAttributeReader
implements Enumeration {
    private String cfgfile;
    protected Attribute[] attributes;
    private int index = 0;

    public OMSAttributeReader(String filename) {
        this.cfgfile = filename;
        File file = new File(filename);
        this.init(file);
    }

    public OMSAttributeReader(File file) {
        this.cfgfile = file.toString();
        this.init(file);
    }

    public String getFilename() {
        return this.cfgfile;
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public Attribute getAttribute(int i) {
        return this.attributes[i];
    }

    public int countAttributes() {
        return Array.getLength(this.attributes);
    }

    public boolean hasMoreElements() {
        boolean ok = false;
        if (this.index < this.countAttributes()) {
            ok = true;
        }
        return ok;
    }

    public Object nextElement() {
        if (this.hasMoreElements()) {
            ++this.index;
            return this.attributes[this.index - 1];
        }
        return null;
    }

    private void count(File file) throws IOException {
        String str;
        int nAtt = 0;
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((str = in.readLine()) != null) {
            if (str.length() <= 3 || !str.startsWith("#")) continue;
            if (str.substring(1, 2).equals("!")) {
                ++nAtt;
                continue;
            }
            if (!str.substring(1, 2).equals(":")) continue;
        }
        in.close();
        this.attributes = new Attribute[nAtt];
    }

    private void init(File file) {
        try {
            this.count(file);
            this.parse(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.index = 0;
    }

    private void parse(File file) throws IOException {
        String str;
        BufferedReader in = new BufferedReader(new FileReader(file));
        while ((str = in.readLine()) != null) {
            if (str.length() <= 3 || !str.startsWith("#")) continue;
            if (str.substring(1, 2).equals("!")) {
                this.readAttribute(str);
                continue;
            }
            if (!str.substring(1, 2).equals(":")) continue;
        }
        in.close();
    }

    private void readAttribute(String str) {
        StringTokenizer st = new StringTokenizer(str);
        String name = new String();
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            name = st.nextToken();
            n += name.length();
        }
        String value = str.substring(n + 2);
        this.attributes[this.index] = new Attribute(name, value);
        ++this.index;
    }
}

