/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

import java.io.IOException;
import java.util.Date;
import ucar.ma2.ArrayAbstract;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;

public class NetcdfTest {
    public NetcdfTest(String outfile) throws IOException {
        NetcdfFileWriteable ncfile = new NetcdfFileWriteable();
        ncfile.setName(outfile);
        ncfile.addGlobalAttribute("conventions", "MBARI/timeSeries/mooring/pco2");
        ncfile.addGlobalAttribute("creationDate", new Date().toString());
        ncfile.addGlobalAttribute("lastModified", new Date().toString());
        ncfile.addGlobalAttribute("mooring", "M1");
        ncfile.addGlobalAttribute("description", "pCO2 data");
        ncfile.addGlobalAttribute("waterdepth", "1050");
        ncfile.addGlobalAttribute("keywords", "pCO2, mooring");
        ncfile.addGlobalAttribute("instrumentType", "pCO2 Can");
        Dimension timeDim = ncfile.addDimension("time", -1);
        Dimension latDim = ncfile.addDimension("latitude", 1);
        Dimension lonDim = ncfile.addDimension("longitude", 1);
        Dimension calTimeDim = ncfile.addDimension("calTime", 500);
        Dimension[] mainDim = new Dimension[]{timeDim, latDim, lonDim};
        Dimension[] calDim = new Dimension[]{calTimeDim, latDim, lonDim};
        ncfile.addVariable("time", Double.TYPE, new Dimension[]{timeDim});
        ncfile.addVariableAttribute("time", "long_name", "time GMT");
        ncfile.addVariableAttribute("time", "units", "seconds since 01 Jan 1970 00:00:00 GMT");
        ncfile.addVariable("latitude", Float.TYPE, new Dimension[]{latDim});
        ncfile.addVariableAttribute("latitude", "long_name", "Latitude");
        ncfile.addVariableAttribute("latitude", "units", "degrees_north (+N/-S)");
        ncfile.addVariable("longitude", Float.TYPE, new Dimension[]{lonDim});
        ncfile.addVariableAttribute("longitude", "long_name", "Longitude");
        ncfile.addVariableAttribute("longitude", "units", "degrees_east (+E/-W)");
        ncfile.addVariable("calTime", Double.TYPE, new Dimension[]{calTimeDim});
        ncfile.addVariableAttribute("calTime", "long_name", "time GMT of calibration samples");
        ncfile.addVariableAttribute("calTime", "units", "seconds since 01 Jan 1970 00:00:00 GMT");
        ncfile.addVariable("pco2u", Float.TYPE, mainDim);
        ncfile.addVariableAttribute("pco2u", "long_name", "uncalibrated pCO2");
        ncfile.addVariableAttribute("pco2u", "units", "microatm");
        ncfile.addVariableAttribute("pco2u", "symbol", "pCO2u");
        ncfile.addVariableAttribute("pco2u", "_FillValue", (Number)new Float(-999.0f));
        ncfile.addVariableAttribute("pco2u", "missing_value", (Number)new Float(-999.0f));
        ncfile.addVariable("pco2", Float.TYPE, mainDim);
        ncfile.addVariableAttribute("pco2", "long_name", "calibrated pCO2");
        ncfile.addVariableAttribute("pco2", "units", "microatm");
        ncfile.addVariableAttribute("pco2", "symbol", "pCO2");
        ncfile.addVariableAttribute("pco2", "_FillValue", (Number)new Float(-999.0f));
        ncfile.addVariableAttribute("pco2", "missing_value", (Number)new Float(-999.0f));
        ncfile.addVariable("cal", Float.TYPE, calDim);
        ncfile.addVariableAttribute("cal", "long_name", "atmospheric calibration");
        ncfile.addVariableAttribute("cal", "units", "microatm");
        ncfile.addVariableAttribute("cal", "symbol", "pCO2c");
        ncfile.addVariableAttribute("cal", "_FillValue", (Number)new Float(-999.0f));
        ncfile.addVariableAttribute("cal", "missing_value", (Number)new Float(-999.0f));
        ncfile.addVariable("calI", Float.TYPE, mainDim);
        ncfile.addVariableAttribute("calI", "long_name", "atmospheric calibration interpolated to pco2 time axis");
        ncfile.addVariableAttribute("calI", "units", "microatm");
        ncfile.addVariableAttribute("calI", "symbol", "pCO2ci");
        ncfile.addVariableAttribute("calI", "_FillValue", (Number)new Float(-999.0f));
        ncfile.addVariableAttribute("calI", "missing_value", (Number)new Float(-999.0f));
        ncfile.create();
        double[] data1 = new double[2902];
        float[][][] data3 = new float[2902][1][1];
        for (int i = 0; i < data1.length; ++i) {
            data1[i] = i;
            data3[i][0][0] = i;
        }
        double[] calData1 = new double[500];
        float[][][] calData3 = new float[500][1][1];
        for (int i = 0; i < calData1.length; ++i) {
            data1[i] = i;
            data3[i][0][0] = i;
        }
        ncfile.write("time", ArrayAbstract.factory((Object)data1));
        ncfile.write("latitude", ArrayAbstract.factory((Object)new float[]{36.0f}));
        ncfile.write("longitude", ArrayAbstract.factory((Object)new float[]{-122.0f}));
        ncfile.write("calTime", ArrayAbstract.factory((Object)calData1));
        ncfile.write("pco2u", ArrayAbstract.factory((Object)data3));
        ncfile.write("pco2", ArrayAbstract.factory((Object)data3));
        ncfile.write("cal", ArrayAbstract.factory((Object)calData3));
        ncfile.write("calI", ArrayAbstract.factory((Object)data3));
        ncfile.close();
    }

    public static void main(String[] args) {
        try {
            NetcdfTest netcdfTest = new NetcdfTest(args[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

