/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import org.mbari.hobilabs.HRBinaryDecoder;
import org.mbari.hobilabs.HRPacket;
import org.mbari.io.HRCalFileNameFilter;
import org.mbari.io.HRCalibrationFileReader;
import org.mbari.util.GmtCalendar;
import org.mbari.util.HRUtil;
import org.mbari.util.MathUtil;
import ucar.multiarray.ArrayMultiArray;
import ucar.multiarray.MultiArray;
import ucar.netcdf.Attribute;
import ucar.netcdf.Dimension;
import ucar.netcdf.NetcdfFile;
import ucar.netcdf.ProtoVariable;
import ucar.netcdf.Schema;
import ucar.netcdf.Variable;

public class HRNetcdfCoards {
    File calDirectory;
    File[] infile;
    String outfile;
    String mooring;

    public HRNetcdfCoards(String mooring, File calDirectory, String outfile, File[] infile) {
        this.calDirectory = calDirectory;
        Arrays.sort(infile);
        this.infile = infile;
        this.outfile = outfile;
        this.mooring = mooring.toLowerCase();
    }

    public void process() throws IllegalArgumentException, IOException {
        ProtoVariable lonV;
        ProtoVariable latV;
        if (!this.calDirectory.isDirectory()) {
            throw new IllegalArgumentException(String.valueOf(String.valueOf(this.calDirectory.getCanonicalPath())).concat(" is not a directory."));
        }
        Properties mooringProperties = new Properties();
        BufferedInputStream mooringPropertiesStream = new BufferedInputStream(new FileInputStream(new File(this.calDirectory, "mooring.properties")));
        mooringProperties.load(mooringPropertiesStream);
        mooringPropertiesStream.close();
        float[] lat = new float[]{Float.parseFloat(mooringProperties.getProperty(String.valueOf(String.valueOf(this.mooring)).concat(".latitude"), "-999"))};
        float[] lon = new float[]{Float.parseFloat(mooringProperties.getProperty(String.valueOf(String.valueOf(this.mooring)).concat(".longitude"), "-999"))};
        HRBinaryDecoder[] d = new HRBinaryDecoder[this.infile.length];
        for (int i = 0; i < d.length; ++i) {
            d[i] = new HRBinaryDecoder(this.infile[i], false);
            d[i].decode();
            HRPacket[] buf = d[i].getData();
            int n = buf.length;
            for (int j = 0; j < buf.length; ++j) {
                if (buf[j].RawTime >= 883612800 && (long)buf[j].RawTime <= 32503680000L) continue;
                --n;
                buf[j].RawTime = 0;
            }
            HRPacket[] newBuf = new HRPacket[n];
            int newN = 0;
            for (int j = 0; j < n; ++j) {
                if (buf[j].RawTime == 0) continue;
                newBuf[j] = buf[j];
                ++newN;
            }
            d[i].setData(newBuf);
        }
        String[] serialNumber0 = d[0].getSerialNumbers();
        String instrumentType0 = d[0].getInstrumentType();
        HRPacket[] data0 = d[0].getData();
        Object[] calList = this.calDirectory.list((FilenameFilter)new HRCalFileNameFilter(instrumentType0.toLowerCase(), serialNumber0[0]));
        Arrays.sort(calList);
        HRCalibrationFileReader[] calFiles = new HRCalibrationFileReader[calList.length];
        double[] calTime = new double[calList.length];
        for (int i = 0; i < calList.length; ++i) {
            calFiles[i] = new HRCalibrationFileReader(new File(this.calDirectory, (String)calList[i]));
            StringTokenizer st3 = new StringTokenizer((String)calList[i], ".");
            String tmp = st3.nextToken();
            tmp = st3.nextToken();
            tmp = st3.nextToken();
            int year = Integer.parseInt(tmp.substring(0, 4));
            int month = Integer.parseInt(tmp.substring(4, 6));
            int date = Integer.parseInt(tmp.substring(6, 8));
            calTime[i] = new GmtCalendar(year, month, date).getTime().getTime() / (long)1000;
        }
        int good = 0;
        if ((double)data0[0].RawTime < calTime[0]) {
            good = 0;
        } else if ((double)data0[0].RawTime > calTime[calTime.length - 1]) {
            good = calTime.length - 1;
        } else {
            for (int i = 0; i < calTime.length - 1; ++i) {
                if (!((double)data0[0].RawTime >= calTime[i]) || !((double)data0[0].RawTime < calTime[i + 1])) continue;
                good = i;
                break;
            }
        }
        ProtoVariable[] schemaV = new ProtoVariable[2 + 6 * d.length];
        int n = 0;
        Dimension[] lambdaD = new Dimension[this.infile.length];
        Attribute[] lambdaA = new Attribute[]{new Attribute("long_name", "wavelength"), new Attribute("units", "nanometers")};
        ProtoVariable[] lambdaV = new ProtoVariable[d.length];
        Dimension[] timeD = new Dimension[this.infile.length];
        ProtoVariable[] timeV = new ProtoVariable[d.length];
        Dimension[] depthD = new Dimension[this.infile.length];
        Attribute[] depthA = new Attribute[]{new Attribute("long_name", "Sensor depth"), new Attribute("units", "meters"), new Attribute("positive", "down")};
        ProtoVariable[] depthV = new ProtoVariable[d.length];
        for (int i = 0; i < d.length; ++i) {
            HRPacket[] data = d[i].getData();
            double[] timeBuf = new double[data.length];
            for (int r = 0; r < data.length; ++r) {
                timeBuf[r] = data[r].RawTime;
            }
            int[] timeOrder = MathUtil.uniqueSort((double[])timeBuf);
            lambdaD[i] = new Dimension("wavelength".concat(String.valueOf(String.valueOf(d[i].getChannelNumber()))), data[0].PixCount);
            lambdaV[i] = new ProtoVariable("wavelength".concat(String.valueOf(String.valueOf(d[i].getChannelNumber()))), Float.TYPE, new Dimension[]{lambdaD[i]}, lambdaA);
            schemaV[n] = lambdaV[i];
            timeD[i] = new Dimension("time".concat(String.valueOf(String.valueOf(d[i].getChannelNumber()))), timeOrder.length);
            Attribute[] timeA = new Attribute[]{new Attribute("long_name", String.valueOf(String.valueOf(new StringBuffer("Sample time (GMT) for ").append(d[i].getDataType()).append(" sensor")))), new Attribute("units", "seconds since 1970-01-01 00:00:00 GMT"), new Attribute("_FillValue", -999.0)};
            timeV[i] = new ProtoVariable("time".concat(String.valueOf(String.valueOf(d[i].getChannelNumber()))), Double.TYPE, new Dimension[]{timeD[i]}, timeA);
            schemaV[++n] = timeV[i];
            depthD[i] = new Dimension("depth".concat(String.valueOf(String.valueOf(d[i].getChannelNumber()))), 1);
            depthV[i] = new ProtoVariable("depth".concat(String.valueOf(String.valueOf(d[i].getChannelNumber()))), Float.TYPE, new Dimension[]{depthD[i]}, depthA);
            schemaV[++n] = depthV[i];
            ++n;
        }
        Dimension latD = new Dimension("latitude", 1);
        Attribute[] latA = new Attribute[]{new Attribute("long_name", "Latitude"), new Attribute("units", "degrees_east")};
        schemaV[n] = latV = new ProtoVariable("latitude", Float.TYPE, new Dimension[]{latD}, latA);
        Dimension lonD = new Dimension("longitude", 1);
        Attribute[] lonA = new Attribute[]{new Attribute("long_name", "Longitude"), new Attribute("units", "degrees_north")};
        schemaV[++n] = lonV = new ProtoVariable("longitude", Float.TYPE, new Dimension[]{lonD}, lonA);
        ++n;
        Attribute[] globalAtt = new Attribute[]{new Attribute("conventions", "MBARI/timeSeries/mooring/hydrorad"), new Attribute("creationDate", new Date().toString()), new Attribute("lastModified", new Date().toString()), new Attribute("mooring", "M1"), new Attribute("project", "Monterey Bay Time Series"), new Attribute("keywords", "spectroradiometer"), new Attribute("instrumentType", "Hobilabs ".concat(String.valueOf(String.valueOf(instrumentType0)))), new Attribute("serialNumber", serialNumber0[0]), new Attribute("configurationFile", (String)calList[good])};
        ProtoVariable[] pressureV = new ProtoVariable[d.length];
        for (int i = 0; i < d.length; ++i) {
            pressureV[i] = new ProtoVariable("pressure".concat(String.valueOf(String.valueOf(d[i].getChannelNumber()))), Float.TYPE, new Dimension[]{timeD[i], depthD[i], latD, lonD}, new Attribute[]{new Attribute("long_name", "Pressure for channel ".concat(String.valueOf(String.valueOf(d[i].getChannelNumber())))), new Attribute("units", "dbar"), new Attribute("symbol", "Z"), new Attribute("_FillValue", -999.0), new Attribute("missing_value", -999.0)});
            schemaV[n] = pressureV[i];
            ++n;
        }
        ProtoVariable[] intTimeV = new ProtoVariable[d.length];
        for (int i = 0; i < d.length; ++i) {
            intTimeV[i] = new ProtoVariable("intTime".concat(String.valueOf(String.valueOf(d[i].getChannelNumber()))), Float.TYPE, new Dimension[]{timeD[i], depthD[i], latD, lonD}, new Attribute[]{new Attribute("long_name", "Integration time for channel ".concat(String.valueOf(String.valueOf(d[i].getChannelNumber())))), new Attribute("units", "seconds"), new Attribute("symbol", "I"), new Attribute("_FillValue", -999.0), new Attribute("missing_value", -999.0)});
            schemaV[n] = intTimeV[i];
            ++n;
        }
        ProtoVariable[] dataV = new ProtoVariable[d.length];
        for (int i = 0; i < d.length; ++i) {
            dataV[i] = new ProtoVariable(d[i].getDataType(), Float.TYPE, new Dimension[]{lambdaD[i], timeD[i], depthD[i], latD, lonD}, new Attribute[]{new Attribute("long_name", d[i].getDataDescription()), new Attribute("units", d[i].getUnits()), new Attribute("symbol", d[i].getDataType()), new Attribute("_FillValue", -999.0), new Attribute("missing_value", -999.0)});
            schemaV[n] = dataV[i];
            ++n;
        }
        Schema schema = new Schema(schemaV, globalAtt);
        NetcdfFile nc = new NetcdfFile(this.outfile, true, true, schema);
        int[] origin1 = new int[]{0};
        int[] origin4 = new int[]{0, 0, 0, 0};
        int[] origin5 = new int[]{0, 0, 0, 0, 0};
        ArrayMultiArray m = new ArrayMultiArray((Object)lat);
        Variable v = nc.get(latV.getName());
        v.copyin(origin1, (MultiArray)m);
        m = new ArrayMultiArray((Object)lon);
        v = nc.get(lonV.getName());
        v.copyin(origin1, (MultiArray)m);
        for (int i = 0; i < d.length; ++i) {
            int row;
            HRPacket[] data = d[i].getData();
            String[] serialNumber = d[i].getSerialNumbers();
            String dataDescription = d[i].getDataDescription();
            String dataType = d[i].getDataType();
            String dataUnits = d[i].getUnits();
            String channel = String.valueOf(String.valueOf(d[i].getChannelNumber())).concat("");
            String instrumentType = d[i].getInstrumentType();
            double[] lambda = HRUtil.calcWavelength((HRPacket)data[0], (double[])calFiles[good].getWave(channel));
            float[] lambdaF = new float[lambda.length];
            for (int j = 0; j < lambda.length; ++j) {
                lambdaF[j] = (float)lambda[j];
            }
            double[] timeBuf = new double[data.length];
            for (int r = 0; r < data.length; ++r) {
                timeBuf[r] = data[r].RawTime;
            }
            int[] timeOrder = MathUtil.uniqueSort((double[])timeBuf);
            double[] time = new double[timeOrder.length];
            float[] temp = new float[timeOrder.length];
            float[] voltage = new float[timeOrder.length];
            float[] pressure = new float[timeOrder.length];
            float[] intT = new float[timeOrder.length];
            float[][] dat = new float[timeOrder.length][lambda.length];
            float[] depth = new float[]{0.0f};
            String paramString = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.mooring))).append(".").append(instrumentType).append(".").append("depth_offset").append(".ch").append(channel)));
            float depthOffset = Float.parseFloat(mooringProperties.getProperty(paramString.toLowerCase(), "0"));
            for (int r = 0; r < timeOrder.length; ++r) {
                int index = timeOrder[r];
                time[r] = data[index].RawTime;
                temp[r] = (float)data[index].Temp;
                voltage[r] = (float)data[index].Voltage;
                pressure[r] = (float)data[index].Depth;
                intT[r] = data[index].IntTime;
                dat[r] = new float[data[index].Pixel.length];
                for (int c = 0; c < dat[r].length; ++c) {
                    dat[r][c] = (float)data[index].Pixel[c];
                }
                depth[0] = depth[0] + pressure[r];
            }
            depth[0] = depth[0] / (float)data.length + depthOffset;
            m = new ArrayMultiArray((Object)lambdaF);
            v = nc.get(lambdaV[i].getName());
            v.copyin(origin1, (MultiArray)m);
            m = new ArrayMultiArray((Object)time);
            v = nc.get(timeV[i].getName());
            v.copyin(origin1, (MultiArray)m);
            m = new ArrayMultiArray((Object)depth);
            v = nc.get(depthV[i].getName());
            v.copyin(origin1, (MultiArray)m);
            m = new ArrayMultiArray((Object)dat);
            v = nc.get(dataV[i].getName());
            for (int col = 0; col < lambdaF.length; ++col) {
                try {
                    for (int row2 = 0; row2 < time.length; ++row2) {
                        v.setFloat(new int[]{col, row2, 0, 0, 0}, dat[row2][col]);
                    }
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            m = new ArrayMultiArray((Object)dat);
            v = nc.get(pressureV[i].getName());
            for (row = 0; row < time.length; ++row) {
                v.setFloat(new int[]{row, 0, 0, 0}, pressure[row]);
            }
            m = new ArrayMultiArray((Object)intT);
            v = nc.get(intTimeV[i].getName());
            for (row = 0; row < time.length; ++row) {
                v.setFloat(new int[]{row, 0, 0, 0}, intT[row]);
            }
        }
        nc.close();
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.err.println("Usage: java org.mbari.hobilabs.hr.HRNetcdfCoards <mooring> <Directory containing cal files> <outfile> <infile1> <infile2> ...");
            System.exit(0);
        }
        File[] infile = new File[args.length - 3];
        for (int i = 3; i < args.length; ++i) {
            infile[i - 3] = new File(args[i]);
        }
        HRNetcdfCoards main = new HRNetcdfCoards(args[0], new File(args[1]), args[2], infile);
        try {
            main.process();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

