/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.mbari.util.MathUtil;

public class DuplicateRemover {
    File file;

    public DuplicateRemover(String f) throws IOException {
        this(new File(f));
    }

    public DuplicateRemover(File f) throws IOException {
        this.file = f;
        this.process();
    }

    public static void main(String[] args) {
        File f;
        if (args.length > 1 || args.length < 1) {
            System.out.println("Usage: DuplicateRemover filename/directory");
            System.exit(0);
        }
        if ((f = new File(args[0])).isDirectory()) {
            String[] list = f.list();
            for (int i = 0; i < list.length; ++i) {
                try {
                    DuplicateRemover duplicateRemover = new DuplicateRemover(new File(f, list[i]));
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                DuplicateRemover list = new DuplicateRemover(f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.exit(1);
    }

    private void process() throws IOException {
        String s;
        BufferedReader in = new BufferedReader(new FileReader(this.file));
        ArrayList<Double> date = new ArrayList<Double>();
        ArrayList<String> data = new ArrayList<String>();
        ArrayList<String> header = new ArrayList<String>();
        while ((s = in.readLine()) != null) {
            if (s.startsWith("#")) {
                header.add(s);
                continue;
            }
            data.add(s);
            StringTokenizer st = new StringTokenizer(s);
            date.add(new Double(Double.parseDouble(st.nextToken())));
        }
        in.close();
        double[] dates = new double[date.size()];
        for (int i = 0; i < dates.length; ++i) {
            Double tmp = (Double)date.get(i);
            dates[i] = tmp;
        }
        int[] order = MathUtil.uniqueSort((double[])dates);
        boolean rewrite = false;
        if (order.length != dates.length) {
            rewrite = true;
        } else {
            for (int i = 1; i < dates.length; ++i) {
                if (!(dates[i] - dates[i - 1] < 0.0)) continue;
                rewrite = true;
                break;
            }
        }
        if (rewrite) {
            int i;
            BufferedWriter out = new BufferedWriter(new FileWriter(this.file));
            System.out.println("Rewriting ".concat(String.valueOf(String.valueOf(this.file.getCanonicalPath()))));
            for (i = 0; i < header.size(); ++i) {
                out.write(String.valueOf(String.valueOf((String)header.get(i))).concat("\n"));
            }
            for (i = 0; i < order.length; ++i) {
                out.write(String.valueOf(String.valueOf((String)data.get(order[i]))).concat("\n"));
            }
        }
    }
}

