/*
 * Decompiled with CFR 0.152.
 */
package ucar.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.server.RemoteServer;
import ucar.util.AbstractLogger;
import ucar.util.Logger;

public class RMILogger
extends AbstractLogger
implements Logger {
    private int maxLevel_;
    private PrintStream logStream_;

    public RMILogger(int n, OutputStream outputStream) {
        this.maxLevel_ = n;
        this.setLog(outputStream);
    }

    public RMILogger() {
        this(5, System.err);
    }

    private void makeConsistent() {
        if (this.maxLevel_ > 5 && RemoteServer.getLog() != this.logStream_) {
            RemoteServer.setLog(this.logStream_);
        }
    }

    public synchronized void setLog(OutputStream outputStream) {
        this.logStream_ = outputStream instanceof PrintStream ? (PrintStream)outputStream : new PrintStream(outputStream);
        this.makeConsistent();
    }

    public synchronized void logUpTo(int n) {
        this.maxLevel_ = n;
        this.makeConsistent();
    }

    public synchronized void log(int n, String string) throws IOException {
        if (n > this.maxLevel_) {
            return;
        }
        PrintStream printStream = RemoteServer.getLog();
        if (printStream == null) {
            printStream = this.logStream_;
        }
        printStream.println(string);
    }
}

