/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.io.IOException;
import ucar.multiarray.Accessor;
import ucar.multiarray.MultiArray;
import ucar.netcdf.Attribute;
import ucar.netcdf.AttributeSet;
import ucar.netcdf.DimensionDictionary;
import ucar.netcdf.DimensionIterator;
import ucar.netcdf.Named;
import ucar.netcdf.ProtoVariable;

public class Variable
implements MultiArray,
Named {
    final ProtoVariable meta;
    final Accessor io;

    public Variable(ProtoVariable protoVariable, Accessor accessor) {
        if (protoVariable == null || accessor == null) {
            throw new NullPointerException();
        }
        this.meta = protoVariable;
        this.io = accessor;
    }

    public Class getComponentType() {
        return this.meta.getComponentType();
    }

    public int getRank() {
        return this.meta.getRank();
    }

    public int[] getLengths() {
        return this.meta.getLengths();
    }

    public boolean isUnlimited() {
        return this.meta.isUnlimited();
    }

    public boolean isScalar() {
        return this.meta.isScalar();
    }

    public String getName() {
        return this.meta.getName();
    }

    public DimensionIterator getDimensionIterator() {
        return this.meta.getDimensionIterator();
    }

    public AttributeSet getAttributes() {
        return this.meta.getAttributes();
    }

    public Attribute getAttribute(String string) {
        return this.meta.getAttribute(string);
    }

    public Object get(int[] nArray) throws IOException {
        return this.io.get(nArray);
    }

    public boolean getBoolean(int[] nArray) throws IOException {
        return this.io.getBoolean(nArray);
    }

    public char getChar(int[] nArray) throws IOException {
        return this.io.getChar(nArray);
    }

    public byte getByte(int[] nArray) throws IOException {
        return this.io.getByte(nArray);
    }

    public short getShort(int[] nArray) throws IOException {
        return this.io.getShort(nArray);
    }

    public int getInt(int[] nArray) throws IOException {
        return this.io.getInt(nArray);
    }

    public long getLong(int[] nArray) throws IOException {
        return this.io.getLong(nArray);
    }

    public float getFloat(int[] nArray) throws IOException {
        return this.io.getFloat(nArray);
    }

    public double getDouble(int[] nArray) throws IOException {
        return this.io.getDouble(nArray);
    }

    public void set(int[] nArray, Object object) throws IOException {
        this.io.set(nArray, object);
    }

    public void setBoolean(int[] nArray, boolean bl) throws IOException {
        this.io.setBoolean(nArray, bl);
    }

    public void setChar(int[] nArray, char c) throws IOException {
        this.io.setChar(nArray, c);
    }

    public void setByte(int[] nArray, byte by) throws IOException {
        this.io.setByte(nArray, by);
    }

    public void setShort(int[] nArray, short s) throws IOException {
        this.io.setShort(nArray, s);
    }

    public void setInt(int[] nArray, int n) throws IOException {
        this.io.setInt(nArray, n);
    }

    public void setLong(int[] nArray, long l) throws IOException {
        this.io.setLong(nArray, l);
    }

    public void setFloat(int[] nArray, float f) throws IOException {
        this.io.setFloat(nArray, f);
    }

    public void setDouble(int[] nArray, double d) throws IOException {
        this.io.setDouble(nArray, d);
    }

    public MultiArray copyout(int[] nArray, int[] nArray2) throws IOException {
        if (nArray2.length != this.getRank()) {
            throw new IllegalArgumentException("rank mismatch");
        }
        return this.io.copyout(nArray, nArray2);
    }

    public void copyin(int[] nArray, MultiArray multiArray) throws IOException {
        if (multiArray.getRank() != this.getRank()) {
            throw new IllegalArgumentException(multiArray.getRank() + " != " + this.getRank());
        }
        if (multiArray.getComponentType() != this.getComponentType()) {
            throw new IllegalArgumentException(multiArray.getComponentType().getName() + " != " + this.getComponentType().getName());
        }
        this.io.copyin(nArray, multiArray);
    }

    public Object toArray() throws IOException {
        return this.io.toArray();
    }

    public Object toArray(Object object, int[] nArray, int[] nArray2) throws IOException {
        return this.io.toArray(object, nArray, nArray2);
    }

    public void toCdl(StringBuffer stringBuffer) {
        this.meta.toCdl(stringBuffer);
    }

    public String toString() {
        return this.meta.toString();
    }

    void connectDims(DimensionDictionary dimensionDictionary) {
        this.meta.connectDims(dimensionDictionary);
    }
}

