/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.io.Serializable;
import java.util.Enumeration;
import ucar.netcdf.Attribute;
import ucar.netcdf.AttributeDictionary;
import ucar.netcdf.AttributeSet;
import ucar.netcdf.Dimension;
import ucar.netcdf.DimensionDictionary;
import ucar.netcdf.DimensionIterator;
import ucar.netcdf.DimensionSet;
import ucar.netcdf.Named;
import ucar.netcdf.NamedDictionary;
import ucar.netcdf.Netcdf;
import ucar.netcdf.ProtoVariable;
import ucar.netcdf.ProtoVariableIterator;
import ucar.netcdf.VariableIterator;

public class Schema
implements Serializable {
    private final DimensionDictionary dimensions;
    private final AttributeDictionary attributes;
    private final NamedDictionary variables;

    public Schema() {
        this.variables = new NamedDictionary(0);
        this.dimensions = new DimensionDictionary();
        this.attributes = new AttributeDictionary();
    }

    public Schema(Schema schema) {
        Schema schema2 = schema;
        synchronized (schema2) {
            this.dimensions = new DimensionDictionary(schema.getDimensions());
            this.variables = new NamedDictionary(schema.size());
            ProtoVariableIterator protoVariableIterator = schema.iterator();
            while (protoVariableIterator.hasNext()) {
                if (this.put(new ProtoVariable(protoVariableIterator.next())) == null) continue;
                throw new IllegalArgumentException("Duplicate variable name");
            }
            this.attributes = new AttributeDictionary(schema.getAttributes());
        }
    }

    public Schema(Netcdf netcdf) {
        this.dimensions = new DimensionDictionary(netcdf.getDimensions());
        this.variables = new NamedDictionary(netcdf.size());
        VariableIterator variableIterator = netcdf.iterator();
        while (variableIterator.hasNext()) {
            if (this.put(new ProtoVariable(variableIterator.next())) == null) continue;
            throw new IllegalArgumentException("Duplicate variable name");
        }
        this.attributes = new AttributeDictionary(netcdf.getAttributes());
    }

    public Schema(ProtoVariable[] protoVariableArray, Attribute[] attributeArray) {
        if (protoVariableArray == null) {
            this.variables = new NamedDictionary(0);
            this.dimensions = new DimensionDictionary();
        } else {
            ProtoVariable[] protoVariableArray2 = protoVariableArray;
            synchronized (protoVariableArray2) {
                this.dimensions = new DimensionDictionary(protoVariableArray);
                this.variables = new NamedDictionary(protoVariableArray);
            }
        }
        this.attributes = new AttributeDictionary(attributeArray);
    }

    public int size() {
        return this.variables.size();
    }

    public ProtoVariableIterator iterator() {
        return new ProtoVariableIterator(){
            final Enumeration ee;
            {
                this.ee = Schema.this.variables.elements();
            }

            public boolean hasNext() {
                return this.ee.hasMoreElements();
            }

            public ProtoVariable next() {
                return (ProtoVariable)this.ee.nextElement();
            }
        };
    }

    public ProtoVariable[] toArray() {
        ProtoVariable[] protoVariableArray = new ProtoVariable[this.size()];
        ProtoVariableIterator protoVariableIterator = this.iterator();
        int n = 0;
        while (protoVariableIterator.hasNext()) {
            protoVariableArray[n] = protoVariableIterator.next();
            ++n;
        }
        return protoVariableArray;
    }

    public ProtoVariable get(String string) {
        return (ProtoVariable)this.variables.get(string);
    }

    public boolean contains(String string) {
        return this.variables.contains(string);
    }

    public boolean contains(Object object) {
        return this.variables.contains(object);
    }

    public synchronized ProtoVariable put(ProtoVariable protoVariable) {
        ProtoVariable protoVariable2 = this.get(protoVariable.getName());
        if (protoVariable2 != null) {
            if (protoVariable2 == protoVariable) {
                return null;
            }
            this.remove(protoVariable2);
        }
        this.variables.put(protoVariable);
        protoVariable.connectDims(this.dimensions);
        return protoVariable2;
    }

    public synchronized boolean remove(String string) {
        ProtoVariable protoVariable = (ProtoVariable)this.variables.remove(string);
        if (protoVariable == null) {
            return false;
        }
        DimensionIterator dimensionIterator = protoVariable.getDimensionIterator();
        while (dimensionIterator.hasNext()) {
            boolean bl = false;
            Dimension dimension = dimensionIterator.next();
            String string2 = dimension.getName();
            ProtoVariableIterator protoVariableIterator = this.iterator();
            while (protoVariableIterator.hasNext()) {
                DimensionIterator dimensionIterator2 = protoVariableIterator.next().getDimensionIterator();
                while (dimensionIterator2.hasNext()) {
                    Dimension dimension2 = dimensionIterator2.next();
                    if (!dimension2.getName().equals(string2)) continue;
                    bl = true;
                    break;
                }
                if (bl) break;
            }
            if (bl) continue;
            this.dimensions.remove(string2);
        }
        return true;
    }

    public boolean remove(Object object) {
        if (this.contains(object)) {
            return this.remove(((Named)object).getName());
        }
        return false;
    }

    public DimensionSet getDimensions() {
        return this.dimensions;
    }

    public AttributeSet getAttributes() {
        return this.attributes;
    }

    public Attribute getAttribute(String string) {
        return this.attributes.get(string);
    }

    public Attribute putAttribute(Attribute attribute) {
        return this.attributes.put(attribute);
    }

    public void toCdl(StringBuffer stringBuffer) {
        stringBuffer.append("{\n");
        this.dimensions.toCdl(stringBuffer);
        stringBuffer.append("variables:\n");
        ProtoVariableIterator protoVariableIterator = this.iterator();
        while (protoVariableIterator.hasNext()) {
            stringBuffer.append("\t");
            protoVariableIterator.next().toCdl(stringBuffer);
        }
        if (this.attributes.size() > 0) {
            stringBuffer.append("\n// global attributes:\n");
            this.attributes.toCdl(stringBuffer);
        }
        stringBuffer.append("\n}");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toCdl(stringBuffer);
        return stringBuffer.toString();
    }

    int indexOf(Dimension dimension) {
        return this.dimensions.indexOf(dimension);
    }

    void putDimension(Dimension dimension) {
        this.dimensions.initialPut(dimension);
    }
}

