/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import ucar.multiarray.Accessor;
import ucar.multiarray.MultiArray;
import ucar.netcdf.AbstractNetcdf;
import ucar.netcdf.NetcdfRemoteProxy;
import ucar.netcdf.NetcdfService;
import ucar.netcdf.ProtoVariable;
import ucar.netcdf.Variable;
import ucar.netcdf.VariableIterator;

public class RemoteNetcdf
extends AbstractNetcdf {
    private NetcdfRemoteProxy remote;

    public static NetcdfService getNetcdfService(String string) throws RemoteException, NotBoundException, MalformedURLException {
        String string2 = "//" + string + "/" + "NetcdfService";
        return (NetcdfService)Naming.lookup(string2);
    }

    public RemoteNetcdf(NetcdfRemoteProxy netcdfRemoteProxy) throws RemoteException {
        super(netcdfRemoteProxy.getSchema(), false);
        this.remote = netcdfRemoteProxy;
        try {
            super.initHashtable();
        }
        catch (InstantiationException instantiationException) {
            throw new Error();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (RuntimeException)invocationTargetException.getTargetException();
        }
    }

    public RemoteNetcdf(String string, String string2) throws RemoteException, NotBoundException, MalformedURLException {
        this(RemoteNetcdf.getNetcdfService(string).lookup(string2));
    }

    public void close() throws RemoteException {
        this.remote.release();
    }

    protected Accessor ioFactory(ProtoVariable protoVariable) throws InvocationTargetException {
        try {
            return this.remote.getAccessor(protoVariable.getName());
        }
        catch (IOException iOException) {
            throw new InvocationTargetException(iOException);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println("test Usage: RemoteNetcdf nc_name");
            System.exit(1);
        }
        String string = stringArray[0];
        try {
            RemoteNetcdf remoteNetcdf = new RemoteNetcdf("localhost", string);
            System.out.println(remoteNetcdf);
            VariableIterator variableIterator = remoteNetcdf.iterator();
            while (variableIterator.hasNext()) {
                Variable variable = variableIterator.next();
                System.out.print(variable.getName() + "[0, ...]: ");
                MultiArray multiArray = variable.copyout(new int[variable.getRank()], variable.getLengths());
                System.out.println(multiArray.get(new int[multiArray.getRank()]));
            }
            remoteNetcdf.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
            System.exit(1);
        }
        System.exit(0);
    }
}

