/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.util.Date;
import java.util.Random;

public class RandomAccessFile
implements DataInput,
DataOutput {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int CREATE = 4;
    protected static final int defaultBufferSize = 4096;
    protected java.io.RandomAccessFile file;
    protected long filePosition;
    protected byte[] buffer;
    protected long bufferStart;
    protected long dataEnd;
    protected int dataSize;
    protected boolean endOfFile;
    protected int mode;
    boolean bufferModified = false;

    public RandomAccessFile(String string, int n) throws IOException {
        this(string, n, 4096);
    }

    public RandomAccessFile(String string, String string2) throws IOException {
        this(string, string2.equals("r") ? 1 : (string2.equals("rw") ? 3 : 0), 4096);
    }

    public RandomAccessFile(File file, String string) throws IOException {
        this(file.getPath(), string);
    }

    public RandomAccessFile(String string, int n, int n2) throws IOException {
        this.mode = n;
        n |= 1;
        if ((this.mode & 4) > 0) {
            this.mode |= 2;
        }
        File file = new File(string);
        if ((this.mode & 2) > 0 && !file.exists()) {
            n |= 4;
        }
        if ((this.mode & 4) > 0 && file.exists() && !file.delete()) {
            throw new IOException("Failed to delete " + string);
        }
        if (this.mode == 1 && !new File(string).exists()) {
            throw new FileNotFoundException(string);
        }
        String string2 = (this.mode & 2) > 0 ? "rw" : "r";
        this.file = new java.io.RandomAccessFile(string, string2);
        this.bufferStart = 0L;
        this.dataEnd = 0L;
        this.dataSize = 0;
        this.filePosition = 0L;
        this.buffer = new byte[n2];
        this.endOfFile = false;
    }

    public void close() throws IOException {
        if ((this.mode | 2) > 0 && this.bufferModified) {
            this.file.seek(this.bufferStart);
            this.file.write(this.buffer, 0, this.dataSize);
        }
        this.file.close();
    }

    public final void seek(long l) throws IOException {
        if (l >= this.bufferStart && l < this.dataEnd) {
            this.filePosition = l;
            return;
        }
        if (this.bufferModified) {
            this.flush();
        }
        this.file.seek(l);
        this.bufferStart = this.filePosition = this.file.getFilePointer();
        this.dataSize = this.file.read(this.buffer);
        if (this.dataSize < 0) {
            this.dataSize = 0;
            this.endOfFile = true;
        } else {
            this.endOfFile = false;
        }
        this.dataEnd = this.bufferStart + (long)this.dataSize;
    }

    public final long getFilePointer() throws IOException {
        return this.filePosition;
    }

    public long length() throws IOException {
        long l = this.file.length();
        if (l < this.dataEnd) {
            return this.dataEnd;
        }
        return l;
    }

    public final FileDescriptor getFD() throws IOException {
        return this.file.getFD();
    }

    public void flush() throws IOException {
        this.file.seek(this.bufferStart);
        this.file.write(this.buffer, 0, this.dataSize);
        this.bufferModified = false;
    }

    public final int read() throws IOException {
        if (this.filePosition < this.dataEnd) {
            return this.buffer[(int)(this.filePosition++ - this.bufferStart)] & 0xFF;
        }
        if (this.endOfFile) {
            return -1;
        }
        this.seek(this.filePosition);
        return this.read();
    }

    private int readBytes(byte[] byArray, int n, int n2) throws IOException {
        if (this.endOfFile) {
            return -1;
        }
        int n3 = (int)(this.dataEnd - this.filePosition);
        if (n3 < 1) {
            this.seek(this.filePosition);
            return this.readBytes(byArray, n, n2);
        }
        int n4 = n3 >= n2 ? n2 : n3;
        System.arraycopy(this.buffer, (int)(this.filePosition - this.bufferStart), byArray, n, n4);
        this.filePosition += (long)n4;
        if (n4 < n2) {
            int n5 = n2 - n4;
            if (n5 > this.buffer.length) {
                this.file.seek(this.filePosition);
                n5 = this.file.read(byArray, n + n4, n2 - n4);
            } else {
                this.seek(this.filePosition);
                if (!this.endOfFile) {
                    n5 = n5 > this.dataSize ? this.dataSize : n5;
                    System.arraycopy(this.buffer, 0, byArray, n + n4, n5);
                } else {
                    n5 = -1;
                }
            }
            if (n5 > 0) {
                this.filePosition += (long)n5;
                return n4 + n5;
            }
        }
        return n4;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.readBytes(byArray, n, n2);
    }

    public int read(byte[] byArray) throws IOException {
        return this.readBytes(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.read(byArray, n + n3, n2 - n3);
            if (n4 < 0) {
                throw new EOFException();
            }
            n3 += n4;
        }
    }

    public int skipBytes(int n) throws IOException {
        this.seek(this.getFilePointer() + (long)n);
        return n;
    }

    public final void unread() {
        --this.filePosition;
    }

    public final void write(int n) throws IOException {
        if (this.filePosition < this.dataEnd) {
            this.buffer[(int)(this.filePosition++ - this.bufferStart)] = (byte)n;
            this.bufferModified = true;
        } else if (this.dataSize != this.buffer.length) {
            this.buffer[(int)(this.filePosition++ - this.bufferStart)] = (byte)n;
            this.bufferModified = true;
            ++this.dataSize;
            ++this.dataEnd;
        } else {
            this.seek(this.filePosition);
            this.write(n);
        }
    }

    public final void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < this.buffer.length) {
            long l;
            int n3 = 0;
            int n4 = 0;
            if (this.filePosition >= this.bufferStart) {
                n3 = (int)(this.bufferStart + (long)this.buffer.length - this.filePosition);
            }
            if (n3 > 0) {
                n4 = n3 > n2 ? n2 : n3;
                System.arraycopy(byArray, n, this.buffer, (int)(this.filePosition - this.bufferStart), n4);
                this.bufferModified = true;
                l = this.filePosition + (long)n4;
                this.dataEnd = l > this.dataEnd ? l : this.dataEnd;
                this.dataSize = (int)(this.dataEnd - this.bufferStart);
                this.filePosition += (long)n4;
            }
            if (n4 < n2) {
                this.seek(this.filePosition);
                System.arraycopy(byArray, n + n4, this.buffer, (int)(this.filePosition - this.bufferStart), n2 - n4);
                this.bufferModified = true;
                l = this.filePosition + (long)(n2 - n4);
                this.dataEnd = l > this.dataEnd ? l : this.dataEnd;
                this.dataSize = (int)(this.dataEnd - this.bufferStart);
                this.filePosition += (long)(n2 - n4);
            }
        } else {
            if (this.bufferModified) {
                this.flush();
                this.dataSize = 0;
                this.bufferStart = this.dataEnd = (long)0;
            }
            this.file.write(byArray, n, n2);
            this.filePosition += (long)n2;
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.writeBytes(byArray, n, n2);
    }

    public final boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public final byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public final int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public final short readShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + (n << 0));
    }

    public final int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + (n << 0);
    }

    public final char readChar() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + (n << 0));
    }

    public final int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    public final long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readLine() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.read()) != -1 && n != 10) {
            stringBuffer.append((char)n);
        }
        if (n == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public final void writeByte(int n) throws IOException {
        this.write(n);
    }

    public final void writeShort(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public final void writeChar(int n) throws IOException {
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public final void writeInt(int n) throws IOException {
        this.write(n >>> 24 & 0xFF);
        this.write(n >>> 16 & 0xFF);
        this.write(n >>> 8 & 0xFF);
        this.write(n >>> 0 & 0xFF);
    }

    public final void writeLong(long l) throws IOException {
        this.write((int)(l >>> 56) & 0xFF);
        this.write((int)(l >>> 48) & 0xFF);
        this.write((int)(l >>> 40) & 0xFF);
        this.write((int)(l >>> 32) & 0xFF);
        this.write((int)(l >>> 24) & 0xFF);
        this.write((int)(l >>> 16) & 0xFF);
        this.write((int)(l >>> 8) & 0xFF);
        this.write((int)(l >>> 0) & 0xFF);
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeBytes(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.write((byte)string.charAt(n2));
            ++n2;
        }
    }

    public final void writeBytes(char[] cArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n2) {
            this.write((byte)cArray[n3]);
            ++n3;
        }
    }

    public final void writeChars(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            this.write(c >>> 8 & 0xFF);
            this.write(c >>> 0 & 0xFF);
            ++n2;
        }
    }

    public final void writeUTF(String string) throws IOException {
        int n;
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n = string.charAt(n4);
            n3 = n >= 1 && n <= 127 ? ++n3 : (n > 2047 ? (n3 += 3) : (n3 += 2));
            ++n4;
        }
        if (n3 > 65535) {
            throw new UTFDataFormatException();
        }
        this.write(n3 >>> 8 & 0xFF);
        this.write(n3 >>> 0 & 0xFF);
        n = 0;
        while (n < n2) {
            char c = string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                this.write(c);
            } else if (c > '\u07ff') {
                this.write(0xE0 | c >> 12 & 0xF);
                this.write(0x80 | c >> 6 & 0x3F);
                this.write(0x80 | c >> 0 & 0x3F);
            } else {
                this.write(0xC0 | c >> 6 & 0x1F);
                this.write(0x80 | c >> 0 & 0x3F);
            }
            ++n;
        }
    }

    public String toString() {
        return "fp=" + this.filePosition + ", bs=" + this.bufferStart + ", de=" + this.dataEnd + ", ds=" + this.dataSize + ", bl=" + this.buffer.length + ", m=" + this.mode + ", bm=" + this.bufferModified;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void testBytes(String string, int n) {
        System.out.println("\nTesting byte operations...");
        int n2 = (int)((double)n * 4.5);
        try {
            byte by;
            block33: {
                byte by2;
                Object object;
                int n3;
                block32: {
                    Object object2;
                    RandomAccessFile randomAccessFile = new RandomAccessFile(string, 6, n);
                    try {
                        object2 = new Random(0L);
                        by = 0;
                        n3 = 0;
                        while (true) {
                            if (n3 >= n2) {
                                Object var8_8 = null;
                                break;
                            }
                            by = (byte)(((Random)object2).nextInt() % 256);
                            randomAccessFile.writeByte(by);
                            ++n3;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        randomAccessFile.close();
                        throw throwable;
                    }
                    randomAccessFile.close();
                    if (new File(string).length() == (long)n2) {
                        System.out.println(". File size correct (" + n2 + ").");
                    } else {
                        System.out.println("X New file size incorrect (should be " + n2 + ", but is " + new File(string).length() + ").");
                    }
                    object2 = new RandomAccessFile(string, 3, n);
                    by = 1;
                    n3 = 0;
                    try {
                        Object var12_19;
                        try {
                            object = new Random(0L);
                            byte by3 = 0;
                            n3 = 0;
                            while (true) {
                                if (n3 >= n2) {
                                    by2 = 0;
                                    try {
                                        ((RandomAccessFile)object2).readByte();
                                    }
                                    catch (EOFException eOFException) {
                                        by2 = 1;
                                    }
                                    break;
                                }
                                by3 = (byte)(((Random)object).nextInt() % 256);
                                by2 = ((RandomAccessFile)object2).readByte();
                                if (by2 != by3) {
                                    by = 0;
                                }
                                if (by2 >= 128) {
                                    ((RandomAccessFile)object2).seek(((RandomAccessFile)object2).getFilePointer() - 1L);
                                    ((RandomAccessFile)object2).writeByte(0);
                                }
                                ++n3;
                            }
                            if (by2 != 0) {
                                System.err.println(". EOF found correctly");
                            } else {
                                System.err.println("X No EOF found.");
                            }
                        }
                        catch (EOFException eOFException) {
                            eOFException.printStackTrace();
                            System.err.println("    At byte " + n3);
                            var12_19 = null;
                            ((RandomAccessFile)object2).close();
                            break block32;
                        }
                        var12_19 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_20 = null;
                        ((RandomAccessFile)object2).close();
                        throw throwable;
                    }
                    ((RandomAccessFile)object2).close();
                }
                if (by != 0) {
                    System.out.println(". Read/Write verified");
                } else {
                    System.out.println("X Read/Write verification failed");
                }
                object = new RandomAccessFile(string, 1, n);
                by = 1;
                n3 = 0;
                try {
                    try {
                        Random random = new Random(0L);
                        by2 = 0;
                        n3 = 0;
                        while (n3 < n2) {
                            by2 = (byte)(random.nextInt() % 256);
                            byte by4 = ((RandomAccessFile)object).readByte();
                            if (by4 >= 128) {
                                by4 = 0;
                            }
                            if (by4 != by2) {
                                by = 0;
                            }
                            ++n3;
                        }
                    }
                    catch (EOFException eOFException) {
                        eOFException.printStackTrace();
                        System.err.println("    At byte " + n3);
                        Object var14_23 = null;
                        ((RandomAccessFile)object).close();
                        break block33;
                    }
                    Object var14_22 = null;
                }
                catch (Throwable throwable) {
                    Object var14_24 = null;
                    ((RandomAccessFile)object).close();
                    throw throwable;
                }
                ((RandomAccessFile)object).close();
            }
            if (by != 0) {
                System.out.println(". Update verified");
                return;
            }
            System.out.println("X Update verification failed");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void testBlocks(String string) {
        System.err.println("\nTesting block operations...");
        int n = 10;
        byte[] byArray = new byte[256];
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray[n2] = (byte)(n2 % 256);
            ++n2;
        }
        try {
            int n3;
            int n4;
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, 6, n);
            int n5 = 0;
            while (n5 < byArray.length) {
                int n6 = n5 < byArray.length / 2 ? 3 : 13;
                n6 = n5 + n6 >= byArray.length ? byArray.length - n5 : n6;
                randomAccessFile.write(byArray, n5, n6);
                n5 += n6;
            }
            randomAccessFile.close();
            if (new File(string).length() != (long)byArray.length) {
                System.out.println("X New file size incorrect (should be " + byArray.length + ", but is " + new File(string).length() + ").");
            } else {
                System.out.println(". File size correct (" + byArray.length + ").");
            }
            RandomAccessFile randomAccessFile2 = new RandomAccessFile(string, 1, n);
            boolean bl = true;
            int n7 = 256;
            Random random = new Random(0L);
            byte[] byArray2 = new byte[(int)((double)n * 0.5)];
            int n8 = 0;
            while (n8 < 100) {
                n4 = Math.abs(random.nextInt()) % (byArray.length - byArray2.length);
                randomAccessFile2.seek(n4);
                randomAccessFile2.read(byArray2);
                n3 = 0;
                while (n3 < byArray2.length) {
                    if (byArray2[n3] != byArray[n4 + n3]) {
                        bl = false;
                        if (n4 + n3 < n7) {
                            n7 = n4 + n3;
                        }
                    }
                    ++n3;
                }
                ++n8;
            }
            if (bl) {
                System.err.println(". Reading small blocks verified.");
            } else {
                System.err.println("X Reading small blocks failed (byte " + n7 + ").");
            }
            bl = true;
            random = new Random(0L);
            byArray2 = new byte[(int)((double)n * 1.5)];
            n4 = 0;
            while (n4 < 100) {
                n3 = Math.abs(random.nextInt()) % (byArray.length - byArray2.length);
                randomAccessFile2.seek(n3);
                randomAccessFile2.read(byArray2);
                int n9 = 0;
                while (n9 < byArray2.length) {
                    if (byArray2[n9] != byArray[n9 + n3]) {
                        bl = false;
                    }
                    ++n9;
                }
                ++n4;
            }
            if (bl) {
                System.err.println(". Reading large blocks verified.");
            } else {
                System.err.println("X Reading large blocks failed.");
            }
            randomAccessFile2.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void benchmark(String string, int n) {
        System.out.println("\nBenchmarking...");
        long l = new Date().getTime();
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, 1, n);
            RandomAccessFile randomAccessFile2 = new RandomAccessFile("temp.data", 6, n);
            try {
                Object var9_8;
                try {
                    while (true) {
                        randomAccessFile2.writeByte(randomAccessFile.readByte());
                    }
                }
                catch (EOFException eOFException) {
                    var9_8 = null;
                    randomAccessFile.close();
                    randomAccessFile2.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    var9_8 = null;
                    randomAccessFile.close();
                    randomAccessFile2.close();
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                randomAccessFile.close();
                randomAccessFile2.close();
                throw throwable;
            }
            System.out.println(". RandomAccessFile elapsed time=" + (new Date().getTime() - l));
            l = new Date().getTime();
            java.io.RandomAccessFile randomAccessFile3 = new java.io.RandomAccessFile(string, "r");
            java.io.RandomAccessFile randomAccessFile4 = new java.io.RandomAccessFile("temp.data", "rw");
            try {
                try {
                    while (true) {
                        randomAccessFile4.writeByte(randomAccessFile3.readByte());
                    }
                }
                catch (EOFException eOFException) {
                    Object var11_15 = null;
                    randomAccessFile3.close();
                    randomAccessFile4.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    Object var11_16 = null;
                    randomAccessFile3.close();
                    randomAccessFile4.close();
                }
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                randomAccessFile3.close();
                randomAccessFile4.close();
                throw throwable;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println(". java.io.RandomAccessFile elapsed time=" + (new Date().getTime() - l));
    }

    public static void main(String[] stringArray) {
        int n = 4096;
        String string = null;
        int n2 = 0;
        boolean bl = true;
        boolean bl2 = true;
        if (stringArray.length < 1) {
            System.err.println("Usage: RandomAccessFile <filename> [buffer.length] [benchmark | test]");
            System.exit(-1);
        } else if (stringArray.length < 2) {
            string = stringArray[0];
            n2 = n;
        } else if (stringArray.length < 3) {
            string = stringArray[0];
            n2 = Integer.parseInt(stringArray[1]);
        } else {
            string = stringArray[0];
            n2 = Integer.parseInt(stringArray[1]);
            if (stringArray[2].equals("benchmark")) {
                bl = false;
            } else if (stringArray[2].equals("test")) {
                bl2 = false;
            }
        }
        System.out.println("\nRandomAccessFile\n========================");
        System.out.println("filename=" + string + ", bufferSize=" + n2);
        System.out.println("totalMemory=" + Runtime.getRuntime().totalMemory() / 1000L + "k" + " freeMemory=" + Runtime.getRuntime().freeMemory() / 1000L + "k");
        if (bl) {
            RandomAccessFile.testBytes("temp.data", n2);
            RandomAccessFile.testBlocks("temp.data");
        }
        if (bl2) {
            RandomAccessFile.benchmark(string, n2);
        }
        System.out.println("\nEND");
    }
}

