/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import ucar.multiarray.MultiArrayInfo;
import ucar.netcdf.Attribute;
import ucar.netcdf.AttributeDictionary;
import ucar.netcdf.AttributeIterator;
import ucar.netcdf.AttributeSet;
import ucar.netcdf.Dimension;
import ucar.netcdf.DimensionDictionary;
import ucar.netcdf.DimensionIterator;
import ucar.netcdf.Named;
import ucar.netcdf.UnlimitedDimension;
import ucar.netcdf.Variable;

public class ProtoVariable
implements Named,
MultiArrayInfo,
Serializable,
Cloneable {
    private String name;
    private Class componentType;
    private Dimension[] dimArray;
    private AttributeDictionary attributes;

    static final boolean checkComponentType(Class clazz) {
        return clazz.isPrimitive() && !clazz.equals(Long.TYPE) && !clazz.equals(Boolean.TYPE);
    }

    public ProtoVariable(String string, Class clazz, Dimension[] dimensionArray) {
        this.name = string;
        if (!ProtoVariable.checkComponentType(clazz)) {
            throw new IllegalArgumentException("Invalid Type");
        }
        this.componentType = clazz;
        if (dimensionArray == null) {
            this.dimArray = new Dimension[0];
        } else {
            Dimension[] dimensionArray2 = dimensionArray;
            synchronized (dimensionArray2) {
                this.dimArray = new Dimension[dimensionArray.length];
                int n = 0;
                while (n < dimensionArray.length) {
                    Dimension dimension = dimensionArray[n];
                    if (dimension instanceof UnlimitedDimension) {
                        if (n > 0) {
                            throw new IllegalArgumentException("UnlimitedDimension not is leftmost position");
                        }
                    } else if (dimension.getLength() == 0) {
                        throw new IllegalArgumentException("Zero length dimension");
                    }
                    this.dimArray[n] = dimension;
                    ++n;
                }
            }
        }
        this.attributes = new AttributeDictionary();
    }

    public ProtoVariable(String string, Class clazz, Dimension dimension) {
        this.name = string;
        if (!ProtoVariable.checkComponentType(clazz)) {
            throw new IllegalArgumentException("Invalid Type");
        }
        this.componentType = clazz;
        this.dimArray = new Dimension[1];
        this.dimArray[0] = dimension;
        this.attributes = new AttributeDictionary();
    }

    public ProtoVariable(String string, Class clazz, Dimension[] dimensionArray, Attribute[] attributeArray) {
        this.name = string;
        if (!ProtoVariable.checkComponentType(clazz)) {
            throw new IllegalArgumentException("Invalid Type");
        }
        this.componentType = clazz;
        if (dimensionArray == null) {
            this.dimArray = new Dimension[0];
        } else {
            Dimension[] dimensionArray2 = dimensionArray;
            synchronized (dimensionArray2) {
                this.dimArray = new Dimension[dimensionArray.length];
                int n = 0;
                while (n < dimensionArray.length) {
                    Dimension dimension = dimensionArray[n];
                    if (dimension instanceof UnlimitedDimension) {
                        if (n > 0) {
                            throw new IllegalArgumentException("UnlimitedDimension not is leftmost position");
                        }
                    } else if (dimension.getLength() == 0) {
                        throw new IllegalArgumentException("Zero length dimension");
                    }
                    this.dimArray[n] = dimension;
                    ++n;
                }
            }
        }
        this.attributes = new AttributeDictionary(attributeArray);
    }

    ProtoVariable(ProtoVariable protoVariable) {
        this.name = protoVariable.getName();
        this.componentType = protoVariable.getComponentType();
        protoVariable.copyVolatile(this);
    }

    public ProtoVariable(Variable variable) {
        this.name = variable.meta.getName();
        this.componentType = variable.meta.getComponentType();
        variable.meta.copyVolatile(this);
    }

    private synchronized void copyVolatile(ProtoVariable protoVariable) {
        protoVariable.dimArray = new Dimension[this.dimArray.length];
        int n = 0;
        while (n < this.dimArray.length) {
            protoVariable.dimArray[n] = (Dimension)this.dimArray[n].clone();
            ++n;
        }
        protoVariable.attributes = new AttributeDictionary(this.attributes);
    }

    public Object clone() {
        try {
            ProtoVariable protoVariable = (ProtoVariable)super.clone();
            this.copyVolatile(protoVariable);
            return protoVariable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }

    public final String getName() {
        return this.name;
    }

    public final Class getComponentType() {
        return this.componentType;
    }

    public final int getRank() {
        return this.dimArray.length;
    }

    public final int[] getLengths() {
        int[] nArray = new int[this.dimArray.length];
        int n = 0;
        while (n < this.dimArray.length) {
            nArray[n] = this.dimArray[n].getLength();
            ++n;
        }
        return nArray;
    }

    public final boolean isUnlimited() {
        return this.dimArray.length > 0 && this.dimArray[0] instanceof UnlimitedDimension;
    }

    public final boolean isScalar() {
        return this.dimArray.length == 0;
    }

    public DimensionIterator getDimensionIterator() {
        return new DimensionIterator(){
            int position = 0;

            public boolean hasNext() {
                return this.position < ProtoVariable.this.dimArray.length;
            }

            public Dimension next() {
                return ProtoVariable.this.dimArray[this.position++];
            }
        };
    }

    public Attribute getAttribute(String string) {
        return this.attributes.get(string);
    }

    public AttributeSet getAttributes() {
        return this.attributes;
    }

    public Attribute putAttribute(Attribute attribute) {
        return this.attributes.put(attribute);
    }

    public void toCdl(StringBuffer stringBuffer) {
        stringBuffer.append(this.getComponentType());
        stringBuffer.append(" ");
        stringBuffer.append(this.getName());
        stringBuffer.append("(");
        DimensionIterator dimensionIterator = this.getDimensionIterator();
        while (dimensionIterator.hasNext()) {
            stringBuffer.append(dimensionIterator.next().getName());
            if (!dimensionIterator.hasNext()) break;
            stringBuffer.append(", ");
        }
        stringBuffer.append(") ;\n");
        AttributeIterator attributeIterator = this.getAttributes().iterator();
        while (attributeIterator.hasNext()) {
            stringBuffer.append("\t\t");
            stringBuffer.append(this.getName());
            attributeIterator.next().toCdl(stringBuffer);
            stringBuffer.append("\n");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toCdl(stringBuffer);
        return stringBuffer.toString();
    }

    synchronized void connectDims(DimensionDictionary dimensionDictionary) {
        int n = 0;
        while (n < this.dimArray.length) {
            this.dimArray[n] = dimensionDictionary.put(this.dimArray[n]);
            ++n;
        }
    }

    private int encodeComponentType() {
        if (this.componentType.isPrimitive()) {
            if (this.componentType.equals(Byte.TYPE)) {
                return 66;
            }
            if (this.componentType.equals(Character.TYPE)) {
                return 67;
            }
            if (this.componentType.equals(Double.TYPE)) {
                return 68;
            }
            if (this.componentType.equals(Float.TYPE)) {
                return 70;
            }
            if (this.componentType.equals(Integer.TYPE)) {
                return 73;
            }
            if (this.componentType.equals(Long.TYPE)) {
                return 74;
            }
            if (this.componentType.equals(Short.TYPE)) {
                return 83;
            }
            if (this.componentType.equals(Boolean.TYPE)) {
                return 90;
            }
        }
        throw new IllegalArgumentException(this.componentType.toString());
    }

    private static Class decodeComponentType(int n) throws InvalidClassException {
        switch (n) {
            case 66: {
                return Byte.TYPE;
            }
            case 67: {
                return Character.TYPE;
            }
            case 68: {
                return Double.TYPE;
            }
            case 70: {
                return Float.TYPE;
            }
            case 73: {
                return Integer.TYPE;
            }
            case 74: {
                return Long.TYPE;
            }
            case 83: {
                return Short.TYPE;
            }
            case 90: {
                return Boolean.TYPE;
            }
        }
        throw new InvalidClassException(Integer.toHexString(n));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.name);
        objectOutputStream.write(this.encodeComponentType());
        objectOutputStream.writeObject(this.dimArray);
        objectOutputStream.writeObject(this.attributes);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.name = (String)objectInputStream.readObject();
        int n = objectInputStream.read();
        this.componentType = ProtoVariable.decodeComponentType(n);
        this.dimArray = (Dimension[])objectInputStream.readObject();
        this.attributes = (AttributeDictionary)objectInputStream.readObject();
    }
}

