/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.lang.reflect.Array;
import ucar.netcdf.AttrVal;
import ucar.netcdf.Attribute;

final class NumericAttrVal
extends AttrVal {
    private final Object data;

    NumericAttrVal(Number number, Class clazz) {
        this.data = Array.newInstance(clazz, 1);
        Array.set(this.data, 0, number);
    }

    NumericAttrVal(Object object) {
        this.data = object;
    }

    public int hashCode() {
        int n = 0;
        int n2 = this.getLength();
        int n3 = 0;
        while (n3 < n2) {
            n = n * 13 + this.get(n3).hashCode();
            ++n3;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof NumericAttrVal) {
            int n;
            NumericAttrVal numericAttrVal = (NumericAttrVal)object;
            if (this.getComponentType() == numericAttrVal.getComponentType() && (n = this.getLength()) == numericAttrVal.getLength()) {
                int n2 = 0;
                while (n2 < n) {
                    if (!this.get(n2).equals(numericAttrVal.get(n2))) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        }
        return false;
    }

    Object getValue() {
        return Attribute.arrayClone(this.data);
    }

    Object get(int n) {
        return Array.get(this.data, n);
    }

    Number getNumericValue(int n) {
        return (Number)Array.get(this.data, n);
    }

    Number getNumericValue() {
        return this.getNumericValue(0);
    }

    Class getComponentType() {
        return this.data.getClass().getComponentType();
    }

    int getLength() {
        return Array.getLength(this.data);
    }

    void toCdl(StringBuffer stringBuffer) {
        int n = Array.getLength(this.data) - 1;
        int n2 = 0;
        while (n2 <= n) {
            stringBuffer.append(Array.get(this.data, n2));
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
    }
}

