/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.ConnectException;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RemoteServer;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;
import ucar.netcdf.NetcdfFile;
import ucar.netcdf.NetcdfRemoteProxy;
import ucar.netcdf.NetcdfRemoteProxyImpl;
import ucar.netcdf.NetcdfService;
import ucar.util.RMILogger;

public class NetcdfServer
extends UnicastRemoteObject
implements NetcdfService {
    private Hashtable byName_ = new Hashtable();
    private Registry registry_;
    static final RMILogger logger_ = new RMILogger();

    public static void setLog(OutputStream outputStream) {
        if (outputStream != null) {
            logger_.logUpTo(7);
            logger_.setLog(outputStream);
        } else {
            logger_.logUpTo(5);
            logger_.setLog(System.err);
            RemoteServer.setLog(outputStream);
        }
    }

    public NetcdfServer(String[] stringArray, Registry registry) throws RemoteException, AlreadyBoundException {
        int n = 0;
        while (n < stringArray.length) {
            this.export(stringArray[n]);
            ++n;
        }
        if (this.byName_.size() == 0) {
            throw new IllegalArgumentException("No exports");
        }
        if (registry != null) {
            this.registry_ = registry;
            registry.bind("NetcdfService", this);
            logger_.logNotice("NetcdfService bound in registry");
        }
    }

    public int ping() throws RemoteException {
        return 0;
    }

    public NetcdfRemoteProxy lookup(String string) throws RemoteException {
        Entry entry = this.get(string);
        if (entry == null) {
            throw new AccessException(string + " not available");
        }
        NetcdfFile netcdfFile = null;
        try {
            netcdfFile = entry.getNetcdfFile();
        }
        catch (IOException iOException) {
            throw new ServerException("lookup", iOException);
        }
        return (NetcdfRemoteProxy)((Object)UnicastRemoteObject.exportObject(new NetcdfRemoteProxyImpl(this, string, netcdfFile)));
    }

    public String[] list() throws RemoteException {
        String[] stringArray = new String[this.byName_.size()];
        Enumeration enumeration = this.byName_.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public void export(File file) {
        if (!file.isFile()) {
            throw new IllegalArgumentException(file.getPath() + " not a File");
        }
        Entry entry = new Entry(file);
        String string = entry.keyValue();
        logger_.logDebug("Exporting " + file + " as " + string);
        this.put(string, entry);
    }

    public void export(String string) {
        this.export(new File(string));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.registry_ != null) {
            try {
                this.registry_.unbind("NetcdfService");
            }
            catch (Exception exception) {
                logger_.logError("unbind: " + exception.getMessage());
            }
        }
        this.registry_ = null;
    }

    public static Registry startRegistry() throws RemoteException {
        logger_.logNotice("No registry, starting one");
        return LocateRegistry.createRegistry(1099);
    }

    public static Registry checkRegistry(Registry registry, int n) throws RemoteException {
        if (registry == null) {
            registry = NetcdfServer.startRegistry();
        }
        NetcdfService netcdfService = null;
        try {
            netcdfService = (NetcdfService)registry.lookup("NetcdfService");
        }
        catch (ConnectException connectException) {
            if (--n > 0) {
                return NetcdfServer.checkRegistry(NetcdfServer.startRegistry(), n);
            }
            throw connectException;
        }
        catch (NotBoundException notBoundException) {
            return registry;
        }
        try {
            netcdfService.ping();
        }
        catch (ConnectException connectException) {
            try {
                logger_.logNotice("unbinding dead registry entry");
                registry.unbind("NetcdfService");
            }
            catch (NotBoundException notBoundException) {
                // empty catch block
            }
        }
        return registry;
    }

    public static void main(String[] stringArray) {
        PrintStream printStream;
        System.setSecurityManager(new RMISecurityManager());
        Registry registry = null;
        try {
            registry = NetcdfServer.checkRegistry(LocateRegistry.getRegistry(), 2);
        }
        catch (Exception exception) {
            printStream = RemoteServer.getLog();
            if (printStream == null) {
                printStream = System.err;
            }
            printStream.println("NetcdfServer: error getting registry: " + exception.getMessage());
            exception.printStackTrace(printStream);
            System.exit(1);
        }
        try {
            NetcdfServer netcdfServer = new NetcdfServer(stringArray, registry);
        }
        catch (Throwable throwable) {
            printStream = RemoteServer.getLog();
            if (printStream == null) {
                printStream = System.err;
            }
            printStream.println("NetcdfServer err: " + throwable.getMessage());
            throwable.printStackTrace(printStream);
            System.exit(1);
        }
    }

    synchronized void _release(String string) {
        Entry entry = (Entry)this.byName_.get(string);
        if (entry != null) {
            entry.releaseNetcdfFile();
        }
    }

    private Entry get(String string) {
        return (Entry)this.byName_.get(string);
    }

    private synchronized void put(String string, Entry entry) {
        this.byName_.put(string, entry);
    }

    class Entry {
        final File dirent;
        NetcdfFile nc;
        int refcount;

        Entry(File file) {
            this.dirent = file;
            this.nc = null;
            this.refcount = 0;
        }

        String keyValue() {
            String string = this.dirent.getName();
            int n = string.indexOf(46);
            return string.substring(0, n).intern();
        }

        private synchronized void open(boolean bl) throws IOException {
            if (this.nc != null) {
                throw new IllegalArgumentException("dataSet " + this.keyValue() + " already open");
            }
            this.nc = new NetcdfFile(this.dirent, bl);
        }

        synchronized NetcdfFile getNetcdfFile() throws IOException {
            if (this.nc == null) {
                this.open(true);
            }
            ++this.refcount;
            logger_.logDebug("refcount: " + this.refcount);
            return this.nc;
        }

        private synchronized void close() {
            if (this.nc != null) {
                logger_.logDebug("closing: " + this.nc.getFile());
                try {
                    this.nc.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.nc = null;
                this.refcount = 0;
            }
        }

        synchronized void releaseNetcdfFile() {
            if (this.refcount > 0) {
                --this.refcount;
            }
            if (this.refcount == 0) {
                this.close();
            }
        }
    }
}

