/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import ucar.multiarray.AbstractAccessor;
import ucar.multiarray.Accessor;
import ucar.multiarray.MultiArray;
import ucar.multiarray.MultiArrayImpl;
import ucar.multiarray.OffsetIndexIterator;
import ucar.netcdf.AbstractNetcdf;
import ucar.netcdf.Attribute;
import ucar.netcdf.AttributeIterator;
import ucar.netcdf.AttributeSet;
import ucar.netcdf.Dimension;
import ucar.netcdf.DimensionIterator;
import ucar.netcdf.DimensionSet;
import ucar.netcdf.ProtoVariable;
import ucar.netcdf.RandomAccessFile;
import ucar.netcdf.Schema;
import ucar.netcdf.UnlimitedDimension;
import ucar.netcdf.Variable;
import ucar.netcdf.VariableIterator;

public class NetcdfFile
extends AbstractNetcdf {
    static final int v1magic = 1128547841;
    static final int NC_BYTE = 1;
    static final int NC_CHAR = 2;
    static final int NC_SHORT = 3;
    static final int NC_INT = 4;
    static final int NC_FLOAT = 5;
    static final int NC_DOUBLE = 6;
    static final int NC_DIMENSION = 10;
    static final int NC_VARIABLE = 11;
    static final int NC_ATTRIBUTE = 12;
    static final int X_ALIGN = 4;
    static final int X_SIZEOF_CHAR = 1;
    static final int X_SIZEOF_BYTE = 1;
    static final int X_SIZEOF_SHORT = 2;
    static final int X_SIZEOF_INT = 4;
    static final int X_SIZEOF_FLOAT = 4;
    static final int X_SIZEOF_DOUBLE = 8;
    static final String _FillValue = "_FillValue";
    static final byte NC_FILL_BYTE = -127;
    static final byte NC_FILL_CHAR = 0;
    static final short NC_FILL_SHORT = -32767;
    static final int NC_FILL_INT = -2147483647;
    static final float NC_FILL_FLOAT = 9.96921E36f;
    static final double NC_FILL_DOUBLE = (double)9.96921E36f;
    private File file;
    private RandomAccessFile raf;
    private UnlimitedDimension recDim;
    private int recsize;
    private boolean doFill;

    public NetcdfFile(File file, boolean bl, boolean bl2, Schema schema) throws IOException {
        super(new Schema(schema), true);
        if (!bl && file.exists()) {
            throw new SecurityException(file.getName() + " exists");
        }
        this.file = file;
        this.raf = new RandomAccessFile(file, "rw");
        this.doFill = bl2;
        this.compileBegins();
        this.initRecSize();
        this.writeV1();
        this.fillerup();
    }

    public NetcdfFile(String string, boolean bl, boolean bl2, Schema schema) throws IOException {
        this(new File(string), bl, bl2, schema);
    }

    public NetcdfFile(File file, boolean bl) throws IOException {
        this.file = file;
        this.raf = new RandomAccessFile(file, bl ? "r" : "rw");
        this.readV1(this.raf);
        this.initRecSize();
        this.doFill = true;
    }

    public NetcdfFile(String string, boolean bl) throws IOException {
        this(new File(string), bl);
    }

    public void close() throws IOException {
        this.raf.close();
    }

    public final File getFile() {
        return this.file;
    }

    public synchronized void setFill(boolean bl) {
        this.doFill = bl;
    }

    public final boolean getFill() {
        return this.doFill;
    }

    public final UnlimitedDimension unlimitedDimension() {
        return this.recDim;
    }

    public void toCdl(StringBuffer stringBuffer) {
        stringBuffer.append("netcdf ");
        stringBuffer.append(this.file.getName());
        stringBuffer.append(" ");
        super.toCdl(stringBuffer);
    }

    private int padsz(int n) {
        int n2 = n % 4;
        if (n2 == 0) {
            return 0;
        }
        return 4 - n2;
    }

    private int rndup(int n) {
        return n + this.padsz(n);
    }

    private int xszofV1String(String string) {
        int n = 4;
        return n += this.rndup(string.length());
    }

    private void writeV1String(String string) throws IOException {
        int n = string.length() % 4;
        if (n != 0) {
            n = 4 - n;
        }
        this.raf.writeInt(string.length());
        this.raf.writeBytes(string);
        while (n != 0) {
            this.raf.writeByte(0);
            --n;
        }
    }

    private String readV1String(DataInput dataInput, int n) throws IOException {
        int n2 = n % 4;
        if (n2 != 0) {
            n2 = 4 - n2;
        }
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        dataInput.skipBytes(n2);
        return new String(byArray).intern();
    }

    private String readV1String(DataInput dataInput) throws IOException {
        return this.readV1String(dataInput, dataInput.readInt());
    }

    private void writeV1Bytes(byte[] byArray) throws IOException {
        int n = byArray.length % 4;
        if (n != 0) {
            n = 4 - n;
        }
        this.raf.writeInt(byArray.length);
        this.raf.write(byArray);
        while (n != 0) {
            this.raf.writeByte(0);
            --n;
        }
    }

    private int v1TypeEncode(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz.equals(Character.TYPE)) {
                return 2;
            }
            if (clazz.equals(Byte.TYPE)) {
                return 1;
            }
            if (clazz.equals(Short.TYPE)) {
                return 3;
            }
            if (clazz.equals(Integer.TYPE)) {
                return 4;
            }
            if (clazz.equals(Float.TYPE)) {
                return 5;
            }
            if (clazz.equals(Double.TYPE)) {
                return 6;
            }
        }
        throw new IllegalArgumentException("Not a V1 type: " + clazz);
    }

    private Class v1TypeDecode(int n) {
        switch (n) {
            case 2: {
                return Character.TYPE;
            }
            case 1: {
                return Byte.TYPE;
            }
            case 3: {
                return Short.TYPE;
            }
            case 4: {
                return Integer.TYPE;
            }
            case 5: {
                return Float.TYPE;
            }
            case 6: {
                return Double.TYPE;
            }
        }
        return null;
    }

    private int xszofElement(Class clazz) {
        if (clazz.equals(Short.TYPE)) {
            return 2;
        }
        if (clazz.equals(Integer.TYPE)) {
            return 4;
        }
        if (clazz.equals(Float.TYPE)) {
            return 4;
        }
        if (clazz.equals(Double.TYPE)) {
            return 8;
        }
        return 1;
    }

    private int initVsize(DimensionIterator dimensionIterator, int n) {
        int n2 = 1;
        while (dimensionIterator.hasNext()) {
            Dimension dimension = dimensionIterator.next();
            if (dimension instanceof UnlimitedDimension) continue;
            n2 *= dimension.getLength();
        }
        return n2 *= n;
    }

    private void writeV1(Dimension dimension) throws IOException {
        this.writeV1String(dimension.getName());
        if (dimension instanceof UnlimitedDimension) {
            this.raf.writeInt(0);
        } else {
            this.raf.writeInt(dimension.getLength());
        }
    }

    private int xszof(Dimension dimension) {
        int n = this.xszofV1String(dimension.getName());
        return n += 4;
    }

    private void writeV1(Attribute attribute) throws IOException {
        this.writeV1String(attribute.getName());
        if (attribute.isString()) {
            this.raf.writeInt(2);
            this.writeV1String((String)attribute.getValue());
            return;
        }
        int n = this.v1TypeEncode(attribute.getComponentType());
        this.raf.writeInt(n);
        if (n == 2) {
            this.writeV1String((String)attribute.getValue());
            return;
        }
        if (n == 1) {
            this.writeV1Bytes((byte[])attribute.getValue());
            return;
        }
        int n2 = Array.getLength(attribute.getValue());
        this.raf.writeInt(n2);
        int n3 = 0;
        while (n3 < n2) {
            switch (n) {
                case 3: {
                    this.raf.writeShort(((short[])attribute.getValue())[n3]);
                    if (n2 % 2 == 0) break;
                    this.raf.writeShort(0);
                    break;
                }
                case 4: {
                    this.raf.writeInt(((int[])attribute.getValue())[n3]);
                    break;
                }
                case 5: {
                    this.raf.writeFloat(((float[])attribute.getValue())[n3]);
                    break;
                }
                case 6: {
                    this.raf.writeDouble(((double[])attribute.getValue())[n3]);
                }
            }
            ++n3;
        }
    }

    private int xszof(Attribute attribute) {
        int n = this.xszofV1String(attribute.getName());
        n += 4;
        if (attribute.isString()) {
            return n + this.xszofV1String((String)attribute.getValue());
        }
        n += 4;
        int n2 = this.v1TypeEncode(attribute.getComponentType());
        int n3 = Array.getLength(attribute.getValue());
        switch (n2) {
            case 1: 
            case 2: {
                n += this.rndup(n3);
                break;
            }
            case 3: {
                n += this.rndup(n3 * 2);
                break;
            }
            case 4: {
                n += n3 * 4;
                break;
            }
            case 5: {
                n += n3 * 4;
                break;
            }
            case 6: {
                n += n3 * 8;
            }
        }
        return n;
    }

    private Dimension[] readV1DimensionArray(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        int n2 = dataInput.readInt();
        if (n2 != 10 && n2 != 0) {
            throw new IllegalArgumentException("Not a netcdf file (dimensions)");
        }
        int n3 = dataInput.readInt();
        Dimension[] dimensionArray = new Dimension[n3];
        int n4 = 0;
        while (n4 < n3) {
            String string = this.readV1String(dataInput);
            int n5 = dataInput.readInt();
            if (n5 == 0) {
                if (this.recDim != null) {
                    throw new IllegalArgumentException("Multiple UnlimitedDimensions");
                }
                this.recDim = new UnlimitedDimension(string, n);
                dimensionArray[n4] = this.recDim;
            } else {
                dimensionArray[n4] = new Dimension(string, n5);
            }
            ++n4;
        }
        return dimensionArray;
    }

    private void writeV1(DimensionSet dimensionSet) throws IOException {
        this.writeV1numrecs();
        int n = dimensionSet.size();
        if (n != 0) {
            this.raf.writeInt(10);
        } else {
            this.raf.writeInt(0);
        }
        this.raf.writeInt(n);
        DimensionIterator dimensionIterator = dimensionSet.iterator();
        while (dimensionIterator.hasNext()) {
            this.writeV1(dimensionIterator.next());
        }
    }

    private int xszof(DimensionSet dimensionSet) {
        int n = 4;
        n += 4;
        n += 4;
        DimensionIterator dimensionIterator = dimensionSet.iterator();
        while (dimensionIterator.hasNext()) {
            n += this.xszof(dimensionIterator.next());
        }
        return n;
    }

    private void writeV1numrecs() throws IOException {
        if (this.recDim == null) {
            this.raf.writeInt(0);
        } else {
            this.raf.writeInt(this.recDim.getLength());
        }
    }

    private void writeV1(AttributeSet attributeSet) throws IOException {
        int n = attributeSet.size();
        if (n != 0) {
            this.raf.writeInt(12);
        } else {
            this.raf.writeInt(0);
        }
        this.raf.writeInt(n);
        AttributeIterator attributeIterator = attributeSet.iterator();
        while (attributeIterator.hasNext()) {
            this.writeV1(attributeIterator.next());
        }
    }

    private Object readV1AttrVal(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        int n2 = dataInput.readInt();
        switch (n) {
            case 2: {
                int n3 = n2 % 4;
                if (n3 != 0) {
                    n3 = 4 - n3;
                }
                char[] cArray = new char[n2];
                int n4 = 0;
                while (n4 < n2) {
                    cArray[n4] = (char)dataInput.readUnsignedByte();
                    ++n4;
                }
                dataInput.skipBytes(n3);
                return cArray;
            }
            case 1: {
                int n5 = n2 % 4;
                if (n5 != 0) {
                    n5 = 4 - n5;
                }
                byte[] byArray = new byte[n2];
                dataInput.readFully(byArray);
                dataInput.skipBytes(n5);
                return byArray;
            }
            case 3: {
                short[] sArray = new short[n2];
                int n6 = 0;
                while (n6 < n2) {
                    sArray[n6] = dataInput.readShort();
                    ++n6;
                }
                if (n2 % 2 != 0) {
                    dataInput.skipBytes(2);
                }
                return sArray;
            }
            case 4: {
                int[] nArray = new int[n2];
                int n7 = 0;
                while (n7 < n2) {
                    nArray[n7] = dataInput.readInt();
                    ++n7;
                }
                return nArray;
            }
            case 5: {
                float[] fArray = new float[n2];
                int n8 = 0;
                while (n8 < n2) {
                    fArray[n8] = dataInput.readFloat();
                    ++n8;
                }
                return fArray;
            }
            case 6: {
                double[] dArray = new double[n2];
                int n9 = 0;
                while (n9 < n2) {
                    dArray[n9] = dataInput.readDouble();
                    ++n9;
                }
                return dArray;
            }
        }
        return null;
    }

    private Attribute[] readV1AttributeArray(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n != 12 && n != 0) {
            throw new IllegalArgumentException("Not a netcdf file (attributes)");
        }
        int n2 = dataInput.readInt();
        Attribute[] attributeArray = new Attribute[n2];
        int n3 = 0;
        while (n3 < n2) {
            String string = this.readV1String(dataInput);
            Object object = this.readV1AttrVal(dataInput);
            attributeArray[n3] = new Attribute(string, object);
            ++n3;
        }
        return attributeArray;
    }

    private int xszof(AttributeSet attributeSet) {
        int n = 4;
        n += 4;
        AttributeIterator attributeIterator = attributeSet.iterator();
        while (attributeIterator.hasNext()) {
            n += this.xszof(attributeIterator.next());
        }
        return n;
    }

    private V1Io V1IoFactory(ProtoVariable protoVariable) {
        Class clazz = protoVariable.getComponentType();
        V1Io v1Io = null;
        if (clazz.equals(Character.TYPE)) {
            v1Io = new V1CharacterIo(protoVariable);
        } else if (clazz.equals(Byte.TYPE)) {
            v1Io = new V1ByteIo(protoVariable);
        } else if (clazz.equals(Short.TYPE)) {
            v1Io = new V1ShortIo(protoVariable);
        } else if (clazz.equals(Integer.TYPE)) {
            v1Io = new V1IntegerIo(protoVariable);
        } else if (clazz.equals(Float.TYPE)) {
            v1Io = new V1FloatIo(protoVariable);
        } else if (clazz.equals(Double.TYPE)) {
            v1Io = new V1DoubleIo(protoVariable);
        }
        return v1Io;
    }

    protected Accessor ioFactory(ProtoVariable protoVariable) {
        return this.V1IoFactory(protoVariable);
    }

    private void writeV1(Variable variable) throws IOException {
        this.writeV1String(variable.getName());
        this.raf.writeInt(variable.getRank());
        DimensionIterator dimensionIterator = variable.getDimensionIterator();
        while (dimensionIterator.hasNext()) {
            this.raf.writeInt(this.indexOf(dimensionIterator.next()));
        }
        this.writeV1(variable.getAttributes());
        this.raf.writeInt(this.v1TypeEncode(variable.getComponentType()));
        V1Io v1Io = (V1Io)variable.io;
        this.raf.writeInt(v1Io.vsize);
        this.raf.writeInt(v1Io.begin);
    }

    private int xszof(Variable variable) {
        int n = this.xszofV1String(variable.getName());
        n += 4;
        n += variable.getRank() * 4;
        n += this.xszof(variable.getAttributes());
        n += 4;
        n += 4;
        return n += 4;
    }

    private void readV1VarArray(DataInput dataInput, Dimension[] dimensionArray) throws IOException {
        int n = dataInput.readInt();
        if (n != 11 && n != 0) {
            throw new IllegalArgumentException("Not a netcdf file (variables)");
        }
        int n2 = dataInput.readInt();
        int n3 = 0;
        while (n3 < n2) {
            String string = this.readV1String(dataInput);
            int n4 = dataInput.readInt();
            Dimension[] dimensionArray2 = new Dimension[n4];
            int n5 = 0;
            while (n5 < n4) {
                dimensionArray2[n5] = dimensionArray[dataInput.readInt()];
                ++n5;
            }
            Attribute[] attributeArray = this.readV1AttributeArray(dataInput);
            Class clazz = this.v1TypeDecode(dataInput.readInt());
            ProtoVariable protoVariable = new ProtoVariable(string, clazz, dimensionArray2, attributeArray);
            V1Io v1Io = this.V1IoFactory(protoVariable);
            v1Io.vsize = dataInput.readInt();
            v1Io.begin = dataInput.readInt();
            try {
                this.add(protoVariable, v1Io);
            }
            catch (InstantiationException instantiationException) {
                throw new Error();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Error();
            }
            catch (InvocationTargetException invocationTargetException) {
                throw (RuntimeException)invocationTargetException.getTargetException();
            }
            ++n3;
        }
    }

    private void writeV1(int n, VariableIterator variableIterator) throws IOException {
        if (n != 0) {
            this.raf.writeInt(11);
        } else {
            this.raf.writeInt(0);
        }
        this.raf.writeInt(n);
        while (variableIterator.hasNext()) {
            this.writeV1(variableIterator.next());
        }
    }

    private int xszof(VariableIterator variableIterator) {
        int n = 4;
        n += 4;
        while (variableIterator.hasNext()) {
            n += this.xszof(variableIterator.next());
        }
        return n;
    }

    private void writeV1() throws IOException {
        this.raf.writeInt(1128547841);
        this.writeV1(this.getDimensions());
        this.writeV1(this.getAttributes());
        this.writeV1(this.size(), this.iterator());
    }

    private int xszof() {
        int n = 4;
        n += this.xszof(this.getDimensions());
        n += this.xszof(this.getAttributes());
        return n += this.xszof(this.iterator());
    }

    private void readV1(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n != 1128547841) {
            throw new IllegalArgumentException("Not a netcdf file");
        }
        Dimension[] dimensionArray = this.readV1DimensionArray(dataInput);
        int n2 = 0;
        while (n2 < dimensionArray.length) {
            this.putDimension(dimensionArray[n2]);
            ++n2;
        }
        Attribute[] attributeArray = this.readV1AttributeArray(dataInput);
        int n3 = 0;
        while (n3 < attributeArray.length) {
            this.putAttribute(attributeArray[n3]);
            ++n3;
        }
        this.readV1VarArray(dataInput, dimensionArray);
    }

    private void compileBegins() {
        Object object;
        Variable variable;
        int n = this.xszof();
        VariableIterator variableIterator = this.iterator();
        while (variableIterator.hasNext()) {
            variable = variableIterator.next();
            if (variable.isUnlimited()) continue;
            object = (V1Io)variable.io;
            ((V1Io)object).begin = n;
            n += ((V1Io)object).vsize;
        }
        variableIterator = this.iterator();
        while (variableIterator.hasNext()) {
            variable = variableIterator.next();
            if (!variable.isUnlimited()) continue;
            if (this.recDim == null) {
                object = variable.getDimensionIterator().next();
                if (!(object instanceof UnlimitedDimension)) {
                    throw new IllegalArgumentException("Unlimited Dim not leftmost");
                }
                this.recDim = (UnlimitedDimension)object;
            }
            object = (V1Io)variable.io;
            ((V1Io)object).begin = n;
            n += ((V1Io)object).vsize;
        }
    }

    private void initRecSize() {
        this.recsize = 0;
        VariableIterator variableIterator = this.iterator();
        while (variableIterator.hasNext()) {
            Variable variable = variableIterator.next();
            if (!variable.isUnlimited()) continue;
            V1Io v1Io = (V1Io)variable.io;
            if (this.recsize == 0 && !variableIterator.hasNext()) {
                this.recsize = this.initVsize(variable.getDimensionIterator(), v1Io.xsz);
                break;
            }
            this.recsize += v1Io.vsize;
        }
    }

    void fillRec(int n) throws IOException {
        VariableIterator variableIterator = this.iterator();
        while (variableIterator.hasNext()) {
            Variable variable = variableIterator.next();
            if (!variable.isUnlimited()) continue;
            V1Io v1Io = (V1Io)variable.io;
            long l = (long)v1Io.begin + (long)n * (long)this.recsize;
            v1Io.fillO(l);
        }
    }

    private void fillerup() throws IOException {
        if (!this.doFill) {
            return;
        }
        VariableIterator variableIterator = this.iterator();
        while (variableIterator.hasNext()) {
            Variable variable = variableIterator.next();
            if (variable.isUnlimited()) continue;
            V1Io v1Io = (V1Io)variable.io;
            v1Io.fillO(v1Io.begin);
        }
        if (this.recDim != null) {
            int n = this.recDim.getLength();
            int n2 = 0;
            while (n2 < n) {
                this.fillRec(n2);
                ++n2;
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    private final class V1DoubleIo
    extends V1Io {
        V1DoubleIo(ProtoVariable protoVariable) {
            super(protoVariable);
        }

        void readArray(long l, Object object, int n, int n2) throws IOException {
            double[] dArray = (double[])object;
            NetcdfFile.this.raf.seek(l);
            int n3 = n + n2;
            int n4 = n;
            while (n4 < n3) {
                dArray[n4] = NetcdfFile.this.raf.readDouble();
                ++n4;
            }
        }

        public double getDouble(int[] nArray) throws IOException {
            NetcdfFile.this.raf.seek(this.computeOffset(nArray));
            return NetcdfFile.this.raf.readDouble();
        }

        public Object get(int[] nArray) throws IOException {
            return new Double(this.getDouble(nArray));
        }

        void writeArray(long l, Object object, int n, int n2) throws IOException {
            double[] dArray = (double[])object;
            NetcdfFile.this.raf.seek(l);
            int n3 = n + n2;
            int n4 = n;
            while (n4 < n3) {
                NetcdfFile.this.raf.writeDouble(dArray[n4]);
                ++n4;
            }
        }

        public void setDouble(int[] nArray, double d) throws IOException {
            if (this.isUnlimited) {
                this.checkfill(nArray[0] + 1);
            }
            NetcdfFile.this.raf.seek(this.computeOffset(nArray));
            NetcdfFile.this.raf.writeDouble(d);
        }

        public void set(int[] nArray, Object object) throws IOException {
            this.setDouble(nArray, ((Number)object).doubleValue());
        }

        final void fill(DataOutput dataOutput, int n, Attribute attribute) throws IOException {
            double d = 9.96921E36f;
            if (attribute != null) {
                d = attribute.getNumericValue().doubleValue();
            }
            int n2 = 0;
            while (n2 < n) {
                dataOutput.writeDouble(d);
                ++n2;
            }
        }
    }

    private final class V1FloatIo
    extends V1Io {
        V1FloatIo(ProtoVariable protoVariable) {
            super(protoVariable);
        }

        void readArray(long l, Object object, int n, int n2) throws IOException {
            float[] fArray = (float[])object;
            NetcdfFile.this.raf.seek(l);
            int n3 = n + n2;
            int n4 = n;
            while (n4 < n3) {
                fArray[n4] = NetcdfFile.this.raf.readFloat();
                ++n4;
            }
        }

        public float getFloat(int[] nArray) throws IOException {
            NetcdfFile.this.raf.seek(this.computeOffset(nArray));
            return NetcdfFile.this.raf.readFloat();
        }

        public Object get(int[] nArray) throws IOException {
            return new Float(this.getFloat(nArray));
        }

        void writeArray(long l, Object object, int n, int n2) throws IOException {
            float[] fArray = (float[])object;
            NetcdfFile.this.raf.seek(l);
            int n3 = n + n2;
            int n4 = n;
            while (n4 < n3) {
                NetcdfFile.this.raf.writeFloat(fArray[n4]);
                ++n4;
            }
        }

        public void setFloat(int[] nArray, float f) throws IOException {
            if (this.isUnlimited) {
                this.checkfill(nArray[0] + 1);
            }
            NetcdfFile.this.raf.seek(this.computeOffset(nArray));
            NetcdfFile.this.raf.writeFloat(f);
        }

        public void set(int[] nArray, Object object) throws IOException {
            this.setFloat(nArray, ((Number)object).floatValue());
        }

        final void fill(DataOutput dataOutput, int n, Attribute attribute) throws IOException {
            float f = 9.96921E36f;
            if (attribute != null) {
                f = attribute.getNumericValue().floatValue();
            }
            int n2 = 0;
            while (n2 < n) {
                dataOutput.writeFloat(f);
                ++n2;
            }
        }
    }

    private final class V1IntegerIo
    extends V1Io {
        V1IntegerIo(ProtoVariable protoVariable) {
            super(protoVariable);
        }

        void readArray(long l, Object object, int n, int n2) throws IOException {
            int[] nArray = (int[])object;
            NetcdfFile.this.raf.seek(l);
            int n3 = n + n2;
            int n4 = n;
            while (n4 < n3) {
                nArray[n4] = NetcdfFile.this.raf.readInt();
                ++n4;
            }
        }

        public int getInt(int[] nArray) throws IOException {
            NetcdfFile.this.raf.seek(this.computeOffset(nArray));
            return NetcdfFile.this.raf.readInt();
        }

        public Object get(int[] nArray) throws IOException {
            return new Integer(this.getInt(nArray));
        }

        void writeArray(long l, Object object, int n, int n2) throws IOException {
            int[] nArray = (int[])object;
            NetcdfFile.this.raf.seek(l);
            int n3 = n + n2;
            int n4 = n;
            while (n4 < n3) {
                NetcdfFile.this.raf.writeInt(nArray[n4]);
                ++n4;
            }
        }

        public void setInt(int[] nArray, int n) throws IOException {
            if (this.isUnlimited) {
                this.checkfill(nArray[0] + 1);
            }
            NetcdfFile.this.raf.seek(this.computeOffset(nArray));
            NetcdfFile.this.raf.writeInt(n);
        }

        public void set(int[] nArray, Object object) throws IOException {
            this.setInt(nArray, ((Number)object).intValue());
        }

        final void fill(DataOutput dataOutput, int n, Attribute attribute) throws IOException {
            int n2 = -2147483647;
            if (attribute != null) {
                n2 = attribute.getNumericValue().intValue();
            }
            int n3 = 0;
            while (n3 < n) {
                dataOutput.writeInt(n2);
                ++n3;
            }
        }
    }

    private final class V1ShortIo
    extends V1Io {
        V1ShortIo(ProtoVariable protoVariable) {
            super(protoVariable);
        }

        void readArray(long l, Object object, int n, int n2) throws IOException {
            short[] sArray = (short[])object;
            NetcdfFile.this.raf.seek(l);
            int n3 = n + n2;
            int n4 = n;
            while (n4 < n3) {
                sArray[n4] = NetcdfFile.this.raf.readShort();
                ++n4;
            }
        }

        public short getShort(int[] nArray) throws IOException {
            NetcdfFile.this.raf.seek(this.computeOffset(nArray));
            return NetcdfFile.this.raf.readShort();
        }

        public Object get(int[] nArray) throws IOException {
            return new Short(this.getShort(nArray));
        }

        void writeArray(long l, Object object, int n, int n2) throws IOException {
            short[] sArray = (short[])object;
            NetcdfFile.this.raf.seek(l);
            int n3 = n + n2;
            int n4 = n;
            while (n4 < n3) {
                NetcdfFile.this.raf.writeShort(sArray[n4]);
                ++n4;
            }
        }

        public void setShort(int[] nArray, short s) throws IOException {
            if (this.isUnlimited) {
                this.checkfill(nArray[0] + 1);
            }
            NetcdfFile.this.raf.seek(this.computeOffset(nArray));
            NetcdfFile.this.raf.writeShort(s);
        }

        public void set(int[] nArray, Object object) throws IOException {
            this.setShort(nArray, ((Number)object).shortValue());
        }

        final void fill(DataOutput dataOutput, int n, Attribute attribute) throws IOException {
            int n2 = -32767;
            if (attribute != null) {
                n2 = attribute.getNumericValue().shortValue();
            }
            int n3 = 0;
            while (n3 < n) {
                dataOutput.writeShort(n2);
                ++n3;
            }
        }
    }

    private final class V1CharacterIo
    extends V1Io {
        V1CharacterIo(ProtoVariable protoVariable) {
            super(protoVariable);
        }

        void readArray(long l, Object object, int n, int n2) throws IOException {
            char[] cArray = (char[])object;
            NetcdfFile.this.raf.seek(l);
            int n3 = n + n2;
            int n4 = n;
            while (n4 < n3) {
                cArray[n4] = (char)NetcdfFile.this.raf.readUnsignedByte();
                ++n4;
            }
        }

        public char getChar(int[] nArray) throws IOException {
            NetcdfFile.this.raf.seek(this.computeOffset(nArray));
            return (char)NetcdfFile.this.raf.readUnsignedByte();
        }

        public Object get(int[] nArray) throws IOException {
            return new Character(this.getChar(nArray));
        }

        void writeArray(long l, Object object, int n, int n2) throws IOException {
            char[] cArray = (char[])object;
            NetcdfFile.this.raf.seek(l);
            int n3 = n + n2;
            int n4 = n;
            while (n4 < n3) {
                NetcdfFile.this.raf.writeByte((byte)cArray[n4]);
                ++n4;
            }
        }

        public void setChar(int[] nArray, char c) throws IOException {
            if (this.isUnlimited) {
                this.checkfill(nArray[0] + 1);
            }
            NetcdfFile.this.raf.seek(this.computeOffset(nArray));
            NetcdfFile.this.raf.writeByte((byte)c);
        }

        public void set(int[] nArray, Object object) throws IOException {
            this.setChar(nArray, ((Character)object).charValue());
        }

        final void fill(DataOutput dataOutput, int n, Attribute attribute) throws IOException {
            byte by = 0;
            if (attribute != null) {
                by = attribute.getNumericValue().byteValue();
            }
            int n2 = 0;
            while (n2 < n) {
                dataOutput.write(by);
                ++n2;
            }
        }
    }

    private final class V1ByteIo
    extends V1Io {
        V1ByteIo(ProtoVariable protoVariable) {
            super(protoVariable);
        }

        void readArray(long l, Object object, int n, int n2) throws IOException {
            byte[] byArray = (byte[])object;
            NetcdfFile.this.raf.seek(l);
            NetcdfFile.this.raf.read(byArray, n, n2);
        }

        public byte getByte(int[] nArray) throws IOException {
            NetcdfFile.this.raf.seek(this.computeOffset(nArray));
            return NetcdfFile.this.raf.readByte();
        }

        public Object get(int[] nArray) throws IOException {
            return new Byte(this.getByte(nArray));
        }

        void writeArray(long l, Object object, int n, int n2) throws IOException {
            byte[] byArray = (byte[])object;
            NetcdfFile.this.raf.seek(l);
            NetcdfFile.this.raf.write(byArray, n, n2);
        }

        public void setByte(int[] nArray, byte by) throws IOException {
            if (this.isUnlimited) {
                this.checkfill(nArray[0] + 1);
            }
            NetcdfFile.this.raf.seek(this.computeOffset(nArray));
            NetcdfFile.this.raf.writeByte(by);
        }

        public void set(int[] nArray, Object object) throws IOException {
            this.setByte(nArray, ((Number)object).byteValue());
        }

        final void fill(DataOutput dataOutput, int n, Attribute attribute) throws IOException {
            int n2 = -127;
            if (attribute != null) {
                n2 = attribute.getNumericValue().byteValue();
            }
            int n3 = 0;
            while (n3 < n) {
                dataOutput.write(n2);
                ++n3;
            }
        }
    }

    abstract class V1Io
    extends AbstractAccessor {
        private final ProtoVariable meta;
        private final int[] lengths;
        byte[] fillbytes;
        int vsize;
        int begin;
        final boolean isUnlimited;
        final int[] dsizes;
        int xsz;

        protected V1Io(ProtoVariable protoVariable) {
            this.meta = protoVariable;
            this.lengths = protoVariable.getLengths();
            this.initFillValue(protoVariable);
            this.vsize = NetcdfFile.this.rndup(NetcdfFile.this.initVsize(protoVariable.getDimensionIterator(), NetcdfFile.this.xszofElement(protoVariable.getComponentType())));
            this.begin = 0;
            this.isUnlimited = protoVariable.isUnlimited();
            this.dsizes = this.compileDsizes(protoVariable.getLengths());
            this.xsz = NetcdfFile.this.xszofElement(protoVariable.getComponentType());
        }

        abstract void readArray(long var1, Object var3, int var4, int var5) throws IOException;

        private final int iocount(int[] nArray, int[] nArray2) {
            int n = 1;
            int n2 = 0;
            if (this.isUnlimited) {
                n2 = 1;
            }
            int n3 = nArray2.length - 1;
            while (n3 >= n2) {
                int n4 = nArray2[n3];
                n *= n4;
                if (nArray[n3] != 0 || n4 < this.lengths[n3]) break;
                --n3;
            }
            return n;
        }

        public MultiArray copyout(int[] nArray, int[] nArray2) throws IOException {
            int[] nArray3 = (int[])nArray2.clone();
            int[] nArray4 = new int[nArray3.length];
            int n = MultiArrayImpl.numberOfElements(nArray3, nArray4);
            Object object = Array.newInstance(this.meta.getComponentType(), n);
            int n2 = this.iocount(nArray, nArray2);
            int[] nArray5 = (int[])nArray3.clone();
            int n3 = 0;
            while (n3 < nArray5.length) {
                int n4 = n3;
                nArray5[n4] = nArray5[n4] + nArray[n3];
                ++n3;
            }
            OffsetIndexIterator offsetIndexIterator = new OffsetIndexIterator(nArray, nArray5);
            int n5 = 0;
            while (offsetIndexIterator.notDone()) {
                long l = this.computeOffset(offsetIndexIterator.value());
                this.readArray(l, object, n5, n2);
                offsetIndexIterator.advance(n2);
                n5 += n2;
            }
            return new MultiArrayImpl(nArray3, nArray4, object);
        }

        abstract void writeArray(long var1, Object var3, int var4, int var5) throws IOException;

        public void copyin(int[] nArray, MultiArray multiArray) throws IOException {
            if (multiArray instanceof MultiArrayImpl) {
                this.copyin(nArray, (MultiArrayImpl)multiArray);
            } else {
                if (this.isUnlimited) {
                    this.checkfill(nArray[0] + multiArray.getLengths()[0]);
                }
                super.copyin(nArray, multiArray);
            }
        }

        public void copyin(int[] nArray, MultiArrayImpl multiArrayImpl) throws IOException {
            int[] nArray2 = multiArrayImpl.getLengths();
            int n = this.iocount(nArray, nArray2);
            int n2 = 0;
            while (n2 < nArray2.length) {
                int n3 = n2;
                nArray2[n3] = nArray2[n3] + nArray[n2];
                ++n2;
            }
            if (this.isUnlimited) {
                this.checkfill(nArray2[0]);
            }
            Object object = multiArrayImpl.storage;
            OffsetIndexIterator offsetIndexIterator = new OffsetIndexIterator(nArray, nArray2);
            int n4 = 0;
            while (offsetIndexIterator.notDone()) {
                long l = this.computeOffset(offsetIndexIterator.value());
                this.writeArray(l, object, n4, n);
                offsetIndexIterator.advance(n);
                n4 += n;
            }
        }

        public Object toArray() throws IOException {
            return this.toArray(null, null, null);
        }

        public Object toArray(Object object, int[] nArray, int[] nArray2) throws IOException {
            int n = this.getRank();
            if (nArray == null) {
                nArray = new int[n];
            } else if (nArray.length != n) {
                throw new IllegalArgumentException("Rank Mismatch");
            }
            int[] nArray3 = null;
            if (nArray2 == null) {
                nArray3 = (int[])this.lengths.clone();
            } else if (nArray2.length == n) {
                nArray3 = (int[])nArray2.clone();
            } else {
                throw new IllegalArgumentException("Rank Mismatch");
            }
            int n2 = MultiArrayImpl.numberOfElements(nArray3);
            object = MultiArrayImpl.fixDest(object, n2, this.meta.getComponentType());
            int n3 = this.iocount(nArray, nArray3);
            int[] nArray4 = (int[])nArray3.clone();
            int n4 = 0;
            while (n4 < nArray4.length) {
                int n5 = n4;
                nArray4[n5] = nArray4[n5] + nArray[n4];
                ++n4;
            }
            OffsetIndexIterator offsetIndexIterator = new OffsetIndexIterator(nArray, nArray4);
            int n6 = 0;
            while (offsetIndexIterator.notDone()) {
                long l = this.computeOffset(offsetIndexIterator.value());
                this.readArray(l, object, n6, n3);
                offsetIndexIterator.advance(n3);
                n6 += n3;
            }
            return object;
        }

        private final int[] compileDsizes(int[] nArray) {
            int[] nArray2 = new int[nArray.length];
            int n = 1;
            int n2 = nArray.length - 1;
            while (n2 >= 0) {
                if (n2 != 0 || !this.isUnlimited) {
                    n *= nArray[n2];
                }
                nArray2[n2] = n;
                --n2;
            }
            return nArray2;
        }

        public final void checkfill(int n) throws IOException {
            UnlimitedDimension unlimitedDimension = NetcdfFile.this.recDim;
            synchronized (unlimitedDimension) {
                int n2 = NetcdfFile.this.recDim.getLength();
                if (n > n2) {
                    if (NetcdfFile.this.doFill) {
                        while (n2 < n) {
                            NetcdfFile.this.fillRec(n2);
                            ++n2;
                        }
                    }
                    NetcdfFile.this.recDim.setLength(n);
                    NetcdfFile.this.raf.seek(4L);
                    NetcdfFile.this.raf.writeInt(NetcdfFile.this.recDim.getLength());
                }
            }
        }

        final int getRank() {
            return this.dsizes.length;
        }

        final boolean isScalar() {
            return 0 == this.getRank();
        }

        final long computeOffset(int[] nArray) {
            if (this.isScalar()) {
                return this.begin;
            }
            if (this.getRank() == 1) {
                if (this.isUnlimited) {
                    return this.begin + nArray[0] * NetcdfFile.this.recsize;
                }
                return this.begin + nArray[0] * this.xsz;
            }
            int n = this.dsizes.length - 1;
            int n2 = nArray[n];
            int n3 = 0;
            if (this.isUnlimited) {
                ++n3;
            }
            while (n3 < n) {
                n2 += this.dsizes[n3 + 1] * nArray[n3];
                ++n3;
            }
            n2 *= this.xsz;
            if (this.isUnlimited) {
                n2 += nArray[0] * NetcdfFile.this.recsize;
            }
            return n2 += this.begin;
        }

        abstract void fill(DataOutput var1, int var2, Attribute var3) throws IOException;

        private final void initFillValue(Attribute attribute) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(32);
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                this.fill(dataOutputStream, 32, attribute);
                dataOutputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fillbytes = byteArrayOutputStream.toByteArray();
        }

        private final void initFillValue(ProtoVariable protoVariable) {
            this.initFillValue(protoVariable.getAttribute(NetcdfFile._FillValue));
        }

        private final void initFillValue(Attribute[] attributeArray) {
            Attribute attribute = null;
            int n = 0;
            while (n < attributeArray.length) {
                if (attributeArray[n].getName() == NetcdfFile._FillValue) {
                    attribute = attributeArray[n];
                }
                ++n;
            }
            this.initFillValue(attribute);
        }

        void fillO(long l) throws IOException {
            NetcdfFile.this.raf.seek(l);
            int n = this.vsize;
            while (n >= this.fillbytes.length) {
                NetcdfFile.this.raf.write(this.fillbytes);
                n -= this.fillbytes.length;
            }
            if (n > 0) {
                int n2 = 0;
                while (n2 < n) {
                    NetcdfFile.this.raf.write(this.fillbytes[n2]);
                    ++n2;
                }
            }
        }

        void fill(int n) throws IOException {
            long l = this.begin;
            if (this.isUnlimited) {
                l += (long)n * (long)NetcdfFile.this.recsize;
            }
            this.fillO(l);
        }
    }
}

