/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import ucar.netcdf.Named;

class NamedDictionary
implements Serializable {
    private Vector vector;
    private transient Hashtable table;

    private void init(Named[] namedArray) {
        int n;
        if (namedArray == null) {
            this.vector = new Vector(0);
        } else {
            Named[] namedArray2 = namedArray;
            synchronized (namedArray2) {
                this.vector = new Vector(namedArray.length);
                n = 0;
                while (n < namedArray.length) {
                    this.vector.addElement(namedArray[n]);
                    ++n;
                }
            }
        }
        n = this.vector.size();
        if (n < 3) {
            n = 3;
        }
        n *= 4;
        this.table = new Hashtable(n /= 3, 0.75f);
        Enumeration enumeration = this.vector.elements();
        while (enumeration.hasMoreElements()) {
            Named named = (Named)enumeration.nextElement();
            this.table.put(named.getName(), named);
        }
    }

    NamedDictionary(Named[] namedArray) {
        this.init(namedArray);
    }

    NamedDictionary(int n, Enumeration enumeration) {
        this.vector = new Vector(n);
        this.table = new Hashtable((n < 3 ? 3 : n) * 4 / 3, 0.75f);
        while (enumeration.hasMoreElements()) {
            Named named = (Named)enumeration.nextElement();
            this.put(named);
        }
    }

    NamedDictionary(int n) {
        this.vector = new Vector(n);
        this.table = new Hashtable((n < 3 ? 3 : n) * 4 / 3, 0.75f);
    }

    int size() {
        return this.vector.size();
    }

    Enumeration elements() {
        return this.vector.elements();
    }

    Named get(String string) {
        return (Named)this.table.get(string);
    }

    synchronized Named put(Named named) {
        this.vector.addElement(named);
        return this.table.put(named.getName(), named);
    }

    synchronized Named remove(String string) {
        this.vector.removeElement(this.get(string));
        return (Named)this.table.remove(string);
    }

    int indexOf(Named named) {
        return this.vector.indexOf(named);
    }

    boolean contains(String string) {
        return this.table.containsKey(string);
    }

    boolean contains(Object object) {
        return this.table.contains(object);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.size();
        Named[] namedArray = new Named[n];
        int n2 = 0;
        Enumeration enumeration = this.vector.elements();
        while (enumeration.hasMoreElements()) {
            namedArray[n2++] = (Named)enumeration.nextElement();
        }
        objectOutputStream.writeObject(namedArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Named[] namedArray = (Named[])objectInputStream.readObject();
        this.init(namedArray);
    }
}

