/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.io.Serializable;
import java.util.Enumeration;
import ucar.netcdf.Dimension;
import ucar.netcdf.DimensionIterator;
import ucar.netcdf.DimensionSet;
import ucar.netcdf.Named;
import ucar.netcdf.NamedDictionary;
import ucar.netcdf.ProtoVariable;

class DimensionDictionary
implements DimensionSet,
Serializable {
    private final NamedDictionary dimensions;

    DimensionDictionary() {
        this.dimensions = new NamedDictionary(0);
    }

    DimensionDictionary(DimensionSet dimensionSet) {
        this.dimensions = new NamedDictionary(dimensionSet.size());
        DimensionIterator dimensionIterator = dimensionSet.iterator();
        while (dimensionIterator.hasNext()) {
            this.put(dimensionIterator.next());
        }
    }

    DimensionDictionary(ProtoVariable[] protoVariableArray) {
        this.dimensions = new NamedDictionary(0);
        int n = 0;
        while (n < protoVariableArray.length) {
            protoVariableArray[n].connectDims(this);
            ++n;
        }
    }

    public int size() {
        return this.dimensions.size();
    }

    public DimensionIterator iterator() {
        return new DimensionIterator(){
            final Enumeration ee;
            {
                this.ee = DimensionDictionary.this.dimensions.elements();
            }

            public boolean hasNext() {
                return this.ee.hasMoreElements();
            }

            public Dimension next() {
                return (Dimension)this.ee.nextElement();
            }
        };
    }

    public synchronized Dimension[] toArray() {
        Dimension[] dimensionArray = new Dimension[this.size()];
        DimensionIterator dimensionIterator = this.iterator();
        int n = 0;
        while (dimensionIterator.hasNext()) {
            Dimension dimension = dimensionIterator.next();
            dimensionArray[n] = (Dimension)dimension.clone();
            ++n;
        }
        return dimensionArray;
    }

    public Dimension get(String string) {
        return (Dimension)this.dimensions.get(string);
    }

    public boolean contains(String string) {
        return this.dimensions.contains(string);
    }

    public boolean contains(Object object) {
        return this.dimensions.contains(object);
    }

    public void toCdl(StringBuffer stringBuffer) {
        stringBuffer.append("dimensions:\n");
        DimensionIterator dimensionIterator = this.iterator();
        while (dimensionIterator.hasNext()) {
            stringBuffer.append("\t");
            dimensionIterator.next().toCdl(stringBuffer);
            stringBuffer.append("\n");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toCdl(stringBuffer);
        return stringBuffer.toString();
    }

    synchronized Dimension put(Dimension dimension) {
        String string = dimension.getName();
        Dimension dimension2 = this.get(string);
        if (dimension2 != null) {
            if (dimension2.equals(dimension)) {
                return dimension2;
            }
            throw new IllegalArgumentException("Duplicate dimension name");
        }
        Dimension dimension3 = (Dimension)dimension.clone();
        this.dimensions.put(dimension3);
        return dimension3;
    }

    void initialPut(Dimension dimension) {
        if (this.contains(dimension.getName())) {
            throw new IllegalArgumentException("Duplicate dimension name \"" + dimension.getName() + "\"");
        }
        this.dimensions.put(dimension);
    }

    boolean remove(String string) {
        Named named = this.dimensions.remove(string);
        return named != null;
    }

    int indexOf(Dimension dimension) {
        return this.dimensions.indexOf(dimension);
    }
}

