/*
 * Decompiled with CFR 0.152.
 */
package ucar.netcdf;

import java.io.Serializable;
import java.util.Enumeration;
import ucar.netcdf.Attribute;
import ucar.netcdf.AttributeIterator;
import ucar.netcdf.AttributeSet;
import ucar.netcdf.Named;
import ucar.netcdf.NamedDictionary;

class AttributeDictionary
implements AttributeSet,
Serializable {
    protected final NamedDictionary attributes;

    AttributeDictionary() {
        this.attributes = new NamedDictionary(0);
    }

    AttributeDictionary(Attribute[] attributeArray) {
        this.attributes = new NamedDictionary(attributeArray);
    }

    AttributeDictionary(final AttributeSet attributeSet) {
        this.attributes = new NamedDictionary(attributeSet.size(), new Enumeration(){
            final AttributeIterator ee;
            {
                this.ee = attributeSet.iterator();
            }

            public boolean hasMoreElements() {
                return this.ee.hasNext();
            }

            public Object nextElement() {
                return this.ee.next();
            }
        });
    }

    public int size() {
        return this.attributes.size();
    }

    public AttributeIterator iterator() {
        return new AttributeIterator(){
            final Enumeration ee;
            {
                this.ee = AttributeDictionary.this.attributes.elements();
            }

            public boolean hasNext() {
                return this.ee.hasMoreElements();
            }

            public Attribute next() {
                return (Attribute)this.ee.nextElement();
            }
        };
    }

    public Attribute[] toArray() {
        Attribute[] attributeArray = new Attribute[this.size()];
        AttributeIterator attributeIterator = this.iterator();
        int n = 0;
        while (attributeIterator.hasNext()) {
            attributeArray[n] = attributeIterator.next();
            ++n;
        }
        return attributeArray;
    }

    public Attribute get(String string) {
        return (Attribute)this.attributes.get(string);
    }

    public boolean contains(String string) {
        return this.attributes.contains(string);
    }

    public boolean contains(Object object) {
        return this.attributes.contains(object);
    }

    public Attribute put(Attribute attribute) {
        return (Attribute)this.attributes.put(attribute);
    }

    public boolean remove(String string) {
        Named named = this.attributes.remove(string);
        return named != null;
    }

    public boolean remove(Object object) {
        if (this.contains(object)) {
            return this.remove(((Named)object).getName());
        }
        return false;
    }

    public void toCdl(StringBuffer stringBuffer) {
        AttributeIterator attributeIterator = this.iterator();
        while (attributeIterator.hasNext()) {
            stringBuffer.append("\t\t");
            attributeIterator.next().toCdl(stringBuffer);
            stringBuffer.append("\n");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toCdl(stringBuffer);
        return stringBuffer.toString();
    }
}

