/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

import java.io.IOException;
import java.lang.reflect.Array;
import ucar.multiarray.ConcreteIndexMap;
import ucar.multiarray.MultiArrayImpl;
import ucar.multiarray.MultiArrayProxy;

public class TransposeMap
extends ConcreteIndexMap {
    private int aa_;
    private int bb_;

    public TransposeMap(int n, int n2) {
        this.init(new IMap(), new LengthsMap());
        this.aa_ = n;
        this.bb_ = n2;
    }

    public TransposeMap(ConcreteIndexMap concreteIndexMap, int n, int n2) {
        this.link(concreteIndexMap, new IMap(), new LengthsMap());
        this.aa_ = n;
        this.bb_ = n2;
    }

    public static void main(String[] stringArray) {
        int[] nArray = new int[]{32, 48, 64};
        MultiArrayImpl multiArrayImpl = new MultiArrayImpl(Integer.TYPE, nArray);
        int n = MultiArrayImpl.numberOfElements(nArray);
        int n2 = 0;
        while (n2 < n) {
            Array.setInt(multiArrayImpl.storage, n2, n2);
            ++n2;
        }
        TransposeMap transposeMap = new TransposeMap(0, 2);
        MultiArrayProxy multiArrayProxy = new MultiArrayProxy(multiArrayImpl, transposeMap);
        try {
            System.out.println("Rank  " + multiArrayProxy.getRank());
            int[] nArray2 = multiArrayProxy.getLengths();
            System.out.println("Shape { " + nArray2[0] + ", " + nArray2[1] + ", " + nArray2[2] + " }");
            System.out.println(multiArrayProxy.getInt(new int[]{0, 0, 1}));
            System.out.println(multiArrayProxy.getInt(new int[]{0, 1, 0}));
            System.out.println(multiArrayProxy.getInt(new int[]{1, 0, 0}));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class LengthsMap
    extends ConcreteIndexMap.ZZMap {
        private LengthsMap() {
        }

        public int get(int n) {
            if (n == TransposeMap.this.aa_) {
                return super.get(TransposeMap.this.bb_);
            }
            if (n == TransposeMap.this.bb_) {
                return super.get(TransposeMap.this.aa_);
            }
            return super.get(n);
        }
    }

    private class IMap
    extends ConcreteIndexMap.ZZMap {
        private IMap() {
        }

        public synchronized int get(int n) {
            if (n == TransposeMap.this.aa_) {
                return super.get(TransposeMap.this.bb_);
            }
            if (n == TransposeMap.this.bb_) {
                return super.get(TransposeMap.this.aa_);
            }
            return super.get(n);
        }
    }
}

