/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

import java.io.IOException;
import java.lang.reflect.Array;
import ucar.multiarray.ConcreteIndexMap;
import ucar.multiarray.MultiArrayImpl;
import ucar.multiarray.MultiArrayProxy;

public class SliceMap
extends ConcreteIndexMap {
    private int position_;
    private int value_;

    public SliceMap(int n, int n2) {
        this.init(new IMap(), new LengthsMap());
        this.position_ = n;
        this.value_ = n2;
    }

    public SliceMap(ConcreteIndexMap concreteIndexMap, int n, int n2) {
        this.link(concreteIndexMap, new IMap(), new LengthsMap());
        this.position_ = n;
        this.value_ = n2;
    }

    public static void main(String[] stringArray) {
        int[] nArray = new int[]{48, 64};
        MultiArrayImpl multiArrayImpl = new MultiArrayImpl(Integer.TYPE, nArray);
        int n = MultiArrayImpl.numberOfElements(nArray);
        int n2 = 0;
        while (n2 < n) {
            Array.setInt(multiArrayImpl.storage, n2, n2);
            ++n2;
        }
        SliceMap sliceMap = new SliceMap(1, 1);
        MultiArrayProxy multiArrayProxy = new MultiArrayProxy(multiArrayImpl, sliceMap);
        try {
            System.out.println("Rank  " + multiArrayProxy.getRank());
            int[] nArray2 = multiArrayProxy.getLengths();
            System.out.println("Shape { " + nArray2[0] + " }");
            System.out.println(multiArrayProxy.getInt(new int[]{1}));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class LengthsMap
    extends ConcreteIndexMap.ZZMap {
        private LengthsMap() {
        }

        public synchronized int get(int n) {
            int n2 = n < SliceMap.this.position_ ? n : n + 1;
            return super.get(n2);
        }

        public synchronized int size() {
            return super.size() - 1;
        }
    }

    private class IMap
    extends ConcreteIndexMap.ZZMap {
        private IMap() {
        }

        public synchronized int get(int n) {
            if (n < SliceMap.this.position_) {
                return super.get(n);
            }
            if (n == SliceMap.this.position_) {
                return SliceMap.this.value_;
            }
            return super.get(n - 1);
        }

        public synchronized int size() {
            return super.size() + 1;
        }
    }
}

