/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import ucar.multiarray.MultiArray;
import ucar.multiarray.MultiArrayImpl;

public class ScalarMultiArray
implements MultiArray {
    private final Class componentType;
    private Object obj;

    public ScalarMultiArray(Class clazz) {
        this.componentType = clazz;
    }

    public ScalarMultiArray(Class clazz, Object object) {
        this.componentType = clazz;
        this.set(null, object);
    }

    public ScalarMultiArray(Object object) {
        this.componentType = object.getClass();
        this.obj = object;
    }

    public Class getComponentType() {
        return this.componentType;
    }

    public int getRank() {
        return 0;
    }

    public int[] getLengths() {
        int[] nArray = new int[]{};
        return nArray;
    }

    public boolean isUnlimited() {
        return false;
    }

    public boolean isScalar() {
        return true;
    }

    public Object get(int[] nArray) {
        return this.obj;
    }

    public char getChar(int[] nArray) {
        return ((Character)this.obj).charValue();
    }

    public boolean getBoolean(int[] nArray) {
        return (Boolean)this.obj;
    }

    public byte getByte(int[] nArray) {
        return ((Number)this.obj).byteValue();
    }

    public short getShort(int[] nArray) {
        return ((Number)this.obj).shortValue();
    }

    public int getInt(int[] nArray) {
        return ((Number)this.obj).intValue();
    }

    public long getLong(int[] nArray) {
        return ((Number)this.obj).longValue();
    }

    public float getFloat(int[] nArray) {
        return ((Number)this.obj).floatValue();
    }

    public double getDouble(int[] nArray) {
        return ((Number)this.obj).doubleValue();
    }

    public void set(int[] nArray, Object object) {
        Class<?> clazz = object.getClass();
        if (this.componentType.isPrimitive()) {
            Method method;
            try {
                if (this.componentType == (Class)clazz.getDeclaredField("TYPE").get(object)) {
                    this.obj = object;
                    return;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            try {
                method = clazz.getMethod(this.componentType.getName() + "Value", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalArgumentException();
            }
            try {
                this.obj = method.invoke(object, new Object[0]);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Error();
            }
            catch (InvocationTargetException invocationTargetException) {
                throw (RuntimeException)invocationTargetException.getTargetException();
            }
        }
        if (!this.componentType.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException();
        }
        this.obj = object;
    }

    public void setBoolean(int[] nArray, boolean bl) {
        this.set(nArray, new Boolean(bl));
    }

    public void setChar(int[] nArray, char c) {
        this.set(nArray, new Character(c));
    }

    public void setByte(int[] nArray, byte by) {
        this.set(nArray, new Byte(by));
    }

    public void setShort(int[] nArray, short s) {
        this.set(nArray, new Short(s));
    }

    public void setInt(int[] nArray, int n) {
        this.set(nArray, new Integer(n));
    }

    public void setLong(int[] nArray, long l) {
        this.set(nArray, new Long(l));
    }

    public void setFloat(int[] nArray, float f) {
        this.set(nArray, new Float(f));
    }

    public void setDouble(int[] nArray, double d) {
        this.set(nArray, new Double(d));
    }

    public MultiArray copyout(int[] nArray, int[] nArray2) {
        if (nArray != null && nArray.length != 0 || nArray2 != null && nArray2.length != 0) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        try {
            return new MultiArrayImpl(this);
        }
        catch (IOException iOException) {
            throw new Error();
        }
    }

    public void copyin(int[] nArray, MultiArray multiArray) throws IOException {
        if (nArray != null && nArray.length != 0 || multiArray.getRank() != 0) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        int[] nArray2 = new int[]{};
        this.set(nArray2, multiArray.get(nArray2));
    }

    public Object toArray() {
        return this.obj;
    }

    public Object toArray(Object object, int[] nArray, int[] nArray2) {
        if (object.getClass().isAssignableFrom(this.componentType)) {
            return this.obj;
        }
        throw new IllegalArgumentException();
    }
}

