/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

import java.io.IOException;
import java.lang.reflect.Array;
import ucar.multiarray.AbstractAccessor;
import ucar.multiarray.ClipMap;
import ucar.multiarray.IndexMap;
import ucar.multiarray.MultiArray;
import ucar.multiarray.MultiArrayImpl;

public class MultiArrayProxy
implements MultiArray {
    private final MultiArray delegate_;
    private final IndexMap im_;
    private final int[] dlengths_;

    public MultiArrayProxy(MultiArray multiArray, IndexMap indexMap) {
        this.delegate_ = multiArray;
        this.im_ = indexMap;
        this.dlengths_ = this.delegate_.getLengths();
        this.im_.setLengths(this.dlengths_);
    }

    public Class getComponentType() {
        return this.delegate_.getComponentType();
    }

    public int getRank() {
        return this.im_.getRank();
    }

    public int[] getLengths() {
        if (this.isUnlimited()) {
            System.arraycopy(this.delegate_.getLengths(), 0, this.dlengths_, 0, this.dlengths_.length);
        }
        int[] nArray = new int[this.getRank()];
        return this.im_.getLengths(nArray);
    }

    public boolean isUnlimited() {
        return this.delegate_.isUnlimited();
    }

    public boolean isScalar() {
        return 0 == this.getRank();
    }

    public Object get(int[] nArray) throws IOException {
        return this.delegate_.get(this.map(nArray));
    }

    public boolean getBoolean(int[] nArray) throws IOException {
        return this.delegate_.getBoolean(this.map(nArray));
    }

    public char getChar(int[] nArray) throws IOException {
        return this.delegate_.getChar(this.map(nArray));
    }

    public byte getByte(int[] nArray) throws IOException {
        return this.delegate_.getByte(this.map(nArray));
    }

    public short getShort(int[] nArray) throws IOException {
        return this.delegate_.getShort(this.map(nArray));
    }

    public int getInt(int[] nArray) throws IOException {
        return this.delegate_.getInt(this.map(nArray));
    }

    public long getLong(int[] nArray) throws IOException {
        return this.delegate_.getLong(this.map(nArray));
    }

    public float getFloat(int[] nArray) throws IOException {
        return this.delegate_.getFloat(this.map(nArray));
    }

    public double getDouble(int[] nArray) throws IOException {
        return this.delegate_.getDouble(this.map(nArray));
    }

    public void set(int[] nArray, Object object) throws IOException {
        this.delegate_.set(this.map(nArray), object);
    }

    public void setBoolean(int[] nArray, boolean bl) throws IOException {
        this.delegate_.setBoolean(this.map(nArray), bl);
    }

    public void setChar(int[] nArray, char c) throws IOException {
        this.delegate_.setChar(this.map(nArray), c);
    }

    public void setByte(int[] nArray, byte by) throws IOException {
        this.delegate_.setByte(this.map(nArray), by);
    }

    public void setShort(int[] nArray, short s) throws IOException {
        this.delegate_.setShort(this.map(nArray), s);
    }

    public void setInt(int[] nArray, int n) throws IOException {
        this.delegate_.setInt(this.map(nArray), n);
    }

    public void setLong(int[] nArray, long l) throws IOException {
        this.delegate_.setLong(this.map(nArray), l);
    }

    public void setFloat(int[] nArray, float f) throws IOException {
        this.delegate_.setFloat(this.map(nArray), f);
    }

    public void setDouble(int[] nArray, double d) throws IOException {
        this.delegate_.setDouble(this.map(nArray), d);
    }

    public MultiArray copyout(int[] nArray, int[] nArray2) throws IOException {
        int n = this.getRank();
        if (nArray.length != n || nArray2.length != n) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        MultiArrayImpl multiArrayImpl = new MultiArrayImpl(this.getComponentType(), nArray2);
        AbstractAccessor.copyO(this, nArray, multiArrayImpl, nArray2);
        return multiArrayImpl;
    }

    public void copyin(int[] nArray, MultiArray multiArray) throws IOException {
        int n = this.getRank();
        if (nArray.length != n || multiArray.getRank() != n) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        if (multiArray.getComponentType() != this.getComponentType()) {
            throw new ArrayStoreException();
        }
        AbstractAccessor.copy(multiArray, multiArray.getLengths(), this, nArray);
    }

    public Object toArray() throws IOException {
        return this.toArray(null, null, null);
    }

    public Object toArray(Object object, int[] nArray, int[] nArray2) throws IOException {
        int n = this.getRank();
        if (nArray == null) {
            nArray = new int[n];
        } else if (nArray.length != n) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        int[] nArray3 = null;
        if (nArray2 == null) {
            nArray3 = this.getLengths();
        } else if (nArray2.length == n) {
            nArray3 = (int[])nArray2.clone();
        } else {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        int[] nArray4 = new int[n];
        int n2 = MultiArrayImpl.numberOfElements(nArray3, nArray4);
        object = MultiArrayImpl.fixDest(object, n2, this.getComponentType());
        MultiArrayImpl multiArrayImpl = new MultiArrayImpl(nArray3, nArray4, object);
        AbstractAccessor.copyO(this, nArray, multiArrayImpl, nArray3);
        return object;
    }

    private synchronized int[] map(int[] nArray) {
        this.im_.setInput(nArray);
        return this.im_.getTransformed(new int[this.im_.getOutputLength()]);
    }

    public static void main(String[] stringArray) {
        Object object;
        System.out.println(">>  " + System.currentTimeMillis());
        int[] nArray = new int[]{48, 64};
        MultiArrayImpl multiArrayImpl = new MultiArrayImpl(Integer.TYPE, nArray);
        int n = MultiArrayImpl.numberOfElements(nArray);
        int n2 = 0;
        while (n2 < n) {
            Array.setInt(multiArrayImpl.storage, n2, n2);
            ++n2;
        }
        ClipMap clipMap = new ClipMap(0, 4, 40);
        MultiArrayProxy multiArrayProxy = new MultiArrayProxy(multiArrayImpl, clipMap);
        int[] nArray2 = new int[]{32, 64};
        int[] nArray3 = new int[]{4, 0};
        MultiArray multiArray = null;
        try {
            multiArray = multiArrayProxy.copyout(nArray3, nArray2);
            System.out.println("Rank  " + multiArray.getRank());
            object = multiArray.getLengths();
            System.out.println("Shape { " + (int)object[0] + ", " + (int)object[1] + " }");
            System.out.println(multiArray.getInt(new int[]{0, 0}));
            System.out.println(multiArray.getInt(new int[]{1, 0}));
            System.out.println(multiArray.getInt(new int[]{(int)(object[0] - true), (int)(object[1] - true)}));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = new MultiArrayImpl(Integer.TYPE, nArray);
        clipMap = new ClipMap(0, 8, 36);
        MultiArrayProxy multiArrayProxy2 = new MultiArrayProxy((MultiArray)object, clipMap);
        try {
            nArray3 = new int[]{0, 0};
            multiArrayProxy2.copyin(nArray3, multiArray);
            System.out.println("***Rank  " + multiArrayProxy2.getRank());
            int[] nArray4 = multiArrayProxy2.getLengths();
            System.out.println("Shape { " + nArray4[0] + ", " + nArray4[1] + " }");
            System.out.println(((MultiArrayImpl)object).getInt(new int[]{0, 0}));
            System.out.println(((MultiArrayImpl)object).getInt(new int[]{7, 63}));
            System.out.println(((MultiArrayImpl)object).getInt(new int[]{8, 0}));
            System.out.println(((MultiArrayImpl)object).getInt(new int[]{8, 63}));
            System.out.println(((MultiArrayImpl)object).getInt(new int[]{9, 0}));
            System.out.println(((MultiArrayImpl)object).getInt(new int[]{39, 0}));
            System.out.println(((MultiArrayImpl)object).getInt(new int[]{40, 0}));
            System.out.println(((MultiArrayImpl)object).getInt(new int[]{47, 63}));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

