/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

import java.io.IOException;
import java.lang.reflect.Array;
import ucar.multiarray.ConcreteIndexMap;
import ucar.multiarray.MultiArrayImpl;
import ucar.multiarray.MultiArrayProxy;

public class FlattenMap
extends ConcreteIndexMap {
    private int position_;

    public FlattenMap(int n) {
        this.init(new IMap(), new LengthsMap());
        this.position_ = n;
    }

    public FlattenMap(ConcreteIndexMap concreteIndexMap, int n) {
        this.link(concreteIndexMap, new IMap(), new LengthsMap());
        this.position_ = n;
    }

    public static void main(String[] stringArray) {
        int[] nArray = new int[]{32, 48, 64};
        MultiArrayImpl multiArrayImpl = new MultiArrayImpl(Integer.TYPE, nArray);
        int n = MultiArrayImpl.numberOfElements(nArray);
        int n2 = 0;
        while (n2 < n) {
            Array.setInt(multiArrayImpl.storage, n2, n2);
            ++n2;
        }
        FlattenMap flattenMap = new FlattenMap(1);
        MultiArrayProxy multiArrayProxy = new MultiArrayProxy(multiArrayImpl, flattenMap);
        try {
            System.out.println("Rank  " + multiArrayProxy.getRank());
            int[] nArray2 = multiArrayProxy.getLengths();
            System.out.println("Shape { " + nArray2[0] + ", " + nArray2[1] + " }");
            System.out.println(multiArrayProxy.getInt(new int[]{0, 0}));
            System.out.println(multiArrayProxy.getInt(new int[]{0, 1}));
            System.out.println(multiArrayProxy.getInt(new int[]{0, 63}));
            System.out.println(multiArrayProxy.getInt(new int[]{0, 64}));
            System.out.println(multiArrayProxy.getInt(new int[]{0, 3071}));
            System.out.println(multiArrayProxy.getInt(new int[]{1, 0}));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class LengthsMap
    extends ConcreteIndexMap.ZZMap {
        private LengthsMap() {
        }

        public synchronized int get(int n) {
            if (n < FlattenMap.this.position_) {
                return super.get(n);
            }
            if (n == FlattenMap.this.position_) {
                return super.get(n) * super.get(n + 1);
            }
            return super.get(n + 1);
        }

        public synchronized int size() {
            return super.size() - 1;
        }

        int superGet(int n) {
            return super.get(n);
        }
    }

    private class IMap
    extends ConcreteIndexMap.ZZMap {
        private int length_;
        private int value_;

        private IMap() {
        }

        public synchronized int get(int n) {
            if (n < FlattenMap.this.position_) {
                return super.get(n);
            }
            if (n == FlattenMap.this.position_) {
                this.length_ = ((LengthsMap)FlattenMap.this.lengthsMap_).superGet(n + 1);
                int n2 = super.get(n);
                this.value_ = n2 % this.length_;
                return n2 / this.length_;
            }
            if (n == FlattenMap.this.position_ + 1) {
                return this.value_;
            }
            return super.get(n - 1);
        }

        public synchronized int size() {
            return super.size() + 1;
        }
    }
}

