/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvoker;

public abstract class WebServerInvoker
extends ServerInvoker {
    public static String BINARY = "application/octet-stream";
    public static String HEADER_SESSION_ID = "sessionId";
    public static String HEADER_SUBSYSTEM = "subsystem";

    public WebServerInvoker(InvokerLocator locator) {
        super(locator);
    }

    public WebServerInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    public boolean isTransportBiDirectional() {
        return false;
    }

    protected boolean isBinary(String requestContentType) {
        return BINARY.equalsIgnoreCase(requestContentType);
    }

    protected InvocationRequest getInvocationRequest(Map metadata, Object obj) {
        InvocationRequest request = null;
        if (obj instanceof InvocationRequest) {
            request = (InvocationRequest)obj;
            if (request.getRequestPayload() == null) {
                request.setRequestPayload(metadata);
            } else {
                request.getRequestPayload().putAll(metadata);
            }
        } else {
            request = this.createNewInvocationRequest(metadata, obj);
        }
        return request;
    }

    protected InvocationRequest createNewInvocationRequest(Map metadata, Object payload) {
        String sessionId = this.getSessionId(metadata);
        String subSystem = (String)metadata.get(HEADER_SUBSYSTEM);
        InvocationRequest request = new InvocationRequest(sessionId, subSystem, payload, metadata, null, null);
        return request;
    }

    protected String getSessionId(Map metadata) {
        String sessionId = (String)metadata.get(HEADER_SESSION_ID);
        if (sessionId == null || sessionId.length() == 0) {
            String userAgent = (String)metadata.get("User-Agent");
            String host = (String)metadata.get("Host");
            String idSeed = userAgent + ":" + host;
            sessionId = Integer.toString(idSeed.hashCode());
        }
        return sessionId;
    }

    protected int getContentLength(Object response) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(response);
        oos.flush();
        bos.flush();
        byte[] buffer = bos.toByteArray();
        return buffer.length;
    }
}

