/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class SocketId
implements Serializable {
    protected static final Logger log = Logger.getLogger(class$org$jboss$remoting$transport$multiplex$SocketId == null ? (class$org$jboss$remoting$transport$multiplex$SocketId = SocketId.class$("org.jboss.remoting.transport.multiplex.SocketId")) : class$org$jboss$remoting$transport$multiplex$SocketId);
    private static final String ISO_8859_1 = "ISO-8859-1";
    public static final int PROTOCOL_PORT = -1;
    public static final int SERVER_SOCKET_PORT = -2;
    public static final int BACKCHANNEL_PORT = -3;
    public static final int DEADLETTER_PORT = -4;
    public static final int INITIAL_OUTPUT_PORT = -5;
    private static final int MIN_PORT = -5;
    public static final SocketId PROTOCOL_SOCKET_ID = new SocketId(-1);
    public static final SocketId SERVER_SOCKET_ID = new SocketId(-2);
    public static final SocketId BACKCHANNEL_SOCKET_ID = new SocketId(-3);
    public static final SocketId DEADLETTER_SOCKET_ID = new SocketId(-4);
    public static final SocketId INITIAL_OUTPUT_SOCKET_ID = new SocketId(-5);
    private static HashSet portsInUse = new HashSet();
    private static HashSet portsFreed = new HashSet();
    private static int nextNewPort = 1;
    private int port;
    byte[] bytes;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$SocketId;

    public SocketId() throws IOException {
        this.port = this.getFreePort();
        this.setBytes(this.port);
    }

    public SocketId(int port) throws IOException {
        this.checkPortValue(port);
        this.port = port;
        this.setBytes(port);
    }

    public SocketId(byte[] bytes) throws IOException {
        this.bytes = bytes;
        this.setPort(bytes);
        this.checkPortValue(this.port);
    }

    protected SocketId(short port) {
        this.port = port;
        this.setBytes(port);
    }

    public byte[] toByteArray() {
        return this.bytes;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SocketId)) {
            return false;
        }
        SocketId other = (SocketId)o;
        return this.port == other.port;
    }

    public int hashCode() {
        return this.port;
    }

    protected void checkPortValue(int port) throws IOException {
        if (port < -5) {
            log.error("attempt to create port with illegal value: " + port);
            throw new IOException("attempt to create port with illegal value: " + port);
        }
    }

    protected void setPort(byte[] bytes) {
        try {
            this.port = Integer.parseInt(new String(bytes, ISO_8859_1));
        }
        catch (UnsupportedEncodingException e) {
            log.fatal("org.jboss.remoting.transport.multiplex.OutputMultiplexor(): charset ISO-8859-1 not found", e);
            e.printStackTrace();
            throw new RuntimeException("org.jboss.remoting.transport.multiplex.OutputMultiplexor(): charset ISO-8859-1 not found", e);
        }
    }

    protected void setBytes(int port) {
        try {
            this.bytes = Integer.toString(port).getBytes(ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            log.fatal("org.jboss.remoting.transport.multiplex.OutputMultiplexor(): charset ISO-8859-1 not found", e);
            e.printStackTrace();
            throw new RuntimeException("org.jboss.remoting.transport.multiplex.OutputMultiplexor(): charset ISO-8859-1 not found", e);
        }
    }

    protected synchronized int getFreePort() {
        if (!portsFreed.isEmpty()) {
            Iterator it = portsFreed.iterator();
            Integer portInteger = (Integer)it.next();
            portsFreed.remove(portInteger);
            portsInUse.add(portInteger);
            return portInteger;
        }
        int port = nextNewPort++;
        portsInUse.add(new Integer(port));
        return port;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

