/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.metadata;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jboss.mx.metadata.AbstractBuilder;
import org.jboss.mx.metadata.IllegalPropertyException;
import org.jboss.mx.metadata.JBossXMBean10;
import org.jboss.mx.metadata.XMBeanEntityResolver;
import org.jboss.mx.modelmbean.XMBeanConstants;
import org.jboss.mx.service.ServiceConstants;
import org.jboss.mx.util.JBossNotCompliantMBeanException;
import org.xml.sax.SAXException;

public class XMLMetaData
extends AbstractBuilder
implements ServiceConstants,
XMBeanConstants {
    private static final int NO_VERSION = -1;
    private static final int JBOSS_XMBEAN_1_0 = 0;
    private static final int JBOSS_XMBEAN_1_1 = 1;
    private static final int JBOSS_XMBEAN_1_2 = 2;
    private URL url = null;
    private Element element;
    private String versionString;
    private String resourceClassName = null;
    private String mmbClassName = null;

    public XMLMetaData(String mmbClassName, String resourceClassName, URL url) {
        this.url = url;
        this.mmbClassName = mmbClassName;
        this.resourceClassName = resourceClassName;
    }

    public XMLMetaData(String mmbClassName, String resourceClassName, String url) throws MalformedURLException {
        this(mmbClassName, resourceClassName, new URL(url));
    }

    public XMLMetaData(String mmbClassName, String resourceClassName, URL url, Map properties) {
        this(mmbClassName, resourceClassName, url);
        this.setProperties(properties);
    }

    public XMLMetaData(String mmbClassName, String resourceClassName, String url, Map properties) throws MalformedURLException {
        this(mmbClassName, resourceClassName, new URL(url), properties);
    }

    public XMLMetaData(String mmbClassName, String resourceClassName, Element element, String version) {
        this.mmbClassName = mmbClassName;
        this.resourceClassName = resourceClassName;
        this.element = element;
        this.versionString = version;
    }

    public MBeanInfo build() throws NotCompliantMBeanException {
        try {
            int version = -1;
            if (this.versionString == null) {
                SAXReader reader = new SAXReader();
                if (this.properties.get("xmbean.metadata.sax.parser") != null) {
                    try {
                        reader.setXMLReaderClassName(this.getStringProperty("xmbean.metadata.sax.parser"));
                    }
                    catch (SAXException e) {
                        // empty catch block
                    }
                }
                reader.setValidation(true);
                try {
                    boolean validate = this.getBooleanProperty("xmbean.metadata.xml.validate");
                    reader.setValidation(validate);
                }
                catch (IllegalPropertyException e) {
                    // empty catch block
                }
                reader.setEntityResolver(new XMBeanEntityResolver());
                Document doc = reader.read(this.url);
                this.element = doc.getRootElement();
                DocumentType type = doc.getDocType();
                version = this.validateVersionString(type.getPublicID());
                if (version == -1) {
                    version = this.validateVersionString(type.getSystemID());
                }
            } else {
                version = this.validateVersionString(this.versionString);
            }
            if (this.element == null) {
                throw new IllegalStateException("No element supplied with explict version!");
            }
            if (version == 0 || version == 1 || version == 2) {
                return new JBossXMBean10(this.mmbClassName, this.resourceClassName, this.element, this.properties).build();
            }
            throw new NotCompliantMBeanException("Unknown xmbean type " + this.versionString);
        }
        catch (DocumentException e) {
            throw new JBossNotCompliantMBeanException("Error parsing the XML file, from XMLMetaData: ", e);
        }
    }

    private int validateVersionString(String versionString) {
        if ("-//JBoss//DTD JBOSS XMBEAN 1.0//EN".equals(versionString)) {
            return 0;
        }
        if (versionString != null && versionString.endsWith("jboss_xmbean_1_0.dtd")) {
            return 0;
        }
        if ("-//JBoss//DTD JBOSS XMBEAN 1.1//EN".equals(versionString)) {
            return 1;
        }
        if (versionString != null && versionString.endsWith("jboss_xmbean_1_1.dtd")) {
            return 1;
        }
        if ("-//JBoss//DTD JBOSS XMBEAN 1.2//EN".equals(versionString)) {
            return 2;
        }
        if (versionString != null && versionString.endsWith("jboss_xmbean_1_2.dtd")) {
            return 2;
        }
        return -1;
    }
}

