/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.spi;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.jboss.logging.Logger;

public class DeploymentMetaData {
    private static Logger log = Logger.getLogger(DeploymentMetaData.class);
    public static final String ENTRY_NAME = "deployment-plan.xml";
    private String deploymentName;
    private List entryList = new ArrayList();

    public DeploymentMetaData(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public DeploymentMetaData(Document document) {
        this.init(document);
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public String addEntry(String archiveName, String descriptorName) {
        this.entryList.add(new Entry(archiveName, descriptorName));
        String entryId = "entry_";
        int count = this.entryList.size();
        if (count < 100) {
            entryId = entryId + "0";
        }
        if (count < 10) {
            entryId = entryId + "0";
        }
        return entryId + count;
    }

    public boolean hasEntry(String archiveName, String descriptorName) {
        return this.entryList.contains(new Entry(archiveName, descriptorName));
    }

    public List getEntryList() {
        return new ArrayList(this.entryList);
    }

    public Document getDocument() {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("jboss-deployment-plan");
        root.addElement("deployment-name").addText(this.deploymentName);
        root.addComment("Note, deployment-entry elements are not used by the DeploymentManager");
        root.addComment("The DeploymentManager relies on the the entry nameing convention");
        Iterator it = this.entryList.iterator();
        while (it.hasNext()) {
            Entry entry = (Entry)it.next();
            Element element = root.addElement("deployment-entry");
            element.addElement("archive-name").addText(entry.archiveName);
            element.addElement("descriptor-name").addText(entry.descriptorName);
        }
        return document;
    }

    public String toXMLString() {
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            StringWriter strWriter = new StringWriter(1024);
            XMLWriter metaWriter = new XMLWriter(strWriter, format);
            metaWriter.write(this.getDocument());
            metaWriter.close();
            return strWriter.toString();
        }
        catch (IOException e) {
            log.error("Cannot get XML string", e);
            return null;
        }
    }

    private void init(Document document) {
        Element root = document.getRootElement();
        this.deploymentName = root.elementTextTrim("deployment-name");
        Iterator it = root.elementIterator("deployment-entry");
        while (it.hasNext()) {
            Element element = (Element)it.next();
            String archiveName = element.elementTextTrim("archive-name");
            String descriptorName = element.elementTextTrim("descriptor-name");
            this.addEntry(archiveName, descriptorName);
        }
    }

    public static class Entry {
        private String archiveName;
        private String descriptorName;

        public Entry(String archiveName, String descriptorName) {
            this.archiveName = archiveName;
            this.descriptorName = descriptorName != null ? descriptorName : "";
        }

        public String getArchiveName() {
            return this.archiveName;
        }

        public String getDescriptorName() {
            return this.descriptorName;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Entry) {
                Entry other = (Entry)obj;
                return this.archiveName.equals(other.archiveName) && this.descriptorName.equals(other.descriptorName);
            }
            return false;
        }

        public int hashCode() {
            return new String(this.archiveName + this.descriptorName).hashCode();
        }
    }
}

