/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.DOMReader;
import org.dom4j.io.SAXReader;
import org.hibernate.util.DTDEntityResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public final class XMLHelper {
    private static final Log log = LogFactory.getLog(XMLHelper.class);
    public static final EntityResolver DEFAULT_DTD_RESOLVER = new DTDEntityResolver();
    private DOMReader domReader;
    private SAXReader saxReader;

    public SAXReader createSAXReader(String file, List errorsList, EntityResolver entityResolver) {
        if (this.saxReader == null) {
            this.saxReader = new SAXReader();
        }
        this.saxReader.setEntityResolver(entityResolver);
        this.saxReader.setErrorHandler(new ErrorLogger(file, errorsList));
        this.saxReader.setMergeAdjacentText(true);
        this.saxReader.setValidation(true);
        return this.saxReader;
    }

    public DOMReader createDOMReader() {
        if (this.domReader == null) {
            this.domReader = new DOMReader();
        }
        return this.domReader;
    }

    public static Element generateDom4jElement(String elementName) {
        return DocumentFactory.getInstance().createElement(elementName);
    }

    public static class ErrorLogger
    implements ErrorHandler {
        private String file;
        private List errors;

        ErrorLogger(String file, List errors) {
            this.file = file;
            this.errors = errors;
        }

        public void error(SAXParseException error) {
            log.error("Error parsing XML: " + this.file + '(' + error.getLineNumber() + ") " + error.getMessage());
            this.errors.add(error);
        }

        public void fatalError(SAXParseException error) {
            this.error(error);
        }

        public void warning(SAXParseException warn) {
            log.warn("Warning parsing XML: " + this.file + '(' + warn.getLineNumber() + ") " + warn.getMessage());
        }
    }
}

