/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DTDEntityResolver
implements EntityResolver,
Serializable {
    private static final Log log = LogFactory.getLog(DTDEntityResolver.class);
    private static final String URL = "http://hibernate.sourceforge.net/";
    private transient ClassLoader resourceLoader;

    public DTDEntityResolver() {
        this.resourceLoader = this.getClass().getClassLoader();
    }

    public DTDEntityResolver(ClassLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        if (systemId != null && systemId.startsWith(URL)) {
            InputStream dtdStream;
            log.debug("trying to locate " + systemId + " in classpath under org/hibernate/");
            String path = "org/hibernate/" + systemId.substring(URL.length());
            InputStream inputStream = dtdStream = this.resourceLoader == null ? this.getClass().getResourceAsStream(path) : this.resourceLoader.getResourceAsStream(path);
            if (dtdStream == null) {
                log.debug(systemId + " not found in classpath");
                if (systemId.substring(URL.length()).indexOf("2.0") > -1) {
                    log.error("Don't use old DTDs, read the Hibernate 3.x Migration Guide!");
                }
                return null;
            }
            log.debug("found " + systemId + " in classpath");
            InputSource source = new InputSource(dtdStream);
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            return source;
        }
        return null;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.resourceLoader = this.getClass().getClassLoader();
    }
}

