/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.transaction.JTATransaction;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.transaction.TransactionManagerLookup;
import org.hibernate.transaction.TransactionManagerLookupFactory;
import org.hibernate.util.NamingHelper;

public class JTATransactionFactory
implements TransactionFactory {
    private static final Log log = LogFactory.getLog(JTATransactionFactory.class);
    private static final String DEFAULT_USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    private InitialContext context;
    private String utName;

    public void configure(Properties props) throws HibernateException {
        TransactionManagerLookup lookup;
        try {
            this.context = NamingHelper.getInitialContext(props);
        }
        catch (NamingException ne) {
            log.error("Could not obtain initial context", ne);
            throw new HibernateException("Could not obtain initial context", ne);
        }
        this.utName = props.getProperty("jta.UserTransaction");
        if (this.utName == null && (lookup = TransactionManagerLookupFactory.getTransactionManagerLookup(props)) != null) {
            this.utName = lookup.getUserTransactionName();
        }
        if (this.utName == null) {
            this.utName = DEFAULT_USER_TRANSACTION_NAME;
        }
    }

    public Transaction createTransaction(JDBCContext jdbcContext, TransactionFactory.Context transactionContext) throws HibernateException {
        return new JTATransaction(this.context, this.utName, jdbcContext, transactionContext);
    }

    public ConnectionReleaseMode getDefaultReleaseMode() {
        return ConnectionReleaseMode.AFTER_STATEMENT;
    }

    public boolean isTransactionManagerRequired() {
        return false;
    }
}

