/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.transaction.TransactionManager;
import net.sf.cglib.core.KeyFactory;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheFactory;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.QueryCache;
import org.hibernate.cache.UpdateTimestampsCache;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Settings;
import org.hibernate.classic.Session;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.context.CurrentSessionContext;
import org.hibernate.context.JTASessionContext;
import org.hibernate.context.ThreadLocalSessionContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.event.EventListeners;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.hql.FilterTranslator;
import org.hibernate.hql.QuerySplitter;
import org.hibernate.hql.QueryTranslator;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDHexGenerator;
import org.hibernate.impl.SessionFactoryObjectFactory;
import org.hibernate.impl.SessionImpl;
import org.hibernate.impl.StatelessSessionImpl;
import org.hibernate.jdbc.BatcherFactory;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.persister.PersisterFactory;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.stat.Statistics;
import org.hibernate.stat.StatisticsImpl;
import org.hibernate.stat.StatisticsImplementor;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.hbm2ddl.SchemaValidator;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.ReflectHelper;

public final class SessionFactoryImpl
implements SessionFactory,
SessionFactoryImplementor {
    private final String name;
    private final String uuid;
    private final transient Map entityPersisters;
    private final transient Map classMetadata;
    private final transient Map collectionPersisters;
    private final transient Map collectionMetadata;
    private final transient Map collectionRolesByEntityParticipant;
    private final transient Map identifierGenerators;
    private final transient Map namedQueries;
    private final transient Map namedSqlQueries;
    private final transient Map sqlResultSetMappings;
    private final transient Map filters;
    private final transient Map imports;
    private final transient Interceptor interceptor;
    private final transient Settings settings;
    private final transient Properties properties;
    private transient SchemaExport schemaExport;
    private final transient TransactionManager transactionManager;
    private final transient QueryCache queryCache;
    private final transient UpdateTimestampsCache updateTimestampsCache;
    private final transient Map queryCaches;
    private final transient Map allCacheRegions = new HashMap();
    private final transient StatisticsImpl statistics = new StatisticsImpl(this);
    private final transient EventListeners eventListeners;
    private final transient CurrentSessionContext currentSessionContext;
    private transient boolean isClosed = false;
    private static final IdentifierGenerator UUID_GENERATOR = new UUIDHexGenerator();
    private static final Log log = LogFactory.getLog(SessionFactoryImpl.class);
    private static final int MAX_STRONG_REF_COUNT = 128;
    private final transient Object[] strongRefs = new Object[128];
    private transient int strongRefIndex = 0;
    private final transient Map softQueryCache = new ReferenceMap(1, 1);
    private static final QueryCacheKeyFactory QUERY_KEY_FACTORY;
    private static final FilterCacheKeyFactory FILTER_KEY_FACTORY;
    private static final FilteredQueryCacheKeyFactory FILTERED_QUERY_KEY_FACTORY;
    private static final FilteredFilterCacheKeyFactory FILTERED_FILTER_KEY_FACTORY;

    public SessionFactoryImpl(Configuration cfg, Mapping mapping, Settings settings, EventListeners listeners) throws HibernateException {
        log.info("building session factory");
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)cfg.getProperties());
        this.interceptor = cfg.getInterceptor();
        this.settings = settings;
        this.eventListeners = listeners;
        this.filters = new HashMap();
        this.filters.putAll(cfg.getFilterDefinitions());
        if (log.isDebugEnabled()) {
            log.debug("Session factory constructed with filter configurations : " + this.filters);
        }
        if (log.isDebugEnabled()) {
            log.debug("instantiating session factory with properties: " + this.properties);
        }
        settings.getCacheProvider().start(this.properties);
        this.identifierGenerators = new HashMap();
        Iterator classes = cfg.getClassMappings();
        while (classes.hasNext()) {
            PersistentClass model = (PersistentClass)classes.next();
            if (model.isInherited()) continue;
            IdentifierGenerator generator = model.getIdentifier().createIdentifierGenerator(settings.getDialect(), settings.getDefaultCatalogName(), settings.getDefaultSchemaName(), (RootClass)model);
            this.identifierGenerators.put(model.getEntityName(), generator);
        }
        HashMap<String, CacheConcurrencyStrategy> caches = new HashMap<String, CacheConcurrencyStrategy>();
        this.entityPersisters = new HashMap();
        HashMap<String, ClassMetadata> classMeta = new HashMap<String, ClassMetadata>();
        classes = cfg.getClassMappings();
        while (classes.hasNext()) {
            PersistentClass model = (PersistentClass)classes.next();
            model.prepareTemporaryTables(mapping, settings.getDialect());
            String cacheRegion = model.getRootClass().getCacheRegionName();
            CacheConcurrencyStrategy cache = (CacheConcurrencyStrategy)caches.get(cacheRegion);
            if (cache == null && (cache = CacheFactory.createCache(model.getCacheConcurrencyStrategy(), cacheRegion, model.isMutable(), settings, this.properties)) != null) {
                caches.put(cacheRegion, cache);
                this.allCacheRegions.put(cache.getRegionName(), cache.getCache());
            }
            EntityPersister cp = PersisterFactory.createClassPersister(model, cache, this, mapping);
            this.entityPersisters.put(model.getEntityName(), cp);
            classMeta.put(model.getEntityName(), cp.getClassMetadata());
        }
        this.classMetadata = Collections.unmodifiableMap(classMeta);
        HashMap<String, HashSet<String>> tmpEntityToCollectionRoleMap = new HashMap<String, HashSet<String>>();
        this.collectionPersisters = new HashMap();
        Iterator collections = cfg.getCollectionMappings();
        while (collections.hasNext()) {
            Type elementType;
            Collection model = (Collection)collections.next();
            CacheConcurrencyStrategy cache = CacheFactory.createCache(model.getCacheConcurrencyStrategy(), model.getCacheRegionName(), true, settings, this.properties);
            if (cache != null) {
                this.allCacheRegions.put(cache.getRegionName(), cache.getCache());
            }
            CollectionPersister persister = PersisterFactory.createCollectionPersister(cfg, model, cache, this);
            this.collectionPersisters.put(model.getRole(), persister.getCollectionMetadata());
            Type indexType = persister.getIndexType();
            if (indexType != null && indexType.isAssociationType() && !indexType.isAnyType()) {
                String entityName = ((AssociationType)indexType).getAssociatedEntityName(this);
                HashSet<String> roles = (HashSet<String>)tmpEntityToCollectionRoleMap.get(entityName);
                if (roles == null) {
                    roles = new HashSet<String>();
                    tmpEntityToCollectionRoleMap.put(entityName, roles);
                }
                roles.add(persister.getRole());
            }
            if (!(elementType = persister.getElementType()).isAssociationType() || elementType.isAnyType()) continue;
            String entityName = ((AssociationType)elementType).getAssociatedEntityName(this);
            HashSet<String> roles = (HashSet<String>)tmpEntityToCollectionRoleMap.get(entityName);
            if (roles == null) {
                roles = new HashSet<String>();
                tmpEntityToCollectionRoleMap.put(entityName, roles);
            }
            roles.add(persister.getRole());
        }
        this.collectionMetadata = Collections.unmodifiableMap(this.collectionPersisters);
        Iterator itr = tmpEntityToCollectionRoleMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            entry.setValue(Collections.unmodifiableSet((Set)entry.getValue()));
        }
        this.collectionRolesByEntityParticipant = Collections.unmodifiableMap(tmpEntityToCollectionRoleMap);
        this.namedQueries = new HashMap(cfg.getNamedQueries());
        this.namedSqlQueries = new HashMap(cfg.getNamedSQLQueries());
        this.sqlResultSetMappings = new HashMap(cfg.getSqlResultSetMappings());
        this.imports = new HashMap(cfg.getImports());
        Iterator iter = this.entityPersisters.values().iterator();
        while (iter.hasNext()) {
            ((EntityPersister)iter.next()).postInstantiate();
        }
        iter = this.collectionPersisters.values().iterator();
        while (iter.hasNext()) {
            ((CollectionPersister)iter.next()).postInstantiate();
        }
        this.name = settings.getSessionFactoryName();
        try {
            this.uuid = (String)((Object)UUID_GENERATOR.generate(null, null));
        }
        catch (Exception e) {
            throw new AssertionFailure("Could not generate UUID");
        }
        SessionFactoryObjectFactory.addInstance(this.uuid, this.name, this, this.properties);
        log.debug("instantiated session factory");
        if (settings.isAutoCreateSchema()) {
            new SchemaExport(cfg, settings).create(false, true);
        }
        if (settings.isAutoUpdateSchema()) {
            new SchemaUpdate(cfg, settings).execute(false, true);
        }
        if (settings.isAutoValidateSchema()) {
            new SchemaValidator(cfg, settings).validate();
        }
        if (settings.isAutoDropSchema()) {
            this.schemaExport = new SchemaExport(cfg, settings);
        }
        if (settings.getTransactionManagerLookup() != null) {
            log.debug("obtaining JTA TransactionManager");
            this.transactionManager = settings.getTransactionManagerLookup().getTransactionManager(this.properties);
        } else {
            if (settings.getTransactionFactory().isTransactionManagerRequired()) {
                throw new HibernateException("The chosen transaction strategy requires access to the JTA TransactionManager");
            }
            this.transactionManager = null;
        }
        this.currentSessionContext = this.buildCurrentSessionContext();
        if (settings.isQueryCacheEnabled()) {
            this.updateTimestampsCache = new UpdateTimestampsCache(settings, this.properties);
            this.queryCache = settings.getQueryCacheFactory().getQueryCache(null, this.updateTimestampsCache, settings, this.properties);
            this.queryCaches = new HashMap();
            this.allCacheRegions.put(this.updateTimestampsCache.getRegionName(), this.updateTimestampsCache.getCache());
            this.allCacheRegions.put(this.queryCache.getRegionName(), this.queryCache.getCache());
        } else {
            this.updateTimestampsCache = null;
            this.queryCache = null;
            this.queryCaches = null;
        }
        Map errors = this.checkNamedQueries();
        if (!errors.isEmpty()) {
            Set keys = errors.keySet();
            StringBuffer failingQueries = new StringBuffer("Errors in named queries: ");
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String queryName = (String)iterator.next();
                HibernateException e = (HibernateException)errors.get(queryName);
                failingQueries.append(queryName);
                if (iterator.hasNext()) {
                    failingQueries.append(", ");
                }
                log.error("Error in named query: " + queryName, e);
            }
            throw new HibernateException(failingQueries.toString());
        }
        this.getStatistics().setStatisticsEnabled(settings.isStatisticsEnabled());
    }

    private synchronized Object get(Object key) {
        Object result = this.softQueryCache.get(key);
        if (result != null) {
            this.strongRefs[++this.strongRefIndex % 128] = result;
        }
        return result;
    }

    private void put(Object key, Object value) {
        this.softQueryCache.put(key, value);
        this.strongRefs[++this.strongRefIndex % 128] = value;
    }

    private synchronized QueryTranslator[] createQueryTranslators(String[] concreteQueryStrings, Object cacheKey, Map enabledFilters) {
        int length = concreteQueryStrings.length;
        QueryTranslator[] queries = new QueryTranslator[length];
        for (int i = 0; i < length; ++i) {
            queries[i] = this.settings.getQueryTranslatorFactory().createQueryTranslator(concreteQueryStrings[i], enabledFilters, this);
        }
        if (cacheKey != null) {
            this.put(cacheKey, queries);
        }
        return queries;
    }

    private synchronized FilterTranslator createFilterTranslator(String filterString, Object cacheKey, Map enabledFilters) {
        FilterTranslator filter = this.settings.getQueryTranslatorFactory().createFilterTranslator(filterString, enabledFilters, this);
        if (cacheKey != null) {
            this.put(cacheKey, filter);
        }
        return filter;
    }

    private Map checkNamedQueries() throws HibernateException {
        HashMap<String, HibernateException> errors = new HashMap<String, HibernateException>();
        Set names = this.namedQueries.keySet();
        log.info("Checking " + this.namedQueries.size() + " named queries");
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            String queryName = (String)iterator.next();
            NamedQueryDefinition q = (NamedQueryDefinition)this.namedQueries.get(queryName);
            try {
                log.debug("Checking named query: " + queryName);
                this.getQuery(q.getQueryString(), false, CollectionHelper.EMPTY_MAP);
            }
            catch (QueryException e) {
                errors.put(queryName, e);
            }
            catch (MappingException e) {
                errors.put(queryName, e);
            }
        }
        return errors;
    }

    public QueryTranslator[] getQuery(String queryString, boolean shallow, Map enabledFilters) throws QueryException, MappingException {
        Object cacheKey = this.getQueryTranslatorCacheKey(queryString, shallow, enabledFilters);
        QueryTranslator[] queries = (QueryTranslator[])this.get(cacheKey);
        if (queries == null) {
            String[] concreteQueryStrings = QuerySplitter.concreteQueries(queryString, this);
            queries = this.createQueryTranslators(concreteQueryStrings, cacheKey, enabledFilters);
        }
        for (int i = 0; i < queries.length; ++i) {
            queries[i].compile(this.settings.getQuerySubstitutions(), shallow);
        }
        return queries;
    }

    public FilterTranslator getFilter(String filterString, String collectionRole, boolean scalar, Map enabledFilters) throws QueryException, MappingException {
        Object cacheKey = this.getFilterTranslatorCacheKey(filterString, collectionRole, scalar, enabledFilters);
        FilterTranslator filter = (FilterTranslator)this.get(cacheKey);
        if (filter == null) {
            filter = this.createFilterTranslator(filterString, cacheKey, enabledFilters);
        }
        filter.compile(collectionRole, this.settings.getQuerySubstitutions(), scalar);
        return filter;
    }

    private Object getQueryTranslatorCacheKey(String queryString, boolean shallow, Map enabledFilters) {
        if (enabledFilters == null || enabledFilters.isEmpty()) {
            return QUERY_KEY_FACTORY.newInstance(queryString, shallow);
        }
        HashSet filterNames = new HashSet(enabledFilters.keySet());
        return FILTERED_QUERY_KEY_FACTORY.newInstance(queryString, shallow, filterNames);
    }

    private Object getFilterTranslatorCacheKey(String filterString, String collectionRole, boolean scalar, Map enabledFilters) {
        if (enabledFilters == null || enabledFilters.isEmpty()) {
            return FILTER_KEY_FACTORY.newInstance(collectionRole, filterString, scalar);
        }
        HashSet filterNames = new HashSet(enabledFilters.keySet());
        return FILTERED_FILTER_KEY_FACTORY.newInstance(collectionRole, filterString, scalar, filterNames);
    }

    public StatelessSession openStatelessSession() {
        return new StatelessSessionImpl(null, this);
    }

    public StatelessSession openStatelessSession(Connection connection) {
        return new StatelessSessionImpl(connection, this);
    }

    private SessionImpl openSession(Connection connection, boolean autoClose, long timestamp, Interceptor sessionLocalInterceptor) {
        return new SessionImpl(connection, this, autoClose, timestamp, sessionLocalInterceptor == null ? this.interceptor : sessionLocalInterceptor, this.settings.getDefaultEntityMode(), this.settings.isFlushBeforeCompletionEnabled(), this.settings.isAutoCloseSessionEnabled(), this.settings.getConnectionReleaseMode());
    }

    public Session openSession(Connection connection, Interceptor sessionLocalInterceptor) {
        return this.openSession(connection, false, Long.MIN_VALUE, sessionLocalInterceptor);
    }

    public Session openSession(Interceptor sessionLocalInterceptor) throws HibernateException {
        long timestamp = this.settings.getCacheProvider().nextTimestamp();
        return this.openSession(null, true, timestamp, sessionLocalInterceptor);
    }

    public Session openSession(Connection connection) {
        return this.openSession(connection, this.interceptor);
    }

    public Session openSession() throws HibernateException {
        return this.openSession(this.interceptor);
    }

    public Session openTemporarySession() throws HibernateException {
        return new SessionImpl(null, this, true, this.settings.getCacheProvider().nextTimestamp(), this.interceptor, this.settings.getDefaultEntityMode(), false, false, ConnectionReleaseMode.AFTER_STATEMENT);
    }

    public Session openSession(Connection connection, boolean flushBeforeCompletionEnabled, boolean autoCloseSessionEnabled, ConnectionReleaseMode connectionReleaseMode) throws HibernateException {
        return new SessionImpl(connection, this, true, this.settings.getCacheProvider().nextTimestamp(), this.interceptor, this.settings.getDefaultEntityMode(), flushBeforeCompletionEnabled, autoCloseSessionEnabled, connectionReleaseMode);
    }

    public Session getCurrentSession() throws HibernateException {
        if (this.currentSessionContext == null) {
            throw new HibernateException("No CurrentSessionContext configured!");
        }
        return this.currentSessionContext.currentSession();
    }

    public EntityPersister getEntityPersister(String entityName) throws MappingException {
        EntityPersister result = (EntityPersister)this.entityPersisters.get(entityName);
        if (result == null) {
            throw new MappingException("Unknown entity: " + entityName);
        }
        return result;
    }

    public CollectionPersister getCollectionPersister(String role) throws MappingException {
        CollectionPersister result = (CollectionPersister)this.collectionPersisters.get(role);
        if (result == null) {
            throw new MappingException("Unknown collection role: " + role);
        }
        return result;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Dialect getDialect() {
        return this.settings.getDialect();
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public TransactionFactory getTransactionFactory() {
        return this.settings.getTransactionFactory();
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public SQLExceptionConverter getSQLExceptionConverter() {
        return this.settings.getSQLExceptionConverter();
    }

    public Set getCollectionRolesByEntityParticipant(String entityName) {
        return (Set)this.collectionRolesByEntityParticipant.get(entityName);
    }

    public Reference getReference() throws NamingException {
        log.debug("Returning a Reference to the SessionFactory");
        return new Reference(SessionFactoryImpl.class.getName(), new StringRefAddr("uuid", this.uuid), SessionFactoryObjectFactory.class.getName(), null);
    }

    private Object readResolve() throws ObjectStreamException {
        log.trace("Resolving serialized SessionFactory");
        Object result = SessionFactoryObjectFactory.getInstance(this.uuid);
        if (result == null) {
            result = SessionFactoryObjectFactory.getNamedInstance(this.name);
            if (result == null) {
                throw new InvalidObjectException("Could not find a SessionFactory named: " + this.name);
            }
            log.debug("resolved SessionFactory by name");
        } else {
            log.debug("resolved SessionFactory by uid");
        }
        return result;
    }

    public NamedQueryDefinition getNamedQuery(String queryName) {
        return (NamedQueryDefinition)this.namedQueries.get(queryName);
    }

    public NamedSQLQueryDefinition getNamedSQLQuery(String queryName) {
        return (NamedSQLQueryDefinition)this.namedSqlQueries.get(queryName);
    }

    public ResultSetMappingDefinition getResultSetMapping(String resultSetName) {
        return (ResultSetMappingDefinition)this.sqlResultSetMappings.get(resultSetName);
    }

    public Type getIdentifierType(String className) throws MappingException {
        return this.getEntityPersister(className).getIdentifierType();
    }

    public String getIdentifierPropertyName(String className) throws MappingException {
        return this.getEntityPersister(className).getIdentifierPropertyName();
    }

    private final void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        log.trace("deserializing");
        in.defaultReadObject();
        log.debug("deserialized: " + this.uuid);
    }

    private final void writeObject(ObjectOutputStream out) throws IOException {
        log.debug("serializing: " + this.uuid);
        out.defaultWriteObject();
        log.trace("serialized");
    }

    public Type[] getReturnTypes(String queryString) throws HibernateException {
        return this.getRepresentativeQuery(queryString).getReturnTypes();
    }

    public String[] getReturnAliases(String queryString) throws HibernateException {
        return this.getRepresentativeQuery(queryString).getReturnAliases();
    }

    private QueryTranslator getRepresentativeQuery(String queryString) throws HibernateException {
        String[] queries = QuerySplitter.concreteQueries(queryString, this);
        if (queries.length == 0) {
            throw new HibernateException("Query does not refer to any persistent classes: " + queryString);
        }
        return this.getQuery(queries[0], true, CollectionHelper.EMPTY_MAP)[0];
    }

    public ClassMetadata getClassMetadata(Class persistentClass) throws HibernateException {
        return this.getClassMetadata(persistentClass.getName());
    }

    public CollectionMetadata getCollectionMetadata(String roleName) throws HibernateException {
        return (CollectionMetadata)this.collectionMetadata.get(roleName);
    }

    public ClassMetadata getClassMetadata(String entityName) throws HibernateException {
        return (ClassMetadata)this.classMetadata.get(entityName);
    }

    public String[] getImplementors(String className) throws MappingException {
        Class clazz;
        try {
            clazz = ReflectHelper.classForName(className);
        }
        catch (ClassNotFoundException cnfe) {
            return new String[]{className};
        }
        ArrayList<String> results = new ArrayList<String>();
        Iterator iter = this.entityPersisters.values().iterator();
        while (iter.hasNext()) {
            boolean assignableSuperclass;
            EntityPersister testPersister = (EntityPersister)iter.next();
            if (!(testPersister instanceof Queryable)) continue;
            Queryable testQueryable = (Queryable)testPersister;
            String testClassName = testQueryable.getEntityName();
            boolean isMappedClass = className.equals(testClassName);
            if (testQueryable.isExplicitPolymorphism()) {
                if (!isMappedClass) continue;
                return new String[]{className};
            }
            if (isMappedClass) {
                results.add(testClassName);
                continue;
            }
            Class mappedClass = testQueryable.getMappedClass(EntityMode.POJO);
            if (mappedClass == null || !clazz.isAssignableFrom(mappedClass)) continue;
            if (testQueryable.isInherited()) {
                Class mappedSuperclass = this.getEntityPersister(testQueryable.getMappedSuperclass()).getMappedClass(EntityMode.POJO);
                assignableSuperclass = clazz.isAssignableFrom(mappedSuperclass);
            } else {
                assignableSuperclass = false;
            }
            if (assignableSuperclass) continue;
            results.add(testClassName);
        }
        return results.toArray(new String[results.size()]);
    }

    public String getImportedClassName(String className) {
        String result = (String)this.imports.get(className);
        if (result == null) {
            try {
                ReflectHelper.classForName(className);
                return className;
            }
            catch (ClassNotFoundException cnfe) {
                return null;
            }
        }
        return result;
    }

    public Map getAllClassMetadata() throws HibernateException {
        return this.classMetadata;
    }

    public Map getAllCollectionMetadata() throws HibernateException {
        return this.collectionMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws HibernateException {
        Object p;
        log.info("closing");
        this.isClosed = true;
        Iterator iter = this.entityPersisters.values().iterator();
        while (iter.hasNext()) {
            p = (EntityPersister)iter.next();
            if (!p.hasCache()) continue;
            p.getCache().destroy();
        }
        iter = this.collectionPersisters.values().iterator();
        while (iter.hasNext()) {
            p = (CollectionPersister)iter.next();
            if (!p.hasCache()) continue;
            p.getCache().destroy();
        }
        if (this.settings.isQueryCacheEnabled()) {
            this.queryCache.destroy();
            iter = this.queryCaches.values().iterator();
            while (iter.hasNext()) {
                QueryCache cache = (QueryCache)iter.next();
                cache.destroy();
            }
            this.updateTimestampsCache.destroy();
        }
        this.settings.getCacheProvider().stop();
        try {
            this.settings.getConnectionProvider().close();
        }
        finally {
            SessionFactoryObjectFactory.removeInstance(this.uuid, this.name, this.properties);
        }
        if (this.settings.isAutoDropSchema()) {
            this.schemaExport.drop(false, true);
        }
    }

    public void evictEntity(String entityName, Serializable id) throws HibernateException {
        EntityPersister p = this.getEntityPersister(entityName);
        if (p.hasCache()) {
            if (log.isDebugEnabled()) {
                log.debug("evicting second-level cache: " + MessageHelper.infoString(p, id, (SessionFactoryImplementor)this));
            }
            CacheKey cacheKey = new CacheKey(id, p.getIdentifierType(), p.getRootEntityName(), EntityMode.POJO, this);
            p.getCache().remove(cacheKey);
        }
    }

    public void evictEntity(String entityName) throws HibernateException {
        EntityPersister p = this.getEntityPersister(entityName);
        if (p.hasCache()) {
            if (log.isDebugEnabled()) {
                log.debug("evicting second-level cache: " + p.getEntityName());
            }
            p.getCache().clear();
        }
    }

    public void evict(Class persistentClass, Serializable id) throws HibernateException {
        EntityPersister p = this.getEntityPersister(persistentClass.getName());
        if (p.hasCache()) {
            if (log.isDebugEnabled()) {
                log.debug("evicting second-level cache: " + MessageHelper.infoString(p, id, (SessionFactoryImplementor)this));
            }
            CacheKey cacheKey = new CacheKey(id, p.getIdentifierType(), p.getRootEntityName(), EntityMode.POJO, this);
            p.getCache().remove(cacheKey);
        }
    }

    public void evict(Class persistentClass) throws HibernateException {
        EntityPersister p = this.getEntityPersister(persistentClass.getName());
        if (p.hasCache()) {
            if (log.isDebugEnabled()) {
                log.debug("evicting second-level cache: " + p.getEntityName());
            }
            p.getCache().clear();
        }
    }

    public void evictCollection(String roleName, Serializable id) throws HibernateException {
        CollectionPersister p = this.getCollectionPersister(roleName);
        if (p.hasCache()) {
            if (log.isDebugEnabled()) {
                log.debug("evicting second-level cache: " + MessageHelper.collectionInfoString(p, id, (SessionFactoryImplementor)this));
            }
            CacheKey cacheKey = new CacheKey(id, p.getKeyType(), p.getRole(), EntityMode.POJO, this);
            p.getCache().remove(cacheKey);
        }
    }

    public void evictCollection(String roleName) throws HibernateException {
        CollectionPersister p = this.getCollectionPersister(roleName);
        if (p.hasCache()) {
            if (log.isDebugEnabled()) {
                log.debug("evicting second-level cache: " + p.getRole());
            }
            p.getCache().clear();
        }
    }

    public Type getReferencedPropertyType(String className, String propertyName) throws MappingException {
        return this.getEntityPersister(className).getPropertyType(propertyName);
    }

    public ConnectionProvider getConnectionProvider() {
        return this.settings.getConnectionProvider();
    }

    public UpdateTimestampsCache getUpdateTimestampsCache() {
        return this.updateTimestampsCache;
    }

    public QueryCache getQueryCache() {
        return this.queryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryCache getQueryCache(String cacheRegion) throws HibernateException {
        if (cacheRegion == null) {
            return this.getQueryCache();
        }
        if (!this.settings.isQueryCacheEnabled()) {
            return null;
        }
        Map map = this.allCacheRegions;
        synchronized (map) {
            QueryCache currentQueryCache = (QueryCache)this.queryCaches.get(cacheRegion);
            if (currentQueryCache == null) {
                currentQueryCache = this.settings.getQueryCacheFactory().getQueryCache(cacheRegion, this.updateTimestampsCache, this.settings, this.properties);
                this.queryCaches.put(cacheRegion, currentQueryCache);
                this.allCacheRegions.put(currentQueryCache.getRegionName(), currentQueryCache.getCache());
            }
            return currentQueryCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getSecondLevelCacheRegion(String regionName) {
        Map map = this.allCacheRegions;
        synchronized (map) {
            return (Cache)this.allCacheRegions.get(regionName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getAllSecondLevelCacheRegions() {
        Map map = this.allCacheRegions;
        synchronized (map) {
            return new HashMap(this.allCacheRegions);
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public StatisticsImplementor getStatisticsImplementor() {
        return this.statistics;
    }

    public void evictQueries() throws HibernateException {
        if (this.settings.isQueryCacheEnabled()) {
            this.queryCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictQueries(String cacheRegion) throws HibernateException {
        if (cacheRegion == null) {
            throw new NullPointerException("use the zero-argument form to evict the default query cache");
        }
        Map map = this.allCacheRegions;
        synchronized (map) {
            QueryCache currentQueryCache;
            if (this.settings.isQueryCacheEnabled() && (currentQueryCache = (QueryCache)this.queryCaches.get(cacheRegion)) != null) {
                currentQueryCache.clear();
            }
        }
    }

    public FilterDefinition getFilterDefinition(String filterName) throws IllegalArgumentException {
        FilterDefinition def = (FilterDefinition)this.filters.get(filterName);
        if (def == null) {
            throw new IllegalArgumentException("No such filter configured [" + filterName + "]");
        }
        return def;
    }

    public BatcherFactory getBatcherFactory() {
        return this.settings.getBatcherFactory();
    }

    public IdentifierGenerator getIdentifierGenerator(String rootEntityName) {
        return (IdentifierGenerator)this.identifierGenerators.get(rootEntityName);
    }

    private CurrentSessionContext buildCurrentSessionContext() {
        String impl = this.properties.getProperty("hibernate.current_session_context_class");
        if (impl == null && this.transactionManager != null) {
            impl = "jta";
        }
        if (impl == null) {
            return null;
        }
        if ("jta".equals(impl)) {
            return new JTASessionContext(this);
        }
        if ("thread".equals(impl)) {
            return new ThreadLocalSessionContext(this);
        }
        try {
            Class implClass = ReflectHelper.classForName(impl);
            return (CurrentSessionContext)implClass.getConstructor(SessionFactoryImplementor.class).newInstance(this);
        }
        catch (Throwable t) {
            log.error("Unable to construct current session context [" + impl + "]", t);
            return null;
        }
    }

    public EventListeners getEventListeners() {
        return this.eventListeners;
    }

    static {
        FILTERED_QUERY_KEY_FACTORY = (FilteredQueryCacheKeyFactory)((Object)KeyFactory.create(FilteredQueryCacheKeyFactory.class));
        QUERY_KEY_FACTORY = (QueryCacheKeyFactory)((Object)KeyFactory.create(QueryCacheKeyFactory.class));
        FILTER_KEY_FACTORY = (FilterCacheKeyFactory)((Object)KeyFactory.create(FilterCacheKeyFactory.class));
        FILTERED_FILTER_KEY_FACTORY = (FilteredFilterCacheKeyFactory)((Object)KeyFactory.create(FilteredFilterCacheKeyFactory.class));
    }

    static interface FilterCacheKeyFactory {
        public Object newInstance(String var1, String var2, boolean var3);
    }

    static interface FilteredFilterCacheKeyFactory {
        public Object newInstance(String var1, String var2, boolean var3, Set var4);
    }

    static interface QueryCacheKeyFactory {
        public Object newInstance(String var1, boolean var2);
    }

    static interface FilteredQueryCacheKeyFactory {
        public Object newInstance(String var1, boolean var2, Set var3);
    }
}

