/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TransactionHelper;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;

public class MultipleHiLoPerTableGenerator
extends TransactionHelper
implements PersistentIdentifierGenerator,
Configurable {
    private static final Log log = LogFactory.getLog(MultipleHiLoPerTableGenerator.class);
    public static final String ID_TABLE = "table";
    public static final String PK_COLUMN_NAME = "primary_key_column";
    public static final String PK_VALUE_NAME = "primary_key_value";
    public static final String VALUE_COLUMN_NAME = "value_column";
    public static final String PK_LENGTH_NAME = "primary_key_length";
    private static final int DEFAULT_PK_LENGTH = 255;
    public static final String DEFAULT_TABLE = "hibernate_sequences";
    private static final String DEFAULT_PK_COLUMN = "sequence_name";
    private static final String DEFAULT_VALUE_COLUMN = "sequence_next_hi_value";
    private String tableName;
    private String pkColumnName;
    private String valueColumnName;
    private String query;
    private String insert;
    private String update;
    public static final String MAX_LO = "max_lo";
    private long hi;
    private int lo;
    private int maxLo;
    private Class returnClass;
    private int keySize;

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{"create table " + this.tableName + " ( " + this.pkColumnName + " " + dialect.getTypeName(12, this.keySize, 0, 0) + ",  " + this.valueColumnName + " " + dialect.getTypeName(4) + " ) "};
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        StringBuffer sqlDropString = new StringBuffer().append("drop table ");
        if (dialect.supportsIfExistsBeforeTableName()) {
            sqlDropString.append("if exists ");
        }
        sqlDropString.append(this.tableName).append(dialect.getCascadeConstraintsString());
        if (dialect.supportsIfExistsAfterTableName()) {
            sqlDropString.append(" if exists");
        }
        return new String[]{sqlDropString.toString()};
    }

    public Object generatorKey() {
        return this.tableName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Serializable doWorkInCurrentTransaction(Connection conn, String sql) throws SQLException {
        int result;
        int rows;
        do {
            PreparedStatement qps;
            block13: {
                Object var10_11;
                SQL.debug(this.query);
                qps = conn.prepareStatement(this.query);
                Statement ips = null;
                try {
                    try {
                        ResultSet rs = qps.executeQuery();
                        boolean isInitialized = rs.next();
                        if (!isInitialized) {
                            result = 0;
                            ips = conn.prepareStatement(this.insert);
                            ips.setInt(1, result);
                            ips.execute();
                        } else {
                            result = rs.getInt(1);
                        }
                        rs.close();
                    }
                    catch (SQLException sqle) {
                        log.error("could not read or init a hi value", sqle);
                        throw sqle;
                    }
                    var10_11 = null;
                    if (ips == null) break block13;
                }
                catch (Throwable throwable) {
                    var10_11 = null;
                    if (ips != null) {
                        ips.close();
                    }
                    qps.close();
                    throw throwable;
                }
                ips.close();
            }
            qps.close();
            PreparedStatement ups = conn.prepareStatement(this.update);
            try {
                ups.setInt(1, result + 1);
                ups.setInt(2, result);
                rows = ups.executeUpdate();
            }
            catch (SQLException sqle) {
                log.error("could not update hi value in: " + this.tableName, sqle);
                throw sqle;
            }
            finally {
                ups.close();
            }
        } while (rows == 0);
        return new Integer(result);
    }

    public synchronized Serializable generate(SessionImplementor session, Object obj) throws HibernateException {
        if (this.lo > this.maxLo) {
            int hival = (Integer)this.doWorkInNewTransaction(session);
            this.lo = hival == 0 ? 1 : 0;
            this.hi = hival * (this.maxLo + 1);
            log.debug("new hi value: " + hival);
        }
        return IdentifierGeneratorFactory.createNumber(this.hi + (long)this.lo++, this.returnClass);
    }

    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        this.tableName = PropertiesHelper.getString(ID_TABLE, params, DEFAULT_TABLE);
        this.pkColumnName = PropertiesHelper.getString(PK_COLUMN_NAME, params, DEFAULT_PK_COLUMN);
        this.valueColumnName = PropertiesHelper.getString(VALUE_COLUMN_NAME, params, DEFAULT_VALUE_COLUMN);
        String schemaName = params.getProperty("schema");
        String catalogName = params.getProperty("catalog");
        this.keySize = PropertiesHelper.getInt(PK_LENGTH_NAME, params, 255);
        String keyValue = PropertiesHelper.getString(PK_VALUE_NAME, params, params.getProperty("target_table"));
        if (this.tableName.indexOf(dialect.getSchemaSeparator()) < 0) {
            this.tableName = Table.qualify(catalogName, schemaName, this.tableName, dialect.getSchemaSeparator());
        }
        this.query = "select " + this.valueColumnName + " from " + dialect.appendLockHint(LockMode.UPGRADE, this.tableName) + " where " + this.pkColumnName + " = '" + keyValue + "'" + dialect.getForUpdateString();
        this.update = "update " + this.tableName + " set " + this.valueColumnName + " = ? where " + this.valueColumnName + " = ? and " + this.pkColumnName + " = '" + keyValue + "'";
        this.insert = "insert into " + this.tableName + "(" + this.pkColumnName + ", " + this.valueColumnName + ") " + "values('" + keyValue + "', ?)";
        this.maxLo = PropertiesHelper.getInt(MAX_LO, params, Short.MAX_VALUE);
        this.lo = this.maxLo + 1;
        this.returnClass = type.getReturnedClass();
    }
}

