/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.util;

import antlr.ASTFactory;
import antlr.collections.AST;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.hql.ast.util.ASTUtil;
import org.hibernate.util.StringHelper;

public final class PathHelper {
    private static final Log log = LogFactory.getLog(PathHelper.class);

    private PathHelper() {
    }

    public static AST parsePath(String path, ASTFactory factory) {
        String[] identifiers = StringHelper.split(".", path);
        AST lhs = null;
        for (int i = 0; i < identifiers.length; ++i) {
            String identifier = identifiers[i];
            AST child = ASTUtil.create(factory, 119, identifier);
            lhs = i == 0 ? child : ASTUtil.createBinarySubtree(factory, 15, ".", lhs, child);
        }
        if (log.isDebugEnabled()) {
            log.debug("parsePath() : " + path + " -> " + ASTUtil.getDebugString(lhs));
        }
        return lhs;
    }

    public static String getAlias(String path) {
        return StringHelper.root(path);
    }
}

