/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.util;

import antlr.SemanticException;
import antlr.collections.AST;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.dialect.Dialect;
import org.hibernate.hql.antlr.HqlSqlTokenTypes;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.InvalidPathException;
import org.hibernate.hql.ast.tree.DotNode;
import org.hibernate.hql.ast.tree.FromClause;
import org.hibernate.hql.ast.tree.IdentNode;
import org.hibernate.hql.ast.util.ASTUtil;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.LiteralType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ReflectHelper;

public class LiteralProcessor
implements HqlSqlTokenTypes {
    private static final Log log = LogFactory.getLog(LiteralProcessor.class);
    private HqlSqlWalker walker;

    public LiteralProcessor(HqlSqlWalker hqlSqlWalker) {
        this.walker = hqlSqlWalker;
    }

    public boolean isAlias(String alias) {
        FromClause from = this.walker.getCurrentFromClause();
        while (from.isSubQuery()) {
            if (from.containsClassAlias(alias)) {
                return true;
            }
            from = from.getParentFromClause();
        }
        return from.containsClassAlias(alias);
    }

    public void processConstant(AST constant) throws SemanticException {
        boolean isIdent;
        boolean bl = isIdent = constant.getType() == 119 || constant.getType() == 90;
        if (isIdent && this.isAlias(constant.getText())) {
            IdentNode ident = (IdentNode)constant;
            ident.resolve(false, true);
        } else {
            Queryable queryable = this.walker.getSessionFactoryHelper().findQueryableUsingImports(constant.getText());
            if (isIdent && queryable != null) {
                constant.setText(queryable.getDiscriminatorSQLValue().toString());
            } else {
                this.processLiteral(constant);
            }
        }
    }

    public void lookupConstant(DotNode node) throws SemanticException {
        String text = this.getText((AST)node);
        Queryable persister = this.walker.getSessionFactoryHelper().findQueryableUsingImports(text);
        if (persister != null) {
            String discrim = persister.getDiscriminatorSQLValue();
            if ("null".equals(discrim) || "not null".equals(discrim)) {
                throw new InvalidPathException("subclass test not allowed for null or not null discriminator: '" + text + "'");
            }
            this.setSQLValue(node, text, discrim);
        } else {
            Object value = ReflectHelper.getConstantValue(text);
            if (value == null) {
                throw new InvalidPathException("Invalid path: '" + text + "'");
            }
            this.setConstantValue(node, text, value);
        }
    }

    private void setSQLValue(DotNode node, String text, String value) {
        if (log.isDebugEnabled()) {
            log.debug("setSQLValue() " + text + " -> " + value);
        }
        node.setFirstChild(null);
        node.setType(135);
        node.setText(value);
        node.setResolvedConstant(text);
    }

    private void setConstantValue(DotNode node, String text, Object value) {
        Type type;
        if (log.isDebugEnabled()) {
            log.debug("setConstantValue() " + text + " -> " + value + " " + value.getClass().getName());
        }
        node.setFirstChild(null);
        if (value instanceof String) {
            node.setType(118);
        } else if (value instanceof Character) {
            node.setType(118);
        } else if (value instanceof Byte) {
            node.setType(117);
        } else if (value instanceof Short) {
            node.setType(117);
        } else if (value instanceof Integer) {
            node.setType(117);
        } else if (value instanceof Long) {
            node.setType(94);
        } else if (value instanceof Double) {
            node.setType(92);
        } else if (value instanceof Float) {
            node.setType(93);
        } else {
            node.setType(91);
        }
        try {
            type = TypeFactory.heuristicType(value.getClass().getName());
        }
        catch (MappingException me) {
            throw new QueryException(me);
        }
        if (type == null) {
            throw new QueryException("Could not determine type of: " + node.getText());
        }
        try {
            LiteralType literalType = (LiteralType)((Object)type);
            Dialect dialect = this.walker.getSessionFactoryHelper().getFactory().getDialect();
            node.setText(literalType.objectToSQLString(value, dialect));
        }
        catch (Exception e) {
            throw new QueryException("Could not format constant value to SQL literal: " + node.getText(), e);
        }
        node.setDataType(type);
        node.setResolvedConstant(text);
    }

    private String getText(AST node) {
        return ASTUtil.getPathText(node);
    }

    public void processBoolean(AST constant) {
        String replacement = (String)this.walker.getTokenReplacements().get(constant.getText());
        if (replacement != null) {
            constant.setText(replacement);
        } else {
            boolean bool = "true".equals(constant.getText().toLowerCase());
            Dialect dialect = this.walker.getSessionFactoryHelper().getFactory().getDialect();
            constant.setText(dialect.toBooleanValueString(bool));
        }
    }

    private void processLiteral(AST constant) {
        String replacement = (String)this.walker.getTokenReplacements().get(constant.getText());
        if (replacement != null) {
            if (log.isDebugEnabled()) {
                log.debug("processConstant() : Replacing '" + constant.getText() + "' with '" + replacement + "'");
            }
            constant.setText(replacement);
        }
    }
}

