/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.hibernate.util.NamingHelper;
import org.hibernate.util.StringHelper;

public abstract class AbstractJndiBoundCacheProvider
implements CacheProvider {
    private static final Log log = LogFactory.getLog(AbstractJndiBoundCacheProvider.class);
    private Object cache;

    protected void prepare(Properties properties) {
    }

    protected void release() {
    }

    public final void start(Properties properties) throws CacheException {
        String jndiNamespace = properties.getProperty("hibernate.cache.jndi");
        if (StringHelper.isEmpty(jndiNamespace)) {
            throw new CacheException("No JNDI namespace specified for cache");
        }
        this.cache = this.locateCache(jndiNamespace, NamingHelper.getJndiProperties(properties));
        this.prepare(properties);
    }

    public final void stop() {
        this.release();
        this.cache = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object locateCache(String jndiNamespace, Properties jndiProperties) {
        Object object;
        InitialContext ctx = null;
        try {
            try {
                ctx = new InitialContext(jndiProperties);
                object = ctx.lookup(jndiNamespace);
                Object var7_6 = null;
                if (ctx == null) return object;
            }
            catch (NamingException ne) {
                String msg = "Unable to retreive Cache from JNDI [" + jndiNamespace + "]";
                log.info(msg, ne);
                throw new CacheException(msg);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (ctx == null) throw throwable;
            try {
                ctx.close();
                throw throwable;
            }
            catch (NamingException ne2) {
                log.info("Unable to release initial context", ne2);
                throw throwable;
            }
        }
        try {}
        catch (NamingException ne2) {
            log.info("Unable to release initial context", ne2);
            return object;
        }
        ctx.close();
        return object;
    }

    public Object getCache() {
        return this.cache;
    }
}

