/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.transmogrify;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import org.apache.log4j.Logger;
import org.mbari.isi.interfaces.DeviceMessagePacket;
import org.mbari.isi.interfaces.DevicePacket;
import org.mbari.isi.interfaces.MetadataPacket;
import org.mbari.isi.interfaces.SensorDataPacket;

public class SSDSDevicePacket
extends DevicePacket
implements Serializable {
    static Logger logger = Logger.getLogger(SSDSDevicePacket.class);
    private int packetType = -1;
    private long metadataSequenceNumber = -1L;
    private long dataDescriptionVersion = -1L;
    private long platformID = -1L;
    private long recordType = -1L;
    private byte[] dataBuffer = null;
    private byte[] otherBuffer = null;
    public static int VERSION_ID = 3;

    public SSDSDevicePacket(DevicePacket devicePacket) {
        super(devicePacket.sourceID());
        this.setSequenceNo(devicePacket.sequenceNo());
        this.setSystemTime(devicePacket.systemTime());
        this.setParentId(devicePacket.getParentId());
        this.setPlatformID(devicePacket.getParentId());
        this.setRecordType(devicePacket.getRecordType());
        if (devicePacket instanceof MetadataPacket) {
            logger.debug("DevicePacket is a MetadataPacket:");
            this.setDataBuffer(((MetadataPacket)devicePacket).getBytes());
            this.setOtherBuffer(((MetadataPacket)devicePacket).cause());
            this.setPacketType(0);
            this.setRecordType(0L);
            this.setMetadataSequenceNumber(((MetadataPacket)devicePacket).metadataRef());
            this.setDataDescriptionVersion(((MetadataPacket)devicePacket).metadataRef());
        }
        if (devicePacket instanceof SensorDataPacket) {
            StringBuffer stringBuffer = new StringBuffer();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((SensorDataPacket)devicePacket).dataBuffer());
            while (byteArrayInputStream.available() > 0) {
                stringBuffer.append(Integer.toHexString(0xFF & byteArrayInputStream.read() | 0x100).substring(1));
            }
            logger.debug("DevicePacket is a SensorDataPacket:deviceID=" + devicePacket.sourceID() + "," + "timestamp=" + devicePacket.systemTime() + "(" + new Date(devicePacket.systemTime()) + ")," + "sequenceNumber=" + devicePacket.sequenceNo() + "," + "dataBufferLength=" + ((SensorDataPacket)devicePacket).dataBuffer().length + "," + "recordType=" + ((SensorDataPacket)devicePacket).getRecordType() + "," + "metadataRef=" + devicePacket.metadataRef() + "," + "dataBuffer(in hex)=" + stringBuffer.toString());
            this.setDataBuffer(((SensorDataPacket)devicePacket).dataBuffer());
            this.setPacketType(1);
            this.setRecordType(((SensorDataPacket)devicePacket).getRecordType());
            this.setMetadataSequenceNumber(((SensorDataPacket)devicePacket).metadataRef());
            this.setDataDescriptionVersion(((SensorDataPacket)devicePacket).metadataRef());
        }
        if (devicePacket instanceof DeviceMessagePacket) {
            logger.debug("DevicePacket is a DeviceMessagePacket:");
            this.setDataBuffer(((DeviceMessagePacket)devicePacket).getMessage());
            this.setPacketType(2);
            this.setMetadataSequenceNumber(((DeviceMessagePacket)devicePacket).metadataRef());
            this.setDataDescriptionVersion(((DeviceMessagePacket)devicePacket).metadataRef());
        }
    }

    public SSDSDevicePacket(long l, int n) {
        super(l);
        this.setDataBuffer(new byte[n]);
    }

    public long getMetadataSequenceNumber() {
        return this.metadataSequenceNumber;
    }

    public void setMetadataSequenceNumber(long l) {
        this.metadataSequenceNumber = l;
    }

    public long getDataDescriptionVersion() {
        return this.dataDescriptionVersion;
    }

    public void setDataDescriptionVersion(long l) {
        this.dataDescriptionVersion = l;
    }

    public long getPlatformID() {
        return this.platformID;
    }

    public void setPlatformID(long l) {
        this.platformID = l;
    }

    public long getRecordType() {
        return this.recordType;
    }

    public void setRecordType(long l) {
        this.recordType = l;
    }

    public byte[] getDataBuffer() {
        return this.dataBuffer;
    }

    public void setDataBuffer(byte[] byArray) {
        this.dataBuffer = byArray;
    }

    public int getPacketType() {
        return this.packetType;
    }

    public void setPacketType(int n) {
        this.packetType = n;
    }

    public byte[] getOtherBuffer() {
        return this.otherBuffer;
    }

    public void setOtherBuffer(byte[] byArray) {
        this.otherBuffer = byArray;
    }

    public static byte[] convertToByteArray(SSDSDevicePacket sSDSDevicePacket) throws IOException {
        return SSDSDevicePacket.convertToVersion3ByteArray(sSDSDevicePacket);
    }

    private static byte[] convertToVersion3ByteArray(SSDSDevicePacket sSDSDevicePacket) throws IOException {
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        long l = sSDSDevicePacket.sourceID();
        long l2 = sSDSDevicePacket.getPlatformID();
        int n = sSDSDevicePacket.getPacketType();
        long l3 = sSDSDevicePacket.getRecordType();
        long l4 = sSDSDevicePacket.getMetadataSequenceNumber();
        long l5 = sSDSDevicePacket.getDataDescriptionVersion();
        long l6 = sSDSDevicePacket.systemTime();
        long l7 = sSDSDevicePacket.sequenceNo();
        byte[] byArray2 = sSDSDevicePacket.getDataBuffer();
        byte[] byArray3 = sSDSDevicePacket.getOtherBuffer();
        dataOutputStream.writeLong(l);
        dataOutputStream.writeLong(l2);
        if (n == 0) {
            dataOutputStream.writeInt(1);
        } else if (n == 1) {
            dataOutputStream.writeInt(0);
        } else if (n == 2) {
            dataOutputStream.writeInt(4);
        }
        if (n == 0) {
            dataOutputStream.writeLong(0L);
        } else {
            dataOutputStream.writeLong(l3);
        }
        dataOutputStream.writeLong(l4);
        dataOutputStream.writeLong(l5);
        long l8 = l6 / 1000L;
        long l9 = l6 % 1000L * 1000L;
        dataOutputStream.writeLong(l8);
        dataOutputStream.writeLong(l9);
        dataOutputStream.writeLong(l7);
        if (byArray2 != null) {
            dataOutputStream.writeInt(byArray2.length);
            dataOutputStream.write(byArray2);
        } else {
            dataOutputStream.writeInt(1);
            dataOutputStream.write(new byte[1]);
        }
        if (byArray3 != null) {
            dataOutputStream.writeInt(byArray3.length);
            dataOutputStream.write(byArray3);
        } else {
            dataOutputStream.writeInt(1);
            dataOutputStream.write(new byte[1]);
        }
        byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    public String toString() {
        String string = null;
        String string2 = null;
        string = this.dataBuffer != null ? new String(this.getDataBuffer()) : new String("");
        string2 = this.getOtherBuffer() != null ? new String(this.getOtherBuffer()) : new String("");
        String string3 = new String("SSDSDevicePacket:deviceID=" + this.sourceID() + ";sequenceNumber=" + this.sequenceNo() + ";packetType=" + this.getPacketType() + ";metadataSequenceNumber=" + this.getMetadataSequenceNumber() + ";dataDescriptionVersion=" + this.getDataDescriptionVersion() + ";platformID=" + this.getPlatformID() + ";recordType=" + this.getRecordType() + ";dataBuffer=" + string + ";otherBuffer=" + string2);
        return string3;
    }
}

