/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.services.metadata;

import java.util.Collection;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import moos.ssds.dao.StandardUnitDAO;
import moos.ssds.dao.util.MetadataAccessException;
import moos.ssds.metadata.IMetadataObject;
import moos.ssds.metadata.StandardUnit;
import moos.ssds.services.metadata.AccessBean;
import moos.ssds.services.metadata.IMetadataAccess;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class StandardUnitAccessEJB
extends AccessBean
implements IMetadataAccess {
    private static final long serialVersionUID = 1L;
    static Logger logger = Logger.getLogger(StandardUnitAccessEJB.class);

    public void ejbCreate() throws CreateException {
        logger.debug("ejbCreate called");
        logger.debug("Going to read in the properties");
        this.servicesMetadataProperties = new Properties();
        try {
            this.servicesMetadataProperties.load(this.getClass().getResourceAsStream("/moos/ssds/services/metadata/servicesMetadata.properties"));
        }
        catch (Exception exception) {
            logger.error("Exception trying to read in properties file: " + exception.getMessage());
        }
        if (this.servicesMetadataProperties != null) {
            logger.debug("Loaded props OK");
        } else {
            logger.warn("Could not load the servicesMetadata.properties.");
        }
        try {
            InitialContext initialContext = new InitialContext();
            this.sessionFactory = (SessionFactory)initialContext.lookup(this.servicesMetadataProperties.getProperty("metadata.hibernate.jndi.name"));
        }
        catch (NamingException namingException) {
            logger.error("NamingException caught when trying to get hibernate's SessionFactory from JNDI: " + namingException.getMessage());
        }
        super.setPersistentClass(StandardUnit.class);
        super.setDaoClass(StandardUnitDAO.class);
    }

    public IMetadataObject findByName(String string) throws MetadataAccessException {
        StandardUnitDAO standardUnitDAO = new StandardUnitDAO((Session)this.sessionFactory.getCurrentSession());
        return standardUnitDAO.findByName(string);
    }

    public Collection findByLikeName(String string) throws MetadataAccessException {
        StandardUnitDAO standardUnitDAO = new StandardUnitDAO((Session)this.sessionFactory.getCurrentSession());
        return standardUnitDAO.findByLikeName(string);
    }

    public Collection findBySymbol(String string) throws MetadataAccessException {
        StandardUnitDAO standardUnitDAO = new StandardUnitDAO((Session)this.sessionFactory.getCurrentSession());
        return standardUnitDAO.findBySymbol(string);
    }

    public Collection findByLikeSymbol(String string) throws MetadataAccessException {
        StandardUnitDAO standardUnitDAO = new StandardUnitDAO((Session)this.sessionFactory.getCurrentSession());
        return standardUnitDAO.findByLikeSymbol(string);
    }

    public Collection findAllNames() throws MetadataAccessException {
        StandardUnitDAO standardUnitDAO = new StandardUnitDAO((Session)this.sessionFactory.getCurrentSession());
        return standardUnitDAO.findAllNames();
    }
}

