/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.services.metadata;

import java.util.Collection;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import moos.ssds.dao.StandardDomainDAO;
import moos.ssds.dao.StandardReferenceScaleDAO;
import moos.ssds.dao.util.MetadataAccessException;
import moos.ssds.metadata.StandardReferenceScale;
import moos.ssds.services.metadata.AccessBean;
import moos.ssds.services.metadata.IMetadataAccess;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class StandardReferenceScaleAccessEJB
extends AccessBean
implements IMetadataAccess {
    private static final long serialVersionUID = 1L;
    static Logger logger = Logger.getLogger(StandardReferenceScaleAccessEJB.class);

    public void ejbCreate() throws CreateException {
        logger.debug("ejbCreate called");
        logger.debug("Going to read in the properties");
        this.servicesMetadataProperties = new Properties();
        try {
            this.servicesMetadataProperties.load(this.getClass().getResourceAsStream("/moos/ssds/services/metadata/servicesMetadata.properties"));
        }
        catch (Exception exception) {
            logger.error("Exception trying to read in properties file: " + exception.getMessage());
        }
        if (this.servicesMetadataProperties != null) {
            logger.debug("Loaded props OK");
        } else {
            logger.warn("Could not load the servicesMetadata.properties.");
        }
        try {
            InitialContext initialContext = new InitialContext();
            this.sessionFactory = (SessionFactory)initialContext.lookup(this.servicesMetadataProperties.getProperty("metadata.hibernate.jndi.name"));
        }
        catch (NamingException namingException) {
            logger.error("NamingException caught when trying to get hibernate's SessionFactory from JNDI: " + namingException.getMessage());
        }
        super.setPersistentClass(StandardReferenceScale.class);
        super.setDaoClass(StandardReferenceScaleDAO.class);
    }

    public Collection findByName(String string) throws MetadataAccessException {
        StandardDomainDAO standardDomainDAO = new StandardDomainDAO((Session)this.sessionFactory.getCurrentSession());
        return standardDomainDAO.findByName(string);
    }

    public Collection findByLikeName(String string) throws MetadataAccessException {
        StandardReferenceScaleDAO standardReferenceScaleDAO = new StandardReferenceScaleDAO((Session)this.sessionFactory.getCurrentSession());
        return standardReferenceScaleDAO.findByLikeName(string);
    }

    public Collection findAllNames() throws MetadataAccessException {
        StandardReferenceScaleDAO standardReferenceScaleDAO = new StandardReferenceScaleDAO((Session)this.sessionFactory.getCurrentSession());
        return standardReferenceScaleDAO.findAllNames();
    }
}

