/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.services.metadata;

import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import moos.ssds.dao.SoftwareDAO;
import moos.ssds.dao.util.MetadataAccessException;
import moos.ssds.metadata.Person;
import moos.ssds.metadata.Software;
import moos.ssds.services.metadata.AccessBean;
import moos.ssds.services.metadata.IMetadataAccess;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class SoftwareAccessEJB
extends AccessBean
implements IMetadataAccess {
    private static final long serialVersionUID = 1L;
    static Logger logger = Logger.getLogger(SoftwareAccessEJB.class);

    public void ejbCreate() throws CreateException {
        logger.debug("ejbCreate called");
        logger.debug("Going to read in the properties");
        this.servicesMetadataProperties = new Properties();
        try {
            this.servicesMetadataProperties.load(this.getClass().getResourceAsStream("/moos/ssds/services/metadata/servicesMetadata.properties"));
        }
        catch (Exception exception) {
            logger.error("Exception trying to read in properties file: " + exception.getMessage());
        }
        if (this.servicesMetadataProperties != null) {
            logger.debug("Loaded props OK");
        } else {
            logger.warn("Could not load the servicesMetadata.properties.");
        }
        try {
            InitialContext initialContext = new InitialContext();
            this.sessionFactory = (SessionFactory)initialContext.lookup(this.servicesMetadataProperties.getProperty("metadata.hibernate.jndi.name"));
        }
        catch (NamingException namingException) {
            logger.error("NamingException caught when trying to get hibernate's SessionFactory from JNDI: " + namingException.getMessage());
        }
        super.setPersistentClass(Software.class);
        super.setDaoClass(SoftwareDAO.class);
    }

    public Collection findByName(String string) throws MetadataAccessException {
        SoftwareDAO softwareDAO = new SoftwareDAO((Session)this.sessionFactory.getCurrentSession());
        return softwareDAO.findByName(string);
    }

    public Collection findByLikeName(String string) throws MetadataAccessException {
        SoftwareDAO softwareDAO = new SoftwareDAO((Session)this.sessionFactory.getCurrentSession());
        return softwareDAO.findByLikeName(string);
    }

    public Collection findAllNames() throws MetadataAccessException {
        SoftwareDAO softwareDAO = new SoftwareDAO((Session)this.sessionFactory.getCurrentSession());
        return softwareDAO.findAllNames();
    }

    public Software findByNameAndSoftwareVersion(String string, String string2) throws MetadataAccessException {
        SoftwareDAO softwareDAO = new SoftwareDAO((Session)this.sessionFactory.getCurrentSession());
        return softwareDAO.findByNameAndSoftwareVersion(string, string2);
    }

    public Collection findByURIString(String string) throws MetadataAccessException {
        SoftwareDAO softwareDAO = new SoftwareDAO((Session)this.sessionFactory.getCurrentSession());
        return softwareDAO.findByURIString(string);
    }

    public Collection findByURI(URI uRI) throws MetadataAccessException {
        SoftwareDAO softwareDAO = new SoftwareDAO((Session)this.sessionFactory.getCurrentSession());
        return softwareDAO.findByURI(uRI);
    }

    public Collection findByURL(URL uRL) throws MetadataAccessException {
        SoftwareDAO softwareDAO = new SoftwareDAO((Session)this.sessionFactory.getCurrentSession());
        return softwareDAO.findByURL(uRL);
    }

    public Collection findByPerson(Person person) throws MetadataAccessException {
        SoftwareDAO softwareDAO = new SoftwareDAO((Session)this.sessionFactory.getCurrentSession());
        return softwareDAO.findByPerson(person);
    }
}

