/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.services.metadata;

import java.util.Collection;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import moos.ssds.dao.PersonDAO;
import moos.ssds.dao.util.MetadataAccessException;
import moos.ssds.metadata.IMetadataObject;
import moos.ssds.metadata.Person;
import moos.ssds.services.metadata.AccessBean;
import moos.ssds.services.metadata.IMetadataAccess;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class PersonAccessEJB
extends AccessBean
implements IMetadataAccess {
    private static final long serialVersionUID = 1L;
    static Logger logger = Logger.getLogger(PersonAccessEJB.class);

    public void ejbCreate() throws CreateException {
        logger.debug("ejbCreate called");
        logger.debug("Going to read in the properties");
        this.servicesMetadataProperties = new Properties();
        try {
            this.servicesMetadataProperties.load(this.getClass().getResourceAsStream("/moos/ssds/services/metadata/servicesMetadata.properties"));
        }
        catch (Exception exception) {
            logger.error("Exception trying to read in properties file: " + exception.getMessage());
        }
        if (this.servicesMetadataProperties != null) {
            logger.debug("Loaded props OK");
        } else {
            logger.warn("Could not load the servicesMetadata.properties.");
        }
        try {
            InitialContext initialContext = new InitialContext();
            this.sessionFactory = (SessionFactory)initialContext.lookup(this.servicesMetadataProperties.getProperty("metadata.hibernate.jndi.name"));
        }
        catch (NamingException namingException) {
            logger.error("NamingException caught when trying to get hibernate's SessionFactory from JNDI: " + namingException.getMessage());
        }
        super.setPersistentClass(Person.class);
        super.setDaoClass(PersonDAO.class);
    }

    public Collection findByEmail(String string) throws MetadataAccessException {
        PersonDAO personDAO = new PersonDAO((Session)this.sessionFactory.getCurrentSession());
        return personDAO.findByEmail(string);
    }

    public IMetadataObject findByUsername(String string) throws MetadataAccessException {
        logger.debug("findByUsername called with username " + string);
        PersonDAO personDAO = new PersonDAO((Session)this.sessionFactory.getCurrentSession());
        return personDAO.findByUsername(string);
    }

    public Collection findAllUsernames() throws MetadataAccessException {
        logger.debug("findAllUsernames called");
        PersonDAO personDAO = new PersonDAO((Session)this.sessionFactory.getCurrentSession());
        return personDAO.findAllUsernames();
    }
}

