/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.services.metadata;

import java.util.Collection;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import moos.ssds.dao.DeviceDAO;
import moos.ssds.dao.util.MetadataAccessException;
import moos.ssds.metadata.Device;
import moos.ssds.metadata.DeviceType;
import moos.ssds.metadata.IMetadataObject;
import moos.ssds.metadata.Person;
import moos.ssds.services.metadata.AccessBean;
import moos.ssds.services.metadata.IMetadataAccess;
import org.apache.log4j.Logger;
import org.doomdark.uuid.UUID;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class DeviceAccessEJB
extends AccessBean
implements IMetadataAccess {
    private static final long serialVersionUID = 1L;
    static Logger logger = Logger.getLogger(DeviceAccessEJB.class);

    public void ejbCreate() throws CreateException {
        logger.debug("ejbCreate called");
        logger.debug("Going to read in the properties");
        this.servicesMetadataProperties = new Properties();
        try {
            this.servicesMetadataProperties.load(this.getClass().getResourceAsStream("/moos/ssds/services/metadata/servicesMetadata.properties"));
        }
        catch (Exception exception) {
            logger.error("Exception trying to read in properties file: " + exception.getMessage());
        }
        if (this.servicesMetadataProperties != null) {
            logger.debug("Loaded props OK");
        } else {
            logger.warn("Could not load the servicesMetadata.properties.");
        }
        try {
            InitialContext initialContext = new InitialContext();
            this.sessionFactory = (SessionFactory)initialContext.lookup(this.servicesMetadataProperties.getProperty("metadata.hibernate.jndi.name"));
        }
        catch (NamingException namingException) {
            logger.error("NamingException caught when trying to get hibernate's SessionFactory from JNDI: " + namingException.getMessage());
        }
        super.setPersistentClass(Device.class);
        super.setDaoClass(DeviceDAO.class);
    }

    public IMetadataObject findByUuid(String string, boolean bl) throws MetadataAccessException {
        DeviceDAO deviceDAO = new DeviceDAO((Session)this.sessionFactory.getCurrentSession());
        return deviceDAO.findByUuid(string, bl);
    }

    public IMetadataObject findByUuid(byte[] byArray, boolean bl) throws MetadataAccessException {
        UUID uUID = UUID.valueOf(byArray);
        if (uUID == null) {
            return null;
        }
        return this.findByUuid(uUID.toString(), bl);
    }

    public Collection findByName(String string, String string2, String string3, boolean bl) throws MetadataAccessException {
        DeviceDAO deviceDAO = new DeviceDAO((Session)this.sessionFactory.getCurrentSession());
        return deviceDAO.findByName(string, string2, string3, bl);
    }

    public Collection findByLikeName(String string, String string2, String string3, boolean bl) throws MetadataAccessException {
        DeviceDAO deviceDAO = new DeviceDAO((Session)this.sessionFactory.getCurrentSession());
        return deviceDAO.findByLikeName(string, string2, string3, bl);
    }

    public Collection findByNameAndMfgInfo(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) throws MetadataAccessException {
        DeviceDAO deviceDAO = new DeviceDAO((Session)this.sessionFactory.getCurrentSession());
        return deviceDAO.findByNameAndMfgInfo(string, string2, string3, string4, string5, string6, bl);
    }

    public Collection findByPerson(Person person, String string, String string2, boolean bl) throws MetadataAccessException {
        DeviceDAO deviceDAO = new DeviceDAO((Session)this.sessionFactory.getCurrentSession());
        return deviceDAO.findByPerson(person, string, string2, bl);
    }

    public Collection findByDeviceType(DeviceType deviceType, String string, String string2, boolean bl) throws MetadataAccessException {
        DeviceDAO deviceDAO = new DeviceDAO((Session)this.sessionFactory.getCurrentSession());
        return deviceDAO.findByDeviceType(deviceType, string, string2, bl);
    }

    public Collection findAllIDs() throws MetadataAccessException {
        DeviceDAO deviceDAO = new DeviceDAO((Session)this.sessionFactory.getCurrentSession());
        return deviceDAO.findAllIDs();
    }

    public Collection findAllNames() throws MetadataAccessException {
        DeviceDAO deviceDAO = new DeviceDAO((Session)this.sessionFactory.getCurrentSession());
        return deviceDAO.findAllNames();
    }

    public Collection findAllManufacturerNames() throws MetadataAccessException {
        DeviceDAO deviceDAO = new DeviceDAO((Session)this.sessionFactory.getCurrentSession());
        return deviceDAO.findAllManufacturerNames();
    }

    public Collection findMfgModels(String string) throws MetadataAccessException {
        DeviceDAO deviceDAO = new DeviceDAO((Session)this.sessionFactory.getCurrentSession());
        return deviceDAO.findMfgModels(string);
    }

    public Collection findMfgSerialNumbers(String string, String string2) throws MetadataAccessException {
        DeviceDAO deviceDAO = new DeviceDAO((Session)this.sessionFactory.getCurrentSession());
        return deviceDAO.findMfgSerialNumbers(string, string2);
    }

    public Collection findBySearchingAllFieldsAndType(String string, String string2, String string3, boolean bl) throws MetadataAccessException {
        DeviceDAO deviceDAO = new DeviceDAO((Session)this.sessionFactory.getCurrentSession());
        return deviceDAO.findBySearchingAllFieldsAndType(string, string2, string3, bl);
    }
}

