/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.services.metadata;

import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import moos.ssds.dao.DataProducerDAO;
import moos.ssds.dao.util.MetadataAccessException;
import moos.ssds.metadata.DataContainer;
import moos.ssds.metadata.DataProducer;
import moos.ssds.metadata.DataProducerGroup;
import moos.ssds.metadata.Device;
import moos.ssds.metadata.Event;
import moos.ssds.metadata.Person;
import moos.ssds.metadata.Resource;
import moos.ssds.metadata.Software;
import moos.ssds.services.metadata.AccessBean;
import moos.ssds.services.metadata.IMetadataAccess;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class DataProducerAccessEJB
extends AccessBean
implements IMetadataAccess {
    private static final long serialVersionUID = 1L;
    static Logger logger = Logger.getLogger(DataProducerAccessEJB.class);

    public void ejbCreate() throws CreateException {
        logger.debug("ejbCreate called");
        logger.debug("Going to read in the properties");
        this.servicesMetadataProperties = new Properties();
        try {
            this.servicesMetadataProperties.load(this.getClass().getResourceAsStream("/moos/ssds/services/metadata/servicesMetadata.properties"));
        }
        catch (Exception exception) {
            logger.error("Exception trying to read in properties file: " + exception.getMessage());
        }
        if (this.servicesMetadataProperties != null) {
            logger.debug("Loaded props OK");
        } else {
            logger.warn("Could not load the servicesMetadata.properties.");
        }
        try {
            InitialContext initialContext = new InitialContext();
            this.sessionFactory = (SessionFactory)initialContext.lookup(this.servicesMetadataProperties.getProperty("metadata.hibernate.jndi.name"));
        }
        catch (NamingException namingException) {
            logger.error("NamingException caught when trying to get hibernate's SessionFactory from JNDI: " + namingException.getMessage());
        }
        super.setPersistentClass(DataProducer.class);
        super.setDaoClass(DataProducerDAO.class);
    }

    public Collection findByProperties(String string, boolean bl, String string2, Date date, boolean bl2, Date date2, boolean bl3, Double d, Double d2, Double d3, Double d4, Float f, Float f2, Float f3, Float f4, String string3, boolean bl4, String string4, String string5, boolean bl5) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findByProperties(string, bl, string2, date, bl2, date2, bl3, d, d2, d3, d4, f, f2, f3, f4, string3, bl4, string4, string5, bl5);
    }

    public int countFindByProperties(String string, boolean bl, String string2, Date date, boolean bl2, Date date2, boolean bl3, Double d, Double d2, Double d3, Double d4, Float f, Float f2, Float f3, Float f4, String string3, boolean bl4) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.countFindByProperties(string, bl, string2, date, bl2, date2, bl3, d, d2, d3, d4, f, f2, f3, f4, string3, bl4);
    }

    public Collection findByName(String string, boolean bl, String string2, String string3, boolean bl2) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findByName(string, bl, string2, string3, bl2);
    }

    public int countFindByName(String string, boolean bl) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.countFindByName(string, bl);
    }

    public Collection findByDataProducerTypeAndName(String string, String string2, String string3, String string4, boolean bl, boolean bl2) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findByDataProducerTypeAndName(string, string2, bl, string3, string4, bl2);
    }

    public int countFindByDataProducerTypeAndName(String string, String string2, boolean bl) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.countFindByDataProducerTypeAndName(string, string2, bl);
    }

    public Collection findParentlessDeployments(String string, String string2, boolean bl) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findParentlessDeployments(string, string2, bl);
    }

    public int countFindParentlessDeployments() throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.countFindParentlessDeployments();
    }

    public Collection findByDateRangeAndName(Date date, boolean bl, Date date2, boolean bl2, String string, boolean bl3, String string2, String string3, boolean bl4) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findByDateRangeAndName(date, bl, date2, bl2, string, bl3, string2, string3, bl4);
    }

    public int countFindByDateRangeAndName(Date date, boolean bl, Date date2, boolean bl2, String string, boolean bl3) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.countFindByDateRangeAndName(date, bl, date2, bl2, string, bl3);
    }

    public Collection findByGeospatialCube(Double d, Double d2, Double d3, Double d4, Float f, Float f2, String string, String string2, boolean bl) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findByGeospatialCube(d, d2, d3, d4, f, f2, string, string2, bl);
    }

    public int countFindByGeospatialCube(Double d, Double d2, Double d3, Double d4, Float f, Float f2) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.countFindByGeospatialCube(d, d2, d3, d4, f, f2);
    }

    public Collection findByTimeAndGeospatialCube(Date date, boolean bl, Date date2, boolean bl2, Double d, Double d2, Double d3, Double d4, Float f, Float f2, String string, String string2, boolean bl3) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findByTimeAndGeospatialCube(date, bl, date2, bl2, d, d2, d3, d4, f, f2, string, string2, bl3);
    }

    public int countFindByTimeAndGeospatialCube(Date date, boolean bl, Date date2, boolean bl2, Double d, Double d2, Double d3, Double d4, Float f, Float f2) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.countFindByTimeAndGeospatialCube(date, bl, date2, bl2, d, d2, d3, d4, f, f2);
    }

    public Collection findByNameAndGeospatialCube(String string, boolean bl, Double d, Double d2, Double d3, Double d4, Float f, Float f2, String string2, String string3, boolean bl2) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findByNameAndGeospatialCube(string, bl, d, d2, d3, d4, f, f2, string2, string3, bl2);
    }

    public int countFindByNameAndGeospatialCube(String string, boolean bl, Double d, Double d2, Double d3, Double d4, Float f, Float f2) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.countFindByNameAndGeospatialCube(string, bl, d, d2, d3, d4, f, f2);
    }

    public Collection findByNameAndTimeAndGeospatialCube(String string, boolean bl, Date date, boolean bl2, Date date2, boolean bl3, Double d, Double d2, Double d3, Double d4, Float f, Float f2, String string2, String string3, boolean bl4) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findByNameAndTimeAndGeospatialCube(string, bl, date, bl2, date2, bl3, d, d2, d3, d4, f, f2, string2, string3, bl4);
    }

    public int countFindByNameAndTimeAndGeospatialCube(String string, boolean bl, Date date, boolean bl2, Date date2, boolean bl3, Double d, Double d2, Double d3, Double d4, Float f, Float f2) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.countFindByNameAndTimeAndGeospatialCube(string, bl, date, bl2, date2, bl3, d, d2, d3, d4, f, f2);
    }

    public Collection findByHostName(String string, boolean bl, String string2, String string3, boolean bl2) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findByHostName(string, bl, string2, string3, bl2);
    }

    public int countFindByHostName(String string, boolean bl) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.countFindByHostName(string, bl);
    }

    public Collection findByPerson(Person person, String string, String string2, boolean bl) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findByPerson(person, string, string2, bl);
    }

    public int countFindByPerson(Person person) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.countFindByPerson(person);
    }

    public Collection findByDevice(Device device, String string, String string2, boolean bl) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findByDevice(device, string, string2, bl);
    }

    public Collection findByDeviceId(Long l, String string, String string2, boolean bl) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findByDeviceId(l, string, string2, bl);
    }

    public Collection findCurrentDeploymentsOfDevice(Device device, String string, String string2, boolean bl) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findCurrentDeploymentsOfDevice(device, string, string2, bl);
    }

    public Collection findCurrentDeploymentsOfDeviceId(Long l, String string, String string2, boolean bl) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findCurrentDeploymentsOfDeviceId(l, string, string2, bl);
    }

    public Collection findBySoftware(Software software, String string, String string2, boolean bl) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findBySoftware(software, string, string2, bl);
    }

    public DataProducer findParentDataProducer(DataProducer dataProducer, boolean bl) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findParentDataProducer(dataProducer, bl);
    }

    public Collection findChildDataProducers(DataProducer dataProducer, boolean bl) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findChildDataProducers(dataProducer, bl);
    }

    public int countFindChildDataProducers(DataProducer dataProducer) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.countFindChildDataProducers(dataProducer);
    }

    public Collection findByDataProducerGroup(DataProducerGroup dataProducerGroup, String string, String string2, boolean bl) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findByDataProducerGroup(dataProducerGroup, string, string2, bl);
    }

    public Collection findByDataProducerGroupName(String string, boolean bl, String string2, String string3, boolean bl2) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findByDataProducerGroupName(string, bl, string2, string3, bl2);
    }

    public int countFindByDataProducerGroupName(String string, boolean bl) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.countFindByDataProducerGroupName(string, bl);
    }

    public Collection findByInput(DataContainer dataContainer, String string, String string2, boolean bl) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findByInput(dataContainer, string, string2, bl);
    }

    public DataProducer findByOutput(DataContainer dataContainer, String string, String string2, boolean bl) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findByOutput(dataContainer, string, string2, bl);
    }

    public Collection findByResource(Resource resource, String string, String string2, boolean bl) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findByResource(resource, string, string2, bl);
    }

    public Collection findByEvent(Event event, String string, String string2, boolean bl) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findByEvent(event, string, string2, bl);
    }

    public Collection findAllDeploymentsOfDeviceTypeFromParent(DataProducer dataProducer, String string, Double d, Double d2, Double d3, Double d4, Float f, Double d5, String string2, String string3, boolean bl) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findAllDeploymentsOfDeviceTypeFromParent(dataProducer, string, d, d2, d3, d4, f, d5, string2, string3, bl);
    }

    public Collection findAllDeploymentsOfDeviceTypeFromParent(Long l, String string, Double d, Double d2, Double d3, Double d4, Float f, Double d5, String string2, String string3, boolean bl) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findAllDeploymentsOfDeviceTypeFromParent(l, string, d, d2, d3, d4, f, d5, string2, string3, bl);
    }

    public Collection findDevicesByParentByTypeAndByLocation(Long l, String string, Double d, Double d2, Double d3, Double d4, Float f, Double d5, String string2, String string3, boolean bl) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findDevicesByParentByTypeAndByLocation(l, string, d, d2, d3, d4, f, d5, string2, string3, bl);
    }

    public Collection findDevicesByParentByTypeAndByLocation(String string, String string2, Double d, Double d2, Double d3, Double d4, Float f, Double d5, String string3, String string4, boolean bl) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findDevicesByParentByTypeAndByLocation(string, string2, d, d2, d3, d4, f, d5, string3, string4, bl);
    }

    public Collection findAllDevicesByParentDeploymentByTypeAndByLocation(DataProducer dataProducer, String string, Double d, Double d2, Double d3, Double d4, Float f, Double d5, String string2, String string3, boolean bl) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findAllDevicesByParentDeploymentByTypeAndByLocation(dataProducer, string, d, d2, d3, d4, f, d5, string2, string3, bl);
    }

    public Collection findAllDevicesByParentByTypeAndByLocation(Long l, String string, Double d, Double d2, Double d3, Double d4, Float f, Double d5, String string2, String string3, boolean bl) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataProducerDAO.findAllDevicesByParentByTypeAndByLocation(l, string, d, d2, d3, d4, f, d5, string2, string3, bl);
    }

    public void addChildDataProducer(DataProducer dataProducer, DataProducer dataProducer2) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        dataProducerDAO.addChildDataProducer(dataProducer, dataProducer2);
    }

    public void deepDelete(DataProducer dataProducer) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        dataProducerDAO.makeDeepTransient(dataProducer);
    }

    public void makeDeepTransient(DataProducer dataProducer) throws MetadataAccessException {
        DataProducerDAO dataProducerDAO = new DataProducerDAO((Session)this.sessionFactory.getCurrentSession());
        dataProducerDAO.makeDeepTransient(dataProducer);
    }
}

