/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.services.metadata;

import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import moos.ssds.dao.DataContainerDAO;
import moos.ssds.dao.util.MetadataAccessException;
import moos.ssds.metadata.DataContainer;
import moos.ssds.metadata.DataContainerGroup;
import moos.ssds.metadata.DataProducer;
import moos.ssds.metadata.Person;
import moos.ssds.metadata.Resource;
import moos.ssds.services.metadata.AccessBean;
import moos.ssds.services.metadata.IMetadataAccess;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class DataContainerAccessEJB
extends AccessBean
implements IMetadataAccess {
    private static final long serialVersionUID = 1L;
    static Logger logger = Logger.getLogger(DataContainerAccessEJB.class);

    public void ejbCreate() throws CreateException {
        logger.debug("ejbCreate called");
        logger.debug("Going to read in the properties");
        this.servicesMetadataProperties = new Properties();
        try {
            this.servicesMetadataProperties.load(this.getClass().getResourceAsStream("/moos/ssds/services/metadata/servicesMetadata.properties"));
        }
        catch (Exception exception) {
            logger.error("Exception trying to read in properties file: " + exception.getMessage());
        }
        if (this.servicesMetadataProperties != null) {
            logger.debug("Loaded props OK");
        } else {
            logger.warn("Could not load the servicesMetadata.properties.");
        }
        try {
            InitialContext initialContext = new InitialContext();
            this.sessionFactory = (SessionFactory)initialContext.lookup(this.servicesMetadataProperties.getProperty("metadata.hibernate.jndi.name"));
        }
        catch (NamingException namingException) {
            logger.error("NamingException caught when trying to get hibernate's SessionFactory from JNDI: " + namingException.getMessage());
        }
        super.setPersistentClass(DataContainer.class);
        super.setDaoClass(DataContainerDAO.class);
    }

    public Collection findByName(String string, boolean bl, String string2, boolean bl2) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByName(string, bl, string2, bl2);
    }

    public int countFindByName(String string, boolean bl) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.countFindByName(string, bl);
    }

    public Collection findAllNames() throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findAllNames();
    }

    public Collection findByDataContainerTypeAndName(String string, String string2, boolean bl, boolean bl2) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByDataContainerTypeAndName(string, string2, bl, bl2);
    }

    public int countFindByDataContainerTypeAndName(String string, String string2, boolean bl) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.countFindByDataContainerTypeAndName(string, string2, bl);
    }

    public Collection findWithDataWithinTimeWindow(Date date, boolean bl, Date date2, boolean bl2) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findWithDataWithinTimeWindow(date, bl, date2, bl2);
    }

    public DataContainer findByURIString(String string) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByURIString(string);
    }

    public Collection findByURI(URI uRI) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByURI(uRI);
    }

    public Collection findByURL(URL uRL) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByURL(uRL);
    }

    public Collection findAllURIStrings() throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findAllURIStrings();
    }

    public Collection findByMimeType(String string) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByMimeType(string);
    }

    public Collection findWithinGeospatialCube(Double d, Double d2, Double d3, Double d4, Double d5, Double d6) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findWithinGeospatialCube(d, d2, d3, d4, d5, d6);
    }

    public Collection findWithinTimeAndGeospatialCube(Date date, Date date2, Double d, Double d2, Double d3, Double d4, Double d5, Double d6) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findWithinTimeAndGeospatialCube(date, date2, d, d2, d3, d4, d5, d6);
    }

    public Collection findByPerson(Person person) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByPerson(person);
    }

    public Collection findByRecordVariableName(String string) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByRecordVariableName(string);
    }

    public Collection findByLikeRecordVariableName(String string) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByLikeRecordVariableName(string);
    }

    public Collection findByStandardVariableName(String string) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByStandardVariableName(string);
    }

    public Collection findByLikeStandardVariableName(String string) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByLikeStandardVariableName(string);
    }

    public Collection findByDataContainerGroup(DataContainerGroup dataContainerGroup) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByDataContainerGroup(dataContainerGroup);
    }

    public Collection findByDataContainerGroupName(String string) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByDataContainerGroupName(string);
    }

    public Collection findByLikeDataContainerGroupName(String string) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByLikeDataContainerGroupName(string);
    }

    public Collection findByKeywordName(String string, boolean bl, boolean bl2) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByKeywordName(string, bl, bl2);
    }

    public int countFindByKeywordName(String string, boolean bl) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.countFindByKeywordName(string, bl);
    }

    public Collection findByResource(Resource resource) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByResource(resource);
    }

    public Collection findAllIndirectCreators(DataContainer dataContainer, int n) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findAllIndirectCreators(dataContainer, n);
    }

    public Collection findCreatorChain(DataContainer dataContainer, int n) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findCreatorChain(dataContainer, n);
    }

    public Collection findAllIndirectConsumers(DataContainer dataContainer, int n) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findAllIndirectConsumers(dataContainer, n);
    }

    public Collection findAllConsumers(DataContainer dataContainer, int n) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findAllConsumers(dataContainer, n);
    }

    public Collection findDirectInputs(DataContainer dataContainer) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findDirectInputs(dataContainer);
    }

    public Collection findAllInputs(DataContainer dataContainer, int n) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findAllInputs(dataContainer, n);
    }

    public Collection findAllDerivedOutputs(DataContainer dataContainer, int n) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findAllDerivedOutputs(dataContainer, n);
    }

    public Collection findAllDerivedOutputs(DataProducer dataProducer, int n) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findAllDerivedOutputs(dataProducer, n);
    }

    public Collection findInputsByDataProducer(DataProducer dataProducer, String string, boolean bl) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findInputsByDataProducer(dataProducer, string, bl);
    }

    public Collection findOutputsByDataProducer(DataProducer dataProducer, String string, boolean bl) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findOutputsByDataProducer(dataProducer, string, bl);
    }

    public DataContainer findBestDirectOutput(DataProducer dataProducer) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findBestDirectOutput(dataProducer);
    }

    public Collection findByRecordVariableNameAndDataWithinTimeWindow(String string, Date date, Date date2) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByRecordVariableNameAndDataWithinTimeWindow(string, date, date2);
    }

    public Collection findByLikeRecordVariableNameAndDataWithinTimeWindow(String string, Date date, Date date2) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByLikeRecordVariableNameAndDataWithinTimeWindow(string, date, date2);
    }

    public Collection findByStandardVariableNameAndDataWithinTimeWindow(String string, Date date, Date date2) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByStandardVariableNameAndDataWithinTimeWindow(string, date, date2);
    }

    public Collection findByLikeStandardVariableNameAndDataWithinTimeWindow(String string, Date date, Date date2) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByLikeStandardVariableNameAndDataWithinTimeWindow(string, date, date2);
    }

    public Collection findByRecordVariableNameAndWithinGeospatialCube(String string, Double d, Double d2, Double d3, Double d4, Double d5, Double d6) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByRecordVariableNameAndWithinGeospatialCube(string, d, d2, d3, d4, d5, d6);
    }

    public Collection findByLikeRecordVariableNameAndWithinGeospatialCube(String string, Double d, Double d2, Double d3, Double d4, Double d5, Double d6) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByLikeRecordVariableNameAndWithinGeospatialCube(string, d, d2, d3, d4, d5, d6);
    }

    public Collection findByStandardVariableNameAndWithinGeospatialCube(String string, Double d, Double d2, Double d3, Double d4, Double d5, Double d6) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByStandardVariableNameAndWithinGeospatialCube(string, d, d2, d3, d4, d5, d6);
    }

    public Collection findByLikeStandardVariableNameAndWithinGeospatialCube(String string, Double d, Double d2, Double d3, Double d4, Double d5, Double d6) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByLikeStandardVariableNameAndWithinGeospatialCube(string, d, d2, d3, d4, d5, d6);
    }

    public Collection findByRecordVariableNameWithinTimeAndWithinGeospatialCube(String string, Date date, Date date2, Double d, Double d2, Double d3, Double d4, Double d5, Double d6) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByRecordVariableNameWithinTimeAndWithinGeospatialCube(string, date, date2, d, d2, d3, d4, d5, d6);
    }

    public Collection findByLikeRecordVariableNameWithinTimeAndWithinGeospatialCube(String string, Date date, Date date2, Double d, Double d2, Double d3, Double d4, Double d5, Double d6) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByLikeRecordVariableNameWithinTimeAndWithinGeospatialCube(string, date, date2, d, d2, d3, d4, d5, d6);
    }

    public Collection findByStandardVariableNameWithinTimeAndWithinGeospatialCube(String string, Date date, Date date2, Double d, Double d2, Double d3, Double d4, Double d5, Double d6) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByStandardVariableNameWithinTimeAndWithinGeospatialCube(string, date, date2, d, d2, d3, d4, d5, d6);
    }

    public Collection findByLikeStandardVariableNameWithinTimeAndWithinGeospatialCube(String string, Date date, Date date2, Double d, Double d2, Double d3, Double d4, Double d5, Double d6) throws MetadataAccessException {
        DataContainerDAO dataContainerDAO = new DataContainerDAO((Session)this.sessionFactory.getCurrentSession());
        return dataContainerDAO.findByLikeStandardVariableNameWithinTimeAndWithinGeospatialCube(string, date, date2, d, d2, d3, d4, d5, d6);
    }
}

