/*
 * Decompiled with CFR 0.152.
 */
package moos.ssds.services.metadata;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import moos.ssds.dao.MetadataDAO;
import moos.ssds.dao.util.MetadataAccessException;
import moos.ssds.metadata.IMetadataObject;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public abstract class AccessBean
implements SessionBean {
    private SessionContext ctx;
    protected Properties servicesMetadataProperties;
    protected SessionFactory sessionFactory = null;
    protected Class persistentClass = null;
    protected Class daoClass = null;
    static Logger superLogger = Logger.getLogger(AccessBean.class);

    public SessionContext getSessionContext() {
        return this.ctx;
    }

    public void setSessionContext(SessionContext sessionContext) throws EJBException, RemoteException {
        this.ctx = sessionContext;
    }

    protected Class getPersistentClass() {
        return this.persistentClass;
    }

    protected void setPersistentClass(Class clazz) {
        this.persistentClass = clazz;
    }

    protected Class getDaoClass() {
        return this.daoClass;
    }

    protected void setDaoClass(Class clazz) {
        this.daoClass = clazz;
    }

    public IMetadataObject findById(Long l, boolean bl) throws MetadataAccessException {
        MetadataDAO metadataDAO = this.getMetadataDAO();
        return metadataDAO.findById(l, bl);
    }

    public IMetadataObject findById(long l, boolean bl) throws MetadataAccessException {
        Long l2 = null;
        try {
            l2 = new Long(l);
        }
        catch (Throwable throwable) {
            String string = new String("Could not convert the long " + l + " into a Long object: " + throwable.getMessage());
            throw new MetadataAccessException(string);
        }
        return this.findById(l2, bl);
    }

    public IMetadataObject findById(String string, boolean bl) throws MetadataAccessException {
        superLogger.debug("findById(String) called with id = " + string);
        if (string == null) {
            throw new MetadataAccessException("Failed: incoming id was null");
        }
        Long l = null;
        try {
            l = new Long(string);
        }
        catch (Throwable throwable) {
            String string2 = new String("Could not convert the string " + string + " into a Long object: " + throwable.getMessage());
            throw new MetadataAccessException(string2);
        }
        return this.findById(l, bl);
    }

    public Collection findAllIDs() throws MetadataAccessException {
        MetadataDAO metadataDAO = this.getMetadataDAO();
        return metadataDAO.findAllIDs();
    }

    public int countFindAllIDs() throws MetadataAccessException {
        MetadataDAO metadataDAO = this.getMetadataDAO();
        return metadataDAO.countFindAllIDs();
    }

    public Collection findAll(String string, boolean bl) throws MetadataAccessException {
        MetadataDAO metadataDAO = this.getMetadataDAO();
        return metadataDAO.findAll(string, bl);
    }

    public Collection findBySQL(String string, String string2, Class clazz, boolean bl) throws MetadataAccessException {
        MetadataDAO metadataDAO = this.getMetadataDAO();
        return metadataDAO.findBySQL(string, string2, clazz, bl);
    }

    public Long findId(IMetadataObject iMetadataObject) throws MetadataAccessException {
        MetadataDAO metadataDAO = this.getMetadataDAO();
        return metadataDAO.findId(iMetadataObject);
    }

    public IMetadataObject findEquivalentPersistentObject(IMetadataObject iMetadataObject, boolean bl) throws MetadataAccessException {
        MetadataDAO metadataDAO = this.getMetadataDAO();
        return metadataDAO.findEquivalentPersistentObject(iMetadataObject, bl);
    }

    public IMetadataObject getMetadataObjectGraph(IMetadataObject iMetadataObject) throws MetadataAccessException {
        MetadataDAO metadataDAO = this.getMetadataDAO();
        return metadataDAO.getMetadataObjectGraph(iMetadataObject);
    }

    public Long insert(IMetadataObject iMetadataObject) throws MetadataAccessException {
        MetadataDAO metadataDAO = this.getMetadataDAO();
        Long l = metadataDAO.findId(iMetadataObject);
        if (l != null) {
            throw new MetadataAccessException("Metadata already exists in storage, no insert performed");
        }
        return metadataDAO.makePersistent(iMetadataObject);
    }

    public Long update(IMetadataObject iMetadataObject) throws MetadataAccessException {
        MetadataDAO metadataDAO = this.getMetadataDAO();
        Long l = metadataDAO.findId(iMetadataObject);
        if (l == null) {
            throw new MetadataAccessException("No matching metadata was found to update");
        }
        return metadataDAO.makePersistent(iMetadataObject);
    }

    public void delete(IMetadataObject iMetadataObject) throws MetadataAccessException {
        MetadataDAO metadataDAO = this.getMetadataDAO();
        metadataDAO.makeTransient(iMetadataObject);
    }

    public Long makePersistent(IMetadataObject iMetadataObject) throws MetadataAccessException {
        MetadataDAO metadataDAO = this.getMetadataDAO();
        return metadataDAO.makePersistent(iMetadataObject);
    }

    public void makeTransient(IMetadataObject iMetadataObject) throws MetadataAccessException {
        MetadataDAO metadataDAO = this.getMetadataDAO();
        metadataDAO.makeTransient(iMetadataObject);
    }

    public void ejbActivate() throws EJBException, RemoteException {
    }

    public void ejbPassivate() throws EJBException, RemoteException {
    }

    public void ejbRemove() throws EJBException, RemoteException {
    }

    public void ejbPostCreate() throws CreateException {
    }

    private MetadataDAO getMetadataDAO() throws MetadataAccessException {
        MetadataDAO metadataDAO = null;
        try {
            metadataDAO = (MetadataDAO)this.daoClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
            superLogger.error("InstantiationException caught trying to instantiate the DAO instance: " + instantiationException.getMessage());
            throw new MetadataAccessException("InstantiationException caught trying to instantiate the DAO instance: " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            superLogger.error("IllegalAccessException caught trying to instantiate the DAO instance: " + illegalAccessException.getMessage());
            throw new MetadataAccessException("IllegalAccessException caught trying to instantiate the DAO instance: " + illegalAccessException.getMessage());
        }
        metadataDAO.setPersistentClass(this.getPersistentClass());
        metadataDAO.setSession((Session)this.sessionFactory.getCurrentSession());
        return metadataDAO;
    }
}

